<?php

declare(strict_types=1);

require_once __DIR__ . '/includes/helpers.php';
require_once __DIR__ . '/includes/auth.php';
require_once __DIR__ . '/includes/documents.php';

pemohon_require_login();

$currentUser = pemohon_current_user();
if ($currentUser === null) {
    http_response_code(401);
    exit('Tidak dibenarkan.');
}

$userId = (int) ($currentUser['id'] ?? 0);
if ($userId <= 0) {
    http_response_code(401);
    exit('Tidak dibenarkan.');
}

$documentId = isset($_GET['id']) ? (int) $_GET['id'] : 0;
if ($documentId <= 0) {
    http_response_code(404);
    exit('Dokumen tidak ditemui.');
}

try {
    $document = pemohon_find_document($userId, $documentId);
} catch (Throwable $exception) {
    http_response_code(500);
    exit('Gagal memuatkan dokumen.');
}

if (!$document) {
    http_response_code(404);
    exit('Dokumen tidak ditemui.');
}

$storedPath = (string) ($document['stored_path'] ?? '');
$normalizedPath = ltrim(str_replace('\\', '/', $storedPath), '/');
if ($normalizedPath === '') {
    http_response_code(404);
    exit('Dokumen tidak ditemui.');
}

$absolutePath = dirname(__DIR__) . '/' . $normalizedPath;
if (!is_file($absolutePath) || !is_readable($absolutePath)) {
    http_response_code(404);
    exit('Fail dokumen tidak ditemui.');
}

$mimeType = (string) ($document['mime_type'] ?? 'application/pdf');
if ($mimeType === '' || stripos($mimeType, 'pdf') === false) {
    $mimeType = 'application/pdf';
}

$fileSize = filesize($absolutePath);
$originalName = (string) ($document['original_filename'] ?? 'dokumen.pdf');
$safeName = preg_replace('/[^A-Za-z0-9._-]/', '_', $originalName) ?: 'dokumen.pdf';

header('Content-Type: ' . $mimeType);
header('Content-Disposition: inline; filename="' . $safeName . '"');
if ($fileSize !== false) {
    header('Content-Length: ' . (string) $fileSize);
}
header('X-Content-Type-Options: nosniff');

readfile($absolutePath);
