<?php

declare(strict_types=1);

require_once __DIR__ . '/db.php';

function pemohon_get_applicant_id(int $userId): ?int
{
    if ($userId <= 0) {
        return null;
    }

    $db = pemohon_db();
    $stmt = $db->prepare('SELECT id FROM applicants WHERE user_id = ? LIMIT 1');
    if (!$stmt) {
        throw new \RuntimeException('Failed to prepare statement: ' . $db->error);
    }

    $stmt->bind_param('i', $userId);
    $stmt->execute();
    $stmt->bind_result($applicantId);
    $hasRow = $stmt->fetch();
    $stmt->close();

    if (!$hasRow) {
        return null;
    }

    return (int) $applicantId;
}
