<?php

declare(strict_types=1);

namespace App\Controllers;

use App\Core\Controller;
use App\Core\Request;
use App\Core\Response;
use App\Core\Session;

class ApplicationController extends Controller
{
    public function __construct(Request $request, Response $response, Session $session)
    {
        parent::__construct($request, $response, $session);
    }

    public function index(): void
    {
        $applications = [
            ['number' => 'ETA-2025-0001', 'applicant' => 'Ali Ahmad', 'type' => 'Tauliah Agama', 'status' => 'Dalam Semakan', 'submitted_at' => '2025-01-10'],
            ['number' => 'ETA-2025-0002', 'applicant' => 'Siti Aminah', 'type' => 'Tauliah Al-Quran', 'status' => 'Diluluskan', 'submitted_at' => '2025-01-12'],
        ];

        $pageScripts = <<<'SCRIPT'
<script>
    document.addEventListener('DOMContentLoaded', function () {
        if (!window.jQuery) {
            return;
        }

        var $table = $('#applications-table');
        if (!$table.length || $.fn.DataTable.isDataTable($table)) {
            return;
        }

        $table.DataTable({
            data: JSON.parse($table.attr('data-source') || '[]'),
            columns: [
                { data: 'number', title: 'No. Permohonan' },
                { data: 'applicant', title: 'Nama Pemohon' },
                { data: 'type', title: 'Jenis' },
                { data: 'status', title: 'Status Semasa' },
                { data: 'submitted_at', title: 'Tarikh Hantar' }
            ],
            responsive: true,
            dom: 'Bfrtip',
            buttons: ['copy', 'csv', 'excel', 'pdf', 'print'],
        });
    });
</script>
SCRIPT;

        $this->view('dashboard.applications', [
            'title' => 'Senarai Permohonan',
            'applications' => $applications,
            'applicationsJson' => json_encode($applications, JSON_UNESCAPED_UNICODE),
            'pageScripts' => $pageScripts,
        ]);
    }
}
