<?php

declare(strict_types=1);

namespace App\Core;

final class Autoloader
{
    /** @var array<string, string> */
    private static array $prefixes = [];

    public static function register(string $basePath): void
    {
        spl_autoload_register(function (string $class) use ($basePath): void {
            $prefix = 'App\\';
            $len = strlen($prefix);
            if (strncmp($prefix, $class, $len) !== 0) {
                return;
            }

            $relativeClass = substr($class, $len);
            $file = $basePath . '/app/' . str_replace('\\', '/', $relativeClass) . '.php';

            if (is_file($file)) {
                require $file;
            }
        });
    }
}
