<?php

declare(strict_types=1);

namespace App\Core;

class Response
{
    public function redirect(string $location): void
    {
        header('Location: ' . $location);
        exit;
    }

    public function json(array $data, int $status = 200): void
    {
        http_response_code($status);
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode($data);
        exit;
    }
}
