<?php

declare(strict_types=1);

namespace App\Core;

use RuntimeException;

class View
{
    public static function render(string $view, array $data = [], string $layout = 'app'): void
    {
        $viewPath = self::viewPath($view);
        if (!is_file($viewPath)) {
            throw new RuntimeException("View {$view} not found.");
        }

        $renderContent = static function () use ($viewPath, $data): void {
            extract($data, EXTR_SKIP);
            require $viewPath;
        };

        $pageScripts = $data['pageScripts'] ?? null;
        $title = $data['title'] ?? null;

        $layoutPath = __DIR__ . '/../../resources/views/layouts/' . $layout . '.php';

        if (is_file($layoutPath)) {
            extract($data, EXTR_SKIP);
            require $layoutPath;
            return;
        }

        $renderContent();
    }

    private static function viewPath(string $view): string
    {
        $view = str_replace(['.', '\\'], '/', $view);
        return __DIR__ . '/../../resources/views/' . $view . '.php';
    }
}
