<?php

return [
    'pemohon' => [
        'label' => 'Modul Pemohon',
        'icon' => 'fas fa-user-graduate',
        'roles' => ['admin', 'pentadbir', 'pentadbir_agong'],
        'description' => 'Menguruskan keseluruhan kitaran hidup pemohon daripada pendaftaran sehingga pengeluaran kad digital.',
        'items' => [
            [
                'key' => 'pemohon.account_registration',
                'label' => 'Pendaftaran Akaun',
                'path' => '/modules/applicant/account-registration',
                'icon' => 'fas fa-user-plus',
                'roles' => ['admin', 'pentadbir_agong'],
                'description' => 'Daftar pemohon baharu, tetapkan status akaun dan urus pengesahan keselamatan.',
                'capabilities' => [
                    'Semakan dokumen pengenalan dan kelayakan asas pemohon.',
                    'Pengesahan e-mel serta tetapan akses awal akaun.',
                    'Integrasi dengan audit trail untuk rekod perubahan.',
                ],
            ],
            [
                'key' => 'pemohon.applications',
                'label' => 'Permohonan Baharu & Pembaharuan',
                'path' => '/modules/applicant/applications',
                'icon' => 'fas fa-file-signature',
                'roles' => ['admin', 'pentadbir', 'pentadbir_agong'],
                'description' => 'Urus permohonan baharu, pembaharuan dan status keseluruhan permohonan pemohon.',
                'capabilities' => [
                    'Penerimaan permohonan secara atas talian dengan semakan kelayakan automatik.',
                    'Penjejakan status masa nyata untuk permohonan baharu dan pembaharuan.',
                    'Penyediaan ringkasan permohonan untuk panel dan urusetia.',
                ],
            ],
            [
                'key' => 'pemohon.documents',
                'label' => 'Pengurusan Dokumen',
                'path' => '/modules/applicant/documents',
                'icon' => 'fas fa-folder-open',
                'roles' => ['admin', 'pentadbir'],
                'description' => 'Mengurus muat naik, semakan dan kelulusan dokumen sokongan permohonan.',
                'capabilities' => [
                    'Pengesahan format dan saiz dokumen secara automatik.',
                    'Penandaan dokumen kritikal dan permintaan dokumen tambahan.',
                    'Integrasi dengan storan selamat MyGovCloud.',
                ],
            ],
            [
                'key' => 'pemohon.status_notifications',
                'label' => 'Status Permohonan & Notifikasi',
                'path' => '/modules/applicant/status',
                'icon' => 'fas fa-bell',
                'roles' => ['admin', 'pentadbir'],
                'description' => ' Penghantaran notifikasi e-mel/SMS dan paparan status permohonan terkini.',
                'capabilities' => [
                    'Konfigurasi templat notifikasi dinamik.',
                    'Penjadualan peringatan automatik untuk tindakan lanjut.',
                    'Rekod log penghantaran untuk audit komunikasi.',
                ],
            ],
            [
                'key' => 'pemohon.payments',
                'label' => 'Bayaran Atas Talian',
                'path' => '/modules/applicant/payments',
                'icon' => 'fas fa-credit-card',
                'roles' => ['admin', 'pentadbir'],
                'description' => 'Mengurus transaksi bayaran atas talian melalui integrasi MelakaPay.',
                'capabilities' => [
                    'Penyelarasan status pembayaran dengan permohonan.',
                    'Pengurusan resit digital dan rekonsiliasi kewangan.',
                    'Laporan transaksi harian dan eksport kewangan.',
                ],
            ],
            [
                'key' => 'pemohon.digital_card',
                'label' => 'Kad Digital QR',
                'path' => '/modules/applicant/digital-card',
                'icon' => 'fas fa-qrcode',
                'roles' => ['admin', 'pentadbir_agong'],
                'description' => 'Penjanaan kad digital tauliah dengan ciri pengesahan QR.',
                'capabilities' => [
                    'Penjanaan kod QR unik dengan metadata keselamatan.',
                    'Penyegerakan status kad dengan tarikh luput tauliah.',
                    'Pengesahan awam melalui portal semakan kad.',
                ],
            ],
        ],
    ],
    'urusetia' => [
        'label' => 'Modul Urusetia',
        'icon' => 'fas fa-briefcase',
        'roles' => ['admin', 'pentadbir', 'pentadbir_agong'],
        'description' => 'Memusatkan operasi urusetia termasuk semakan, temuduga, surat rasmi dan laporan automatik.',
        'items' => [
            [
                'key' => 'urusetia.applications_review',
                'label' => 'Semakan Permohonan',
                'path' => '/modules/secretariat/applications-review',
                'icon' => 'fas fa-search',
                'roles' => ['admin', 'pentadbir'],
                'description' => 'Semak, sahkan dan susun keutamaan permohonan yang diterima.',
                'capabilities' => [
                    'Penilaian awal dan semakan kelengkapan permohonan.',
                    'Pengagihan permohonan kepada panel penilai.',
                    'Rekod catatan urusetia terhadap pemohon.',
                ],
            ],
            [
                'key' => 'urusetia.approvals',
                'label' => 'Kelulusan & Surat Rasmi',
                'path' => '/modules/secretariat/approvals',
                'icon' => 'fas fa-check-circle',
                'roles' => ['admin', 'pentadbir_agong'],
                'description' => 'Pengurusan kelulusan dan automasi surat rasmi berkaitan tauliah.',
                'capabilities' => [
                    'Templat surat kelulusan/penolakan automatik.',
                    'Laluan kelulusan bertingkat untuk pihak pengurusan.',
                    'Rekod digital surat dan e-tandatangan.',
                ],
            ],
            [
                'key' => 'urusetia.interview_schedule',
                'label' => 'Jadual Temuduga',
                'path' => '/modules/secretariat/interview-schedule',
                'icon' => 'fas fa-calendar-alt',
                'roles' => ['admin', 'pentadbir'],
                'description' => 'Penjadualan sesi temuduga, jemputan panel dan notifikasi pemohon.',
                'capabilities' => [
                    'Penyelarasan jadual panel dan bilik temuduga.',
                    'Notifikasi automatik kepada pemohon dan panel.',
                    'Laporan kehadiran temuduga secara langsung.',
                ],
            ],
            [
                'key' => 'urusetia.reports',
                'label' => 'Laporan Automatik',
                'path' => '/modules/secretariat/reports',
                'icon' => 'fas fa-chart-bar',
                'roles' => ['admin', 'pentadbir_agong'],
                'description' => 'Menjana laporan operasi harian, mingguan dan bulanan secara automatik.',
                'capabilities' => [
                    'Templat laporan boleh ubah mengikut keperluan pengurusan.',
                    'Eksport pantas ke format PDF, Excel dan CSV.',
                    'Penjadualan penghantaran laporan automatik melalui e-mel.',
                ],
            ],
            [
                'key' => 'urusetia.activity_log',
                'label' => 'Log Aktiviti & Dashboard',
                'path' => '/modules/secretariat/activity-log',
                'icon' => 'fas fa-clipboard-list',
                'roles' => ['admin', 'pentadbir'],
                'description' => 'Dashboard operasi dan penjejakan aktiviti urusetia secara terperinci.',
                'capabilities' => [
                    'Log aktiviti lengkap bagi tindakan urusetia.',
                    'Penanda aras SLA dan indikator prestasi utama.',
                    'Pengesanan tindakan luar biasa untuk audit keselamatan.',
                ],
            ],
            [
                'key' => 'urusetia.certificate_verification',
                'label' => 'Pengesahan Sijil',
                'path' => '/modules/secretariat/certificate-verification',
                'icon' => 'fas fa-certificate',
                'roles' => ['admin', 'pentadbir_agong'],
                'description' => 'Sahkan keaslian sijil tauliah dan urus permohonan salinan rasmi.',
                'capabilities' => [
                    'Semakan silang dengan pangkalan data kad digital.',
                    'Penjanaan bukti sahih untuk agensi luaran.',
                    'Integrasi permohonan salinan sah dengan modul pembayaran.',
                ],
            ],
        ],
    ],
    'panel' => [
        'label' => 'Modul Panel Penilai / JKPPAI',
        'icon' => 'fas fa-users',
        'roles' => ['admin', 'pentadbir', 'pentadbir_agong'],
        'description' => 'Memudahkan panel penilai menjalankan temuduga, penilaian dan mesyuarat secara digital.',
        'items' => [
            [
                'key' => 'panel.interviews',
                'label' => 'Senarai Temuduga',
                'path' => '/modules/panel/interviews',
                'icon' => 'fas fa-list-alt',
                'roles' => ['admin', 'pentadbir'],
                'description' => 'Senarai temuduga terkini bersama maklumat pemohon dan status kehadiran.',
                'capabilities' => [
                    'Penapis pintar mengikut tarikh, jenis tauliah dan status.',
                    'Integrasi ke modul jadual temuduga urusetia.',
                    'Catatan segera selepas sesi temuduga.',
                ],
            ],
            [
                'key' => 'panel.evaluations',
                'label' => 'Penilaian & Markah',
                'path' => '/modules/panel/evaluations',
                'icon' => 'fas fa-star-half-alt',
                'roles' => ['admin', 'pentadbir'],
                'description' => 'Pengisian markah dan penilaian pemohon oleh panel secara serentak.',
                'capabilities' => [
                    'Rubrik penilaian digital dengan pemberat automatik.',
                    'Sokongan penilaian berbilang panel dengan agregasi markah.',
                    'Audit trail terhadap sebarang perubahan markah.',
                ],
            ],
            [
                'key' => 'panel.comments',
                'label' => 'Komen Digital',
                'path' => '/modules/panel/comments',
                'icon' => 'fas fa-comment-dots',
                'roles' => ['admin', 'pentadbir'],
                'description' => 'Pengumpulan komen panel secara terpusat bagi setiap permohonan.',
                'capabilities' => [
                    'Tag komen untuk tindakan lanjut urusetia.',
                    'Penandaan komen rahsia untuk bacaan panel sahaja.',
                    'Jejak perubahan komen untuk tujuan audit.',
                ],
            ],
            [
                'key' => 'panel.meetings',
                'label' => 'e-Mesyuarat JKPPAI',
                'path' => '/modules/panel/meetings',
                'icon' => 'fas fa-handshake',
                'roles' => ['admin', 'pentadbir_agong'],
                'description' => 'Pengurusan agenda, minit dan keputusan mesyuarat JKPPAI secara digital.',
                'capabilities' => [
                    'Penyediaan agenda automatik berdasarkan status permohonan.',
                    'Rakaman minit mesyuarat dan tindakan susulan.',
                    'Penerbitan keputusan rasmi kepada pihak berkepentingan.',
                ],
            ],
            [
                'key' => 'panel.digital_signature',
                'label' => 'Tandatangan Digital',
                'path' => '/modules/panel/digital-signature',
                'icon' => 'fas fa-pen-fancy',
                'roles' => ['admin', 'pentadbir_agong'],
                'description' => 'Pengurusan tandatangan digital untuk kelulusan rasmi tauliah.',
                'capabilities' => [
                    'Validasi tandatangan mengikut piawaian keselamatan.',
                    'Jejak audit untuk setiap tandatangan elektronik.',
                    'Integrasi dengan modul surat rasmi dan sijil digital.',
                ],
            ],
            [
                'key' => 'panel.decision_report',
                'label' => 'Laporan Keputusan',
                'path' => '/modules/panel/decision-report',
                'icon' => 'fas fa-poll-h',
                'roles' => ['admin', 'pentadbir_agong'],
                'description' => 'Ringkasan keputusan penilaian panel untuk sokongan pengurusan.',
                'capabilities' => [
                    'Paparan statistik keputusan mengikut kategori tauliah.',
                    'Eksport laporan keputusan untuk Mesyuarat dan audit.',
                    'Perbandingan trend penilaian sepanjang tahun.',
                ],
            ],
        ],
    ],
    'sistem' => [
        'label' => 'Modul Pentadbir Sistem',
        'icon' => 'fas fa-cogs',
        'roles' => ['admin', 'pentadbir_agong'],
        'description' => 'Mengawal konfigurasi teknikal, keselamatan dan integrasi utama sistem e-Tauliah.',
        'items' => [
            [
                'key' => 'sistem.users',
                'label' => 'Pengurusan Pengguna',
                'path' => '/modules/admin/users',
                'icon' => 'fas fa-user-shield',
                'roles' => ['admin', 'pentadbir_agong'],
                'description' => 'Pengurusan akaun pentadbir, panel dan urusetia serta kawalan akses.',
                'capabilities' => [
                    'Penetapan peranan dan kebenaran terperinci.',
                    'Penggantungan akaun sementara atau kekal.',
                    'Jejak perubahan kritikal pada profil pengguna.',
                ],
            ],
            [
                'key' => 'sistem.settings',
                'label' => 'Konfigurasi Sistem',
                'path' => '/modules/admin/settings',
                'icon' => 'fas fa-sliders-h',
                'roles' => ['admin', 'pentadbir_agong'],
                'description' => 'Konfigurasi global sistem termasuk parameter keselamatan dan operasi.',
                'capabilities' => [
                    'Pengurusan konfigurasi aplikasi dan integrasi.',
                    'Tetapan keselamatan seperti polisi kata laluan dan SSO.',
                    'Penjadualan cuti umum dan jadual operasi sistem.',
                ],
            ],
            [
                'key' => 'sistem.notifications',
                'label' => 'Pengumuman',
                'path' => '/modules/admin/notifications',
                'icon' => 'fas fa-bullhorn',
                'roles' => ['admin', 'pentadbir_agong'],
                'description' => 'Pengumuman untuk pemohon supaya maklumat terkini dapat disampaikan',
                'capabilities' => [
                    'Pemboleh ubah templat untuk setiap modul utama.',
                    'Pengujian A/B mesej untuk komunikasi rasmi.',
                    'Log penghantaran dan statistik kadar respon.',
                ],
            ],
            [
                'key' => 'sistem.audit_trail',
                'label' => 'Audit Trail',
                'path' => '/modules/admin/audit-trail',
                'icon' => 'fas fa-shield-alt',
                'roles' => ['admin', 'pentadbir_agong'],
                'description' => 'Jejak audit menyeluruh bagi setiap tindakan pengguna dan sistem.',
                'capabilities' => [
                    'Carian pantas berdasarkan pengguna, modul dan tarikh.',
                    'Amaran proaktif bagi aktiviti mencurigakan.',
                    'Eksport bukti untuk keperluan audit pematuhan.',
                ],
            ],
            [
                'key' => 'sistem.backup',
                'label' => 'Backup & Restore',
                'path' => '/modules/admin/backup',
                'icon' => 'fas fa-database',
                'roles' => ['admin', 'pentadbir_agong'],
                'description' => 'Pengurusan sandaran pangkalan data, fail dan pemulihan kecemasan.',
                'capabilities' => [
                    'Penjadualan sandaran automatik dan storan luar tapak.',
                    'Pemantauan status sandaran dan amaran kegagalan.',
                    'Prosedur pemulihan berturutan dengan panduan langkah demi langkah.',
                ],
            ],
            [
                'key' => 'sistem.integrations',
                'label' => 'Integrasi MyGovCloud & ONCC',
                'path' => '/modules/admin/integrations',
                'icon' => 'fas fa-plug',
                'roles' => ['admin', 'pentadbir_agong'],
                'description' => 'Mengurus integrasi perkhidmatan luaran termasuk MyGovCloud, MelakaPay dan ONCC.',
                'capabilities' => [
                    'Pemantauan status API dan kesihatan sambungan.',
                    'Pengurusan kunci rahsia dan kelayakan integrasi.',
                    'Log transaksi integrasi untuk audit teknikal.',
                ],
            ],
            [
                'key' => 'sistem.public_verification',
                'label' => 'Semakan Awam',
                'path' => '/modules/admin/public-verification',
                'icon' => 'fas fa-search-location',
                'roles' => ['admin', 'pentadbir_agong'],
                'description' => 'Menetapkan portal semakan awam bagi pengesahan tauliah dan kad digital.',
                'capabilities' => [
                    'Konfigurasi hasil semakan untuk orang awam.',
                    'Integrasi keselamatan bagi perlindungan data peribadi.',
                    'Statistik carian awam untuk memantau penggunaan.',
                ],
            ],
            [
                'key' => 'sistem.payment_report',
                'label' => 'Laporan Bayaran',
                'path' => '/modules/admin/payment-report',
                'icon' => 'fas fa-file-invoice-dollar',
                'roles' => ['admin', 'pentadbir_agong'],
                'description' => 'Menjana laporan kewangan dan rekonsiliasi bayaran berkaitan tauliah.',
                'capabilities' => [
                    'Paparan trend kutipan mengikut tempoh dan kategori tauliah.',
                    'Perbandingan data dengan rekod MelakaPay.',
                    'Eksport laporan bayaran untuk audit kewangan.',
                ],
            ],
        ],
    ],
    'laporan' => [
        'label' => 'Modul Laporan & Analitik',
        'icon' => 'fas fa-chart-line',
        'roles' => ['admin', 'pentadbir', 'pentadbir_agong'],
        'description' => 'Paparan visual, analitik dan eksport data bagi menyokong keputusan strategik.',
        'items' => [
            [
                'key' => 'laporan.analytics',
                'label' => 'Dashboard Analitik',
                'path' => '/modules/reports/analytics',
                'icon' => 'fas fa-chart-pie',
                'roles' => ['admin', 'pentadbir_agong'],
                'description' => 'Dashboard interaktif memaparkan KPI permohonan, kelulusan dan trend.',
                'capabilities' => [
                    'Graf masa nyata dengan penapis mengikut jenis tauliah.',
                    'Heatmap permohonan mengikut daerah dan kategori.',
                    'Sokongan AI untuk cadangan tindakan awal.',
                ],
            ],
            [
                'key' => 'laporan.export',
                'label' => 'Eksport Data',
                'path' => '/modules/reports/export',
                'icon' => 'fas fa-file-export',
                'roles' => ['admin', 'pentadbir'],
                'description' => 'Eksport data terkawal ke format PDF, Excel dan CSV mengikut peranan.',
                'capabilities' => [
                    'Penjanaan laporan ad hoc berdasarkan penapis dinamik.',
                    'Sokongan jadual eksport berulang.',
                    'Penyulitan fail sebelum muat turun.',
                ],
            ],
            [
                'key' => 'laporan.data_lake',
                'label' => 'Integrasi Data Raya',
                'path' => '/modules/reports/data-lake',
                'icon' => 'fas fa-database',
                'roles' => ['admin', 'pentadbir_agong'],
                'description' => 'Integrasi data dengan Dashboard Data Raya Kerajaan Negeri dan platform analitik.',
                'capabilities' => [
                    'Penjadualan penghantaran data ke data lake negeri.',
                    'Penyamaran data sensitif sebelum perkongsian.',
                    'Pemantauan penggunaan dataset dan akses luaran.',
                ],
            ],
        ],
    ],
];
