<?php

use App\Controllers\AuthController;
use App\Controllers\DashboardController;
use App\Controllers\ApplicationController;
use App\Controllers\ApplicantAccountController;
use App\Controllers\ApplicantApplicationsController;
use App\Controllers\NotificationsController;
use App\Controllers\ModulePageController;
use App\Controllers\PasswordResetController;

return [
    [
        'method' => 'GET',
        'path' => '/',
        'handler' => [AuthController::class, 'showAdminLogin'],
        'name' => 'login',
        'middleware' => ['guest'],
    ],
    [
        'method' => 'POST',
        'path' => '/login',
        'handler' => [AuthController::class, 'adminLogin'],
        'name' => 'login.submit',
        'middleware' => ['guest'],
    ],
    [
        'method' => 'POST',
        'path' => '/password/forgot',
        'handler' => [PasswordResetController::class, 'sendTemporaryPassword'],
        'name' => 'password.forgot',
        'middleware' => ['guest'],
    ],
    [
        'method' => 'GET',
        'path' => '/reset_password.php',
        'handler' => [PasswordResetController::class, 'showResetForm'],
        'name' => 'password.reset.form',
        'middleware' => ['guest'],
    ],
    [
        'method' => 'POST',
        'path' => '/reset_password.php',
        'handler' => [PasswordResetController::class, 'handleReset'],
        'name' => 'password.reset.handle',
        'middleware' => ['guest'],
    ],
    [
        'method' => 'GET',
        'path' => '/logout',
        'handler' => [AuthController::class, 'logout'],
        'name' => 'logout',
        'middleware' => ['auth'],
    ],
    [
        'method' => 'GET',
        'path' => '/dashboard',
        'handler' => [DashboardController::class, 'index'],
        'name' => 'dashboard',
        'middleware' => ['auth'],
    ],
    [
        'method' => 'GET',
        'path' => '/dashboard/applicant',
        'handler' => [DashboardController::class, 'applicant'],
        'name' => 'dashboard.applicant',
        'middleware' => ['auth:applicant'],
    ],
    [
        'method' => 'GET',
        'path' => '/applications',
        'handler' => [ApplicationController::class, 'index'],
        'name' => 'applications.index',
        'middleware' => ['auth:admin,pentadbir'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/applicant/account-registration',
        'handler' => [ApplicantAccountController::class, 'index'],
        'name' => 'modules.applicant.account_registration',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'POST',
        'path' => '/modules/applicant/account-registration',
        'handler' => [ApplicantAccountController::class, 'store'],
        'name' => 'modules.applicant.account_registration.store',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'POST',
        'path' => '/modules/applicant/account-registration/update',
        'handler' => [ApplicantAccountController::class, 'update'],
        'name' => 'modules.applicant.account_registration.update',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'POST',
        'path' => '/modules/applicant/account-registration/delete',
        'handler' => [ApplicantAccountController::class, 'destroy'],
        'name' => 'modules.applicant.account_registration.delete',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/applicant/applications',
        'handler' => [ApplicantApplicationsController::class, 'index'],
        'name' => 'modules.applicant.applications',
        'middleware' => ['auth:admin,pentadbir,pentadbir_agong'],
    ],
    [
        'method' => 'POST',
        'path' => '/modules/applicant/applications/update',
        'handler' => [ApplicantApplicationsController::class, 'update'],
        'name' => 'modules.applicant.applications.update',
        'middleware' => ['auth:admin,pentadbir,pentadbir_agong'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/applicant/documents',
        'handler' => [ModulePageController::class, 'applicantDocuments'],
        'name' => 'modules.applicant.documents',
        'middleware' => ['auth:admin,pentadbir'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/applicant/status',
        'handler' => [ModulePageController::class, 'applicantStatusNotifications'],
        'name' => 'modules.applicant.status',
        'middleware' => ['auth:admin,pentadbir'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/applicant/payments',
        'handler' => [ModulePageController::class, 'applicantPayments'],
        'name' => 'modules.applicant.payments',
        'middleware' => ['auth:admin,pentadbir'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/applicant/digital-card',
        'handler' => [ModulePageController::class, 'applicantDigitalCard'],
        'name' => 'modules.applicant.digital_card',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/secretariat/applications-review',
        'handler' => [ModulePageController::class, 'secretariatApplicationsReview'],
        'name' => 'modules.secretariat.applications_review',
        'middleware' => ['auth:admin,pentadbir'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/secretariat/approvals',
        'handler' => [ModulePageController::class, 'secretariatApprovals'],
        'name' => 'modules.secretariat.approvals',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/secretariat/interview-schedule',
        'handler' => [ModulePageController::class, 'secretariatInterviewSchedule'],
        'name' => 'modules.secretariat.interview_schedule',
        'middleware' => ['auth:admin,pentadbir'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/secretariat/reports',
        'handler' => [ModulePageController::class, 'secretariatReports'],
        'name' => 'modules.secretariat.reports',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/secretariat/activity-log',
        'handler' => [ModulePageController::class, 'secretariatActivityLog'],
        'name' => 'modules.secretariat.activity_log',
        'middleware' => ['auth:admin,pentadbir'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/secretariat/certificate-verification',
        'handler' => [ModulePageController::class, 'secretariatCertificateVerification'],
        'name' => 'modules.secretariat.certificate_verification',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/panel/interviews',
        'handler' => [ModulePageController::class, 'panelInterviews'],
        'name' => 'modules.panel.interviews',
        'middleware' => ['auth:admin,pentadbir'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/panel/evaluations',
        'handler' => [ModulePageController::class, 'panelEvaluations'],
        'name' => 'modules.panel.evaluations',
        'middleware' => ['auth:admin,pentadbir'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/panel/comments',
        'handler' => [ModulePageController::class, 'panelComments'],
        'name' => 'modules.panel.comments',
        'middleware' => ['auth:admin,pentadbir'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/panel/meetings',
        'handler' => [ModulePageController::class, 'panelMeetings'],
        'name' => 'modules.panel.meetings',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/panel/digital-signature',
        'handler' => [ModulePageController::class, 'panelDigitalSignature'],
        'name' => 'modules.panel.digital_signature',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/panel/decision-report',
        'handler' => [ModulePageController::class, 'panelDecisionReport'],
        'name' => 'modules.panel.decision_report',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/admin/users',
        'handler' => [ModulePageController::class, 'systemUsers'],
        'name' => 'modules.system.users',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/admin/settings',
        'handler' => [ModulePageController::class, 'systemSettings'],
        'name' => 'modules.system.settings',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/admin/notifications',
        'handler' => [NotificationsController::class, 'index'],
        'name' => 'modules.system.notifications',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'POST',
        'path' => '/modules/admin/notifications/save',
        'handler' => [NotificationsController::class, 'save'],
        'name' => 'modules.system.notifications.save',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'POST',
        'path' => '/modules/admin/notifications/delete',
        'handler' => [NotificationsController::class, 'delete'],
        'name' => 'modules.system.notifications.delete',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/admin/audit-trail',
        'handler' => [ModulePageController::class, 'systemAuditTrail'],
        'name' => 'modules.system.audit_trail',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/admin/backup',
        'handler' => [ModulePageController::class, 'systemBackup'],
        'name' => 'modules.system.backup',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/admin/integrations',
        'handler' => [ModulePageController::class, 'systemIntegrations'],
        'name' => 'modules.system.integrations',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/admin/public-verification',
        'handler' => [ModulePageController::class, 'systemPublicVerification'],
        'name' => 'modules.system.public_verification',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/admin/payment-report',
        'handler' => [ModulePageController::class, 'systemPaymentReport'],
        'name' => 'modules.system.payment_report',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/reports/analytics',
        'handler' => [ModulePageController::class, 'reportsAnalytics'],
        'name' => 'modules.reports.analytics',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/reports/export',
        'handler' => [ModulePageController::class, 'reportsExport'],
        'name' => 'modules.reports.export',
        'middleware' => ['auth:admin,pentadbir'],
    ],
    [
        'method' => 'GET',
        'path' => '/modules/reports/data-lake',
        'handler' => [ModulePageController::class, 'reportsDataLake'],
        'name' => 'modules.reports.data_lake',
        'middleware' => ['auth:admin,pentadbir_agong'],
    ],
];
