<?php

use App\Controllers\AuthController;
use App\Controllers\DashboardController;

return [
    [
        'method' => 'GET',
        'path' => '/',
        'handler' => [AuthController::class, 'showApplicantLogin'],
        'name' => 'applicant.login',
        'middleware' => ['guest'],
    ],
    [
        'method' => 'POST',
        'path' => '/login',
        'handler' => [AuthController::class, 'applicantLogin'],
        'name' => 'applicant.login.submit',
        'middleware' => ['guest'],
    ],
    [
        'method' => 'GET',
        'path' => '/logout',
        'handler' => [AuthController::class, 'logout'],
        'name' => 'applicant.logout',
        'middleware' => ['auth'],
    ],
    [
        'method' => 'GET',
        'path' => '/dashboard',
        'handler' => [DashboardController::class, 'applicant'],
        'name' => 'applicant.dashboard',
        'middleware' => ['auth:applicant'],
    ],
];
