<?php
$statuses = $statuses ?? [
    'pending' => 'Menunggu Pengesahan',
    'active' => 'Aktif',
    'suspended' => 'Digantung',
    'deactivated' => 'Dinyahaktifkan',
];
?>
<style>
    .bg-secondary {
        background-color: #b5b5b5 !important;
    }

    .badge.bg-secondary {
        background-color: #b5b5b5 !important;
        color: #212529 !important;
    }

    .account-registration-form .filepond--wrapper,
    .account-registration-form .filepond--root {
        width: 100%;
        margin-bottom: 1rem;
    }

    .account-registration-form .filepond--panel-root {
        border-radius: 16px;
        border: 2px dashed #e9ecef;
        background-color: #fafafa;
    }

    .account-registration-form .filepond--drop-label {
        color: #6c757d;
        font-size: 0.95rem;
        font-weight: 500;
    }

    .account-registration-form .filepond--item-panel {
        border-radius: 12px;
    }

    .account-registration-form .filepond--credits {
        display: none !important;
    }
</style>
<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row page-titles">
            <div class="col-md-5 align-self-center">
                <h4 class="text-themecolor mb-0">Pendaftaran Akaun Pemohon</h4>
                <small class="text-muted d-block">Daftar akaun pemohon baharu dan urus status akses.</small>
            </div>
            <div class="col-md-7 align-self-center text-end">
                <div class="d-flex justify-content-end align-items-center">
                    <ol class="breadcrumb justify-content-end">
                        <li class="breadcrumb-item"><a href="<?php echo route('/dashboard'); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item active">Pendaftaran Pemohon</li>
                    </ol>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-4 col-md-5">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title" id="applicant-form-title" data-edit-title="Kemaskini Maklumat Pemohon">Maklumat Akaun Baharu</h4>
                        <div class="alert d-none" id="applicant-form-alert" role="alert"></div>
                        <form id="applicant-form" class="account-registration-form" method="POST" action="<?php echo route('/modules/applicant/account-registration'); ?>" enctype="multipart/form-data" autocomplete="off">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="user_id" id="reg-user-id" value="">
                            <div class="mb-3">
                                <label for="reg-name" class="form-label">Nama Penuh <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="reg-name" name="name" required>
                                <div class="invalid-feedback"></div>
                            </div>
                            <div class="mb-3">
                                <label for="reg-email" class="form-label">Alamat Emel <span class="text-danger">*</span></label>
                                <input type="email" class="form-control" id="reg-email" name="email" required autocomplete="off">
                                <div class="invalid-feedback"></div>
                            </div>
                            <div class="mb-3">
                                <label for="reg-nric" class="form-label">No. Kad Pengenalan <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="reg-nric" name="nric" maxlength="12" inputmode="numeric" pattern="\d{12}" placeholder="Contoh: 900101015555" required>
                                <div class="invalid-feedback"></div>
                                <small class="form-text text-muted">Masukkan 12 digit tanpa sengkang.</small>
                            </div>
                            <div class="mb-3">
                                <label for="reg-phone" class="form-label">No. Telefon</label>
                                <input type="text" class="form-control" id="reg-phone" name="phone" placeholder="+6012 345 6789">
                                <div class="invalid-feedback"></div>
                            </div>
                            <div class="mb-3">
                                <label for="reg-status" class="form-label">Status Akaun</label>
                                <select id="reg-status" name="status" class="form-select" data-default-value="pending">
                                    <?php foreach ($statuses as $value => $label): ?>
                                        <option value="<?php echo htmlspecialchars($value, ENT_QUOTES, 'UTF-8'); ?>">
                                            <?php echo htmlspecialchars($label, ENT_QUOTES, 'UTF-8'); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                            <div class="mb-3">
                                <label for="reg-password" class="form-label">Kata Laluan Sementara <span class="text-danger">*</span></label>
                                <input type="password" class="form-control" id="reg-password" name="password" minlength="8" required>
                                <div class="invalid-feedback"></div>
                                <small class="form-text text-muted">Pemohon akan diminta menukar kata laluan pada log masuk pertama. Kosongkan ketika kemaskini jika tidak menukar kata laluan.</small>
                            </div>
                            <div class="mb-3">
                                <label for="reg-password-confirm" class="form-label">Sahkan Kata Laluan <span class="text-danger">*</span></label>
                                <input type="password" class="form-control" id="reg-password-confirm" name="password_confirmation" minlength="8" required>
                                <div class="invalid-feedback"></div>
                                <small class="form-text text-muted">Isikan semula kata laluan. Kosongkan ketika kemaskini jika tidak menukar kata laluan.</small>
                            </div>
                            <div class="mb-3">
                                <label for="reg-photo" class="form-label">Foto Profil</label>
                                <input type="file" class="filepond" id="reg-photo" name="photo" accept="image/jpeg,image/png">
                                <small class="form-text text-muted">JPEG/PNG sehingga 5MB.</small>
                            </div>
                            <div class="d-flex justify-content-end align-items-center gap-2">
                                <button type="button" class="btn btn-outline-secondary d-none" id="applicant-form-cancel">
                                    <i class="fas fa-times me-1"></i> Batal Kemaskini
                                </button>
                                <button type="submit" class="btn btn-danger" id="applicant-form-submit" data-default-text="Daftar Akaun" data-edit-text="Kemaskini Akaun" data-loading-text="Memproses...">
                                    <i class="fas fa-user-plus me-1"></i> Daftar Akaun
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Panduan Ringkas</h4>
                        <ul class="list-unstyled mb-0">
                            <li class="mb-3"><i class="fas fa-id-card text-info me-2"></i> Semak kad pengenalan sebelum pendaftaran.</li>
                            <li class="mb-3"><i class="fas fa-envelope text-info me-2"></i> Pastikan emel sah untuk pengaktifan akaun.</li>
                            <li><i class="fas fa-lock text-info me-2"></i> Pemohon perlu menukar kata laluan selepas log masuk pertama.</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-lg-8 col-md-7">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Senarai Pemohon Berdaftar</h4>
                        <div class="table-responsive">
                            <table id="applicants-table" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Foto</th>
                                        <th>Nama</th>
                                        <th>Emel</th>
                                        <th>No. K/P</th>
                                        <th>Status</th>
                                        <th>Daftar Pada</th>
                                        <th>Log Masuk Terakhir</th>
                                        <th>Tindakan</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($applicants as $applicant): ?>
                                        <?php
                                        $photoPath = $applicant['photo_path'] ?? '';
                                        if ($photoPath) {
                                            $photoBaseUrl = '/' . ltrim($photoPath, '/');
                                            $photoUrl = $photoBaseUrl . '?v=' . urlencode((string) time());
                                        } else {
                                            $photoBaseUrl = asset('assets/images/users/1.jpg');
                                            $photoUrl = $photoBaseUrl;
                                        }

                                        $statusKey = $applicant['status'] ?? 'pending';
                                        $badgeClass = match ($statusKey) {
                                            'active' => 'badge bg-success',
                                            'suspended' => 'badge bg-warning',
                                            'deactivated' => 'badge bg-secondary',
                                            default => 'badge bg-info',
                                        };
                                        $statusLabel = $statuses[$statusKey] ?? ucfirst((string) $statusKey);

                                        $registeredRaw = $applicant['created_at'] ?? null;
                                        $registeredDisplay = $registeredRaw
                                            ? date('d/m/Y H:i', strtotime((string) $registeredRaw))
                                            : '-';

                                        $lastLoginRaw = $applicant['last_login_at'] ?? null;
                                        $lastLoginDisplay = $lastLoginRaw
                                            ? date('d/m/Y H:i', strtotime((string) $lastLoginRaw))
                                            : '-';

                                        $applicantPayload = [
                                            'id' => (int) ($applicant['id'] ?? 0),
                                            'name' => (string) ($applicant['name'] ?? ''),
                                            'email' => (string) ($applicant['email'] ?? ''),
                                            'nric' => (string) ($applicant['nric'] ?? ''),
                                            'phone' => (string) ($applicant['phone'] ?? ''),
                                            'status' => $statusKey,
                                            'statusLabel' => $statusLabel,
                                            'statusBadgeClass' => $badgeClass,
                                            'photoUrl' => $photoUrl,
                                            'photoPath' => (string) ($applicant['photo_path'] ?? ''),
                                            'registeredAtDisplay' => $registeredDisplay,
                                            'registeredAtRaw' => $registeredRaw,
                                            'lastLoginDisplay' => $lastLoginDisplay,
                                            'lastLoginRaw' => $lastLoginRaw,
                                        ];
                                        $buttonData = htmlspecialchars(json_encode($applicantPayload, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP), ENT_QUOTES, 'UTF-8');
                                        ?>
                                        <tr id="applicant-row-<?php echo (int) ($applicant['id'] ?? 0); ?>">
                                            <td class="text-center align-middle">
                                                <img src="<?php echo htmlspecialchars($photoUrl, ENT_QUOTES, 'UTF-8'); ?>" alt="Avatar" class="rounded-circle" style="width:48px;height:48px;object-fit:cover;">
                                            </td>
                                            <td class="align-middle"><?php echo htmlspecialchars($applicant['name'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                                            <td class="align-middle"><?php echo htmlspecialchars($applicant['email'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                                            <td class="align-middle"><?php echo htmlspecialchars($applicant['nric'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                                            <td class="text-center align-middle">
                                                <span class="<?php echo $badgeClass; ?>">
                                                    <?php echo htmlspecialchars($statusLabel, ENT_QUOTES, 'UTF-8'); ?>
                                                </span>
                                            </td>
                                            <td class="align-middle" data-order="<?php echo htmlspecialchars((string) $registeredRaw, ENT_QUOTES, 'UTF-8'); ?>">
                                                <?php echo htmlspecialchars($registeredDisplay, ENT_QUOTES, 'UTF-8'); ?>
                                            </td>
                                            <td class="align-middle" data-order="<?php echo htmlspecialchars((string) $lastLoginRaw, ENT_QUOTES, 'UTF-8'); ?>">
                                                <?php echo htmlspecialchars($lastLoginDisplay, ENT_QUOTES, 'UTF-8'); ?>
                                            </td>
                                            <td class="text-center align-middle">
                                                <div class="d-flex flex-column gap-2">
                                                    <button type="button" class="btn btn-sm btn-outline-primary js-edit-applicant" data-applicant="<?php echo $buttonData; ?>">
                                                        <i class="fas fa-edit me-1"></i> Kemaskini
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-outline-danger js-delete-applicant" data-applicant-id="<?php echo (int) ($applicant['id'] ?? 0); ?>" data-applicant-name="<?php echo htmlspecialchars($applicant['name'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                                                        <i class="fas fa-trash me-1"></i> Padam
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
