<?php
/** @var array<int, array<string, mixed>> $applications */
/** @var array<int, array{id:int,name:string}> $statusOptions */

$applications = $applications ?? [];
$statusOptions = $statusOptions ?? [];
?>
<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row page-titles">
            <div class="col-md-6 col-12 align-self-center">
                <h4 class="text-themecolor mb-0">Pengurusan Permohonan Pemohon</h4>
                <small class="text-muted">Semak, kemaskini status dan tindakan bagi setiap permohonan.</small>
            </div>
            <div class="col-md-6 col-12 align-self-center text-end">
                <ol class="breadcrumb justify-content-end mb-0">
                    <li class="breadcrumb-item"><a href="<?php echo route('/dashboard'); ?>">Dashboard</a></li>
                    <li class="breadcrumb-item active">Permohonan Pemohon</li>
                </ol>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div>
                                <h4 class="card-title mb-1">Senarai Permohonan</h4>
                                <p class="card-subtitle text-muted mb-0">
                                    Jumlah permohonan: <?php echo number_format(count($applications)); ?>
                                </p>
                            </div>
                            <div>
                                <button type="button" class="btn btn-light btn-sm" onclick="window.location.reload();">
                                    <i class="mdi mdi-refresh"></i> Muat Semula
                                </button>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table id="applications-table" class="table table-striped table-bordered align-middle">
                                <thead class="table-light">
                                    <tr>
                                        <th>No. Permohonan</th>
                                        <th>Pemohon</th>
                                        <th>Jenis Permohonan</th>
                                        <th>Jenis Tauliah</th>
                                        <th>Status Tauliah</th>
                                        <th>Status Sistem</th>
                                        <th>Kemaskini</th>
                                        <th>Tindakan</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!$applications): ?>
                                        <tr>
                                            <td colspan="8" class="text-center text-muted py-4">Tiada permohonan direkodkan.</td>
                                        </tr>
                                    <?php else: ?>
                                        <?php foreach ($applications as $application): ?>
                                            <tr
                                                data-application-id="<?php echo (int) $application['id']; ?>"
                                                data-application-json="<?php echo htmlspecialchars(json_encode($application, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES), ENT_QUOTES, 'UTF-8'); ?>"
                                            >
                                                <td>
                                                    <strong><?php echo htmlspecialchars($application['application_number'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></strong>
                                                    <br>
                                                    <span class="text-muted small">NRIC: <?php echo htmlspecialchars($application['applicant_nric'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></span>
                                                </td>
                                                <td>
                                                    <?php echo htmlspecialchars($application['applicant_name'] ?? '-', ENT_QUOTES, 'UTF-8'); ?><br>
                                                    <span class="text-muted small">
                                                        <?php echo htmlspecialchars($application['applicant_email'] ?? '-', ENT_QUOTES, 'UTF-8'); ?>
                                                        <?php if (!empty($application['applicant_phone'])): ?>
                                                            · <?php echo htmlspecialchars($application['applicant_phone'], ENT_QUOTES, 'UTF-8'); ?>
                                                        <?php endif; ?>
                                                    </span>
                                                </td>
                                                <td><?php echo htmlspecialchars($application['application_type_label'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                                                <td><?php echo htmlspecialchars($application['tauliah_type_label'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                                                <td>
                                                    <?php if (!empty($application['status_tauliah_name'])): ?>
                                                        <span class="badge bg-info text-dark"><?php echo htmlspecialchars($application['status_tauliah_name'], ENT_QUOTES, 'UTF-8'); ?></span>
                                                    <?php else: ?>
                                                        <span class="text-muted">Belum ditetapkan</span>
                                                    <?php endif; ?>
                                                    <?php if (!empty($application['admin_note'])): ?>
                                                        <div class="small text-muted mt-1">
                                                            <i class="mdi mdi-comment-text-outline"></i>
                                                            <?php echo htmlspecialchars($application['admin_note'], ENT_QUOTES, 'UTF-8'); ?>
                                                        </div>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <span class="badge bg-secondary text-dark"><?php echo htmlspecialchars($application['status_label'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></span>
                                                    <?php if (!empty($application['current_stage'])): ?>
                                                        <div class="small text-muted mt-1"><?php echo htmlspecialchars($application['current_stage'], ENT_QUOTES, 'UTF-8'); ?></div>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo htmlspecialchars($application['updated_at_display'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                                                <td>
                                                    <button type="button" class="btn btn-sm btn-outline-primary" data-action="edit-application">
                                                        <i class="mdi mdi-pencil"></i> Kemaskini
                                                    </button>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="applicationModal" tabindex="-1" aria-labelledby="applicationModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <form id="application-update-form" method="POST" action="<?php echo route('/modules/applicant/applications/update'); ?>">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="application_id" id="application-id" value="">
                <div class="modal-header">
                    <h5 class="modal-title" id="applicationModalLabel">Kemaskini Permohonan</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
                </div>
                <div class="modal-body">
                    <div id="application-update-feedback" class="alert d-none" role="alert"></div>
                    <div class="mb-3">
                        <label for="status-tauliah" class="form-label">Status Tauliah <span class="text-danger">*</span></label>
                        <select class="form-select" id="status-tauliah" name="status_tauliah_id" required>
                            <option value="">-- Pilih Status Tauliah --</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="status-note" class="form-label">Catatan Tindakan</label>
                        <textarea class="form-control" id="status-note" name="note" rows="4" maxlength="1000" placeholder="Contoh: Permohonan disemak dan menunggu tindakan urusetia."></textarea>
                        <div class="form-text text-muted">Catatan ini akan disimpan bersama rekod permohonan.</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light border" data-bs-dismiss="modal">Tutup</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="mdi mdi-content-save"></i> Simpan Kemaskini
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
