<?php
require base_path('header.php');

if (function_exists('session')) {
    $session = session();
    $flashSuccess = $session->getFlash('success');
    $flashError = $session->getFlash('error');
}
?>

<?php if (!empty($flashSuccess)): ?>
<div class="alert alert-success alert-dismissible fade show m-3" role="alert">
    <?php echo htmlspecialchars($flashSuccess, ENT_QUOTES, 'UTF-8'); ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
<?php endif; ?>

<?php if (!empty($flashError)): ?>
<div class="alert alert-danger alert-dismissible fade show m-3" role="alert">
    <?php echo htmlspecialchars($flashError, ENT_QUOTES, 'UTF-8'); ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
<?php endif; ?>

<?php $renderContent(); ?>

<?php require base_path('footer.php'); ?>
