<?php
if (!defined('MAILGUN_INC_SKIP_SEND')) {
    define('MAILGUN_INC_SKIP_SEND', true);
}
include __DIR__ . '/mailgun_inc.php';

$recipient = $mailto ?? '';
$subject = $subject ?? '';
$htmlBody = $body ?? '';
$organizerEmail = $organizer_email ?? null;

if ($recipient === '' || $subject === '' || $htmlBody === '') {
    error_log('Mailgun send skipped: missing mandatory fields.');
    return false;
}

$apiUrl = 'https://api.mailgun.net/v3/' . $mailgun_domain . '/messages';
$postData = [
    'from'       => $mailgun_from_address,
    'to'         => $recipient,
    'subject'    => $subject,
    'html'       => $htmlBody,
    'h:Reply-To' => $mailgun_reply_to
];

if (!empty($organizerEmail)) {
    $postData['cc'] = $organizerEmail;
}

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL            => $apiUrl,
    CURLOPT_POST           => true,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_USERPWD        => 'api:' . $mailgun_api_key,
    CURLOPT_HTTPAUTH       => CURLAUTH_BASIC,
    CURLOPT_POSTFIELDS     => $postData,
    CURLOPT_TIMEOUT        => 15
]);

$response = curl_exec($ch);
$curlErrno = curl_errno($ch);
$curlError = curl_error($ch);
$httpStatus = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($curlErrno !== 0 || $httpStatus >= 400) {
    error_log(sprintf(
        'Mailgun cURL error (status: %s, errno: %s): %s Response: %s',
        $httpStatus ?: 'n/a',
        $curlErrno,
        $curlError ?: 'none',
        $response ?: 'no response'
    ));
    return false;
}

return true;
