<?php

declare(strict_types=1);

require_once __DIR__ . '/includes/helpers.php';
require_once __DIR__ . '/includes/auth.php';

pemohon_require_login();

$currentUser = pemohon_current_user();
if ($currentUser === null) {
    http_response_code(401);
    exit;
}

$userId = (int) ($currentUser['id'] ?? 0);
if ($userId <= 0) {
    http_response_code(401);
    exit;
}

$db = pemohon_db();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $profile = pemohon_fetch_profile($userId) ?? [];
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
        'biography' => $profile['biography'] ?? '',
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
        'message' => 'Kaedah tidak dibenarkan.',
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

header('Content-Type: application/json; charset=utf-8');

$token = $_POST['_token'] ?? null;
if (!pemohon_validate_csrf_token(is_string($token) ? $token : null)) {
    http_response_code(419);
    echo json_encode([
        'message' => 'Sesi tidak sah. Sila muat semula halaman.',
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

$biography = trim((string) ($_POST['biography'] ?? ''));
if (mb_strlen($biography) > 2000) {
    http_response_code(422);
    echo json_encode([
        'message' => 'Biografi melebihi 2000 aksara.',
        'errors' => [
            'biography' => 'Biografi melebihi 2000 aksara.',
        ],
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

$profile = pemohon_fetch_profile($userId) ?? [];
$hasApplicant = !empty($profile);

if ($hasApplicant) {
    $stmt = $db->prepare('UPDATE applicants SET biography = NULLIF(?, \'\') WHERE user_id = ?');
} else {
    $stmt = $db->prepare('INSERT INTO applicants (user_id, biography) VALUES (?, NULLIF(?, \'\'))');
}

if (!$stmt) {
    http_response_code(500);
    echo json_encode([
        'message' => 'Gagal menyediakan kemaskini biografi.',
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

if ($hasApplicant) {
    $stmt->bind_param('si', $biography, $userId);
} else {
    $stmt->bind_param('is', $userId, $biography);
}

if (!$stmt->execute()) {
    $stmt->close();
    http_response_code(500);
    echo json_encode([
        'message' => 'Gagal menyimpan biografi.',
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

$stmt->close();

echo json_encode([
    'message' => 'Biografi berjaya dikemaskini.',
    'biography' => $biography,
], JSON_UNESCAPED_UNICODE);
exit;
