<?php
declare(strict_types=1);
 
require_once __DIR__ . '/includes/helpers.php';
require_once __DIR__ . '/includes/auth.php';

pemohon_start_session();

if (pemohon_current_user()) {
    pemohon_redirect('/pemohon/dashboard.php');
}

$success = $_SESSION['pemohon_message'] ?? '';
unset($_SESSION['pemohon_message']);
$error = '';
$postedEmail = $_POST['email'] ?? '';
$forgotPasswordAction = '/urus/password/forgot';
$resetPasswordUrl = '/urus/reset_password.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $csrfToken = $_POST['_token'] ?? '';
    if (!pemohon_validate_csrf_token($csrfToken)) {
        $error = 'Sesi tidak sah. Sila cuba lagi.';
    } else {
        $email = $_POST['email'] ?? '';
        $password = $_POST['password'] ?? '';

        if (pemohon_login($email, $password)) {
            pemohon_redirect('/pemohon/dashboard.php');
        } else {
            $error = 'Maklumat log masuk tidak sah atau akaun belum aktif.';
        }
    }
}

$backgroundImage = pemohon_asset('assets/images/background/login-register.jpg');
$logo = pemohon_asset('assets/images/jabatan-mufti-negeri-melaka-logo-05x.png');
$recaptchaSiteKey = (string) pemohon_config('recaptcha.site_key', '');
?>
<!DOCTYPE html>
<html lang="ms">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="Portal Pemohon eTauliah Melaka">
    <meta name="author" content="">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo htmlspecialchars(pemohon_asset('assets/images/favicon.png'), ENT_QUOTES, 'UTF-8'); ?>">
    <title>Portal Pemohon eTauliah</title>
    <link href="<?php echo htmlspecialchars(pemohon_asset('dist/css/pages/login-register-lock.css'), ENT_QUOTES, 'UTF-8'); ?>" rel="stylesheet">
    <link href="<?php echo htmlspecialchars(pemohon_asset('dist/css/style.min.css'), ENT_QUOTES, 'UTF-8'); ?>" rel="stylesheet">
</head>

<body class="skin-default card-no-border">
    <section id="wrapper">
        <div class="login-register" style="background-image:url('<?php echo htmlspecialchars($backgroundImage, ENT_QUOTES, 'UTF-8'); ?>');">
            <div class="login-box card">
                <div class="card-body">
                    <form class="form-horizontal form-material" id="loginform" action="" method="POST">
                        <?php echo pemohon_csrf_field(); ?>
                        <div class="text-center m-b-20">
                            <img src="<?php echo htmlspecialchars($logo, ENT_QUOTES, 'UTF-8'); ?>" alt="Logo" style="max-width:140px;">
                        </div>
                        <h3 class="text-center m-b-20">Log Masuk Pemohon</h3>

                        <?php if ($success !== ''): ?>
                            <div class="alert alert-success"><?php echo htmlspecialchars($success, ENT_QUOTES, 'UTF-8'); ?></div>
                        <?php endif; ?>

                        <?php if ($error !== ''): ?>
                            <div class="alert alert-danger"><?php echo htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
                        <?php endif; ?>

                        <div class="form-group">
                            <div class="col-xs-12">
                                <input class="form-control" type="email" name="email" id="email" required placeholder="Alamat Emel" autocomplete="username" value="<?php echo htmlspecialchars($postedEmail, ENT_QUOTES, 'UTF-8'); ?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-xs-12">
                                <div class="input-group">
                                    <input class="form-control" type="password" name="password" id="password" required placeholder="Kata Laluan" autocomplete="current-password">
                                    <button type="button" class="btn btn-outline-secondary" id="togglePassword" aria-label="Tunjukkan kata laluan">
                                        <i class="far fa-eye" aria-hidden="true"></i>
                                        <span class="visually-hidden">Tunjukkan kata laluan</span>
                                    </button>
                                </div>
                                <small id="passwordStrength" class="form-text text-muted mt-2"></small>
                            </div>
                        </div>
                        <div class="form-group d-flex justify-content-between align-items-center">
                            <a href="#" class="text-info" data-bs-toggle="modal" data-bs-target="#forgotPasswordModal"><b>Lupa Kata Laluan?</b></a>
                            <button type="button" class="btn btn-link p-0" data-role="open-signup">Daftar sebagai Pemohon</button>
                        </div>
                        <div class="form-group text-center">
                            <div class="col-xs-12 p-b-20">
                                <button class="btn w-100 btn-lg btn-info btn-rounded text-white" type="submit">Log Masuk</button>
                            </div>
                        </div>
                    </form>
                    <div class="modal fade" id="forgotPasswordModal" tabindex="-1" aria-labelledby="forgotPasswordModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="forgotPasswordModalLabel">Tetapan Semula Kata Laluan</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
                                </div>
                                <div class="modal-body">
                                    <p class="mb-3">Masukkan alamat emel berdaftar anda. Jika akaun ditemui, kata laluan sementara akan dihantar kepada anda.</p>
                                    <p class="mb-3">Selepas menerima emel, gunakan <a href="<?php echo htmlspecialchars($resetPasswordUrl, ENT_QUOTES, 'UTF-8'); ?>" target="_blank" rel="noopener">halaman tetapan semula kata laluan</a> untuk menetapkan kata laluan baharu.</p>
                                    <form id="forgotPasswordForm" method="POST" action="<?php echo htmlspecialchars($forgotPasswordAction, ENT_QUOTES, 'UTF-8'); ?>">
                                        <?php echo pemohon_csrf_field(); ?>
                                        <div class="mb-3">
                                            <label for="forgotEmail" class="form-label">Alamat Emel</label>
                                            <input type="email" class="form-control" id="forgotEmail" name="email" required autocomplete="email">
                                        </div>
                                        <div class="d-flex justify-content-end">
                                            <button type="button" class="btn btn-secondary me-2" data-bs-dismiss="modal">Batal</button>
                                            <button type="submit" class="btn btn-primary" id="forgotPasswordSubmit">Hantar</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="modal fade" id="signupModal" tabindex="-1" aria-labelledby="signupModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="signupModalLabel">Daftar Sebagai Pemohon</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
                                </div>
                                <div class="modal-body">
                                    <p class="text-muted small">Isi maklumat berikut untuk menerima kata laluan sementara melalui emel.</p>
                                    <?php if ($recaptchaSiteKey === ''): ?>
                                        <div class="alert alert-warning">Google reCAPTCHA belum dikonfigurasikan. Pendaftaran mungkin tidak tersedia.</div>
                                    <?php endif; ?>
                                    <form id="signupForm" method="POST" action="/pemohon/register.php" autocomplete="off">
                                        <?php echo pemohon_csrf_field(); ?>
                                        <input type="hidden" name="recaptcha_token" value="">
                                        <div class="mb-3">
                                            <label for="signupName" class="form-label">Nama Penuh</label>
                                            <input type="text" class="form-control" id="signupName" name="name" maxlength="150" required>
                                        </div>
                                        <div class="mb-3">
                                            <label for="signupEmail" class="form-label">Alamat Emel</label>
                                            <input type="email" class="form-control" id="signupEmail" name="email" maxlength="150" required autocomplete="off">
                                        </div>
                                        <div class="mb-3">
                                            <label for="signupEmailConfirm" class="form-label">Sahkan Alamat Emel</label>
                                            <input type="email" class="form-control" id="signupEmailConfirm" name="email_confirmation" maxlength="150" required autocomplete="off">
                                        </div>
                                        <div class="mb-3">
                                            <label for="signupPhone" class="form-label">No. Telefon Bimbit</label>
                                            <input type="text" class="form-control" id="signupPhone" name="phone" maxlength="30" placeholder="+6012 345 6789" required>
                                        </div>
                                        <div class="alert alert-danger d-none" role="alert" data-role="signup-feedback"></div>
                                        <div class="d-flex justify-content-end gap-2">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                            <button type="submit" class="btn btn-primary" id="signupSubmit">
                                                <span class="signup-submit-text">Daftar</span>
                                                <span class="spinner-border spinner-border-sm align-middle d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script src="<?php echo htmlspecialchars(pemohon_asset('assets/node_modules/jquery/dist/jquery.min.js'), ENT_QUOTES, 'UTF-8'); ?>"></script>
    <script src="<?php echo htmlspecialchars(pemohon_asset('assets/bootstrap-5.2.3/js/bootstrap.bundle.min.js'), ENT_QUOTES, 'UTF-8'); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/zxcvbn/4.4.2/zxcvbn.js"></script>
    <?php if ($recaptchaSiteKey !== ''): ?>
    <script src="https://www.google.com/recaptcha/api.js?render=<?php echo htmlspecialchars($recaptchaSiteKey, ENT_QUOTES, 'UTF-8'); ?>"></script>
    <script>
        window.executeSignupRecaptcha = function (targetForm) {
            return new Promise(function (resolve) {
                if (!window.grecaptcha) {
                    resolve();
                    return;
                }
                window.grecaptcha.ready(function () {
                    window.grecaptcha.execute('<?php echo htmlspecialchars($recaptchaSiteKey, ENT_QUOTES, 'UTF-8'); ?>', {action: 'signup'}).then(function (token) {
                        var form = targetForm || document.getElementById('signupForm');
                        if (!form) {
                            resolve();
                            return;
                        }
                        var input = form.querySelector('input[name="recaptcha_token"]');
                        if (!input) {
                            input = document.createElement('input');
                            input.type = 'hidden';
                            input.name = 'recaptcha_token';
                            form.appendChild(input);
                        }
                        input.value = token;
                        resolve();
                    }).catch(function () {
                        resolve();
                    });
                });
            });
        };
    </script>
    <?php endif; ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var passwordInput = document.getElementById('password');
            var togglePassword = document.getElementById('togglePassword');
            var strengthText = document.getElementById('passwordStrength');

            if (togglePassword && passwordInput) {
                togglePassword.addEventListener('click', function () {
                    var isPassword = passwordInput.type === 'password';
                    passwordInput.type = isPassword ? 'text' : 'password';
                    var icon = togglePassword.querySelector('i');
                    if (icon) {
                        icon.classList.toggle('fa-eye', !isPassword);
                        icon.classList.toggle('fa-eye-slash', isPassword);
                    }
                    var ariaText = isPassword ? 'Sembunyikan kata laluan' : 'Tunjukkan kata laluan';
                    togglePassword.setAttribute('aria-label', ariaText);
                    var srLabel = togglePassword.querySelector('.visually-hidden');
                    if (srLabel) {
                        srLabel.textContent = ariaText;
                    }
                });
            }

            var updateStrength = function () {
                if (!strengthText || !passwordInput) {
                    return;
                }

                var value = passwordInput.value || '';
                if (value.length === 0) {
                    strengthText.textContent = '';
                    strengthText.className = 'form-text text-muted mt-2';
                    return;
                }

                if (typeof zxcvbn !== 'function') {
                    strengthText.textContent = '';
                    strengthText.className = 'form-text text-muted mt-2';
                    return;
                }

                var result = zxcvbn(value);
                var labels = ['Sangat Lemah', 'Lemah', 'Sederhana', 'Baik', 'Sangat Baik'];
                var classes = ['text-danger', 'text-danger', 'text-warning', 'text-info', 'text-success'];
                var score = Math.max(0, Math.min(result.score, labels.length - 1));

                strengthText.textContent = 'Kekuatan Kata Laluan: ' + labels[score];
                strengthText.className = 'form-text mt-2 ' + classes[score];
            };

            if (passwordInput) {
                passwordInput.addEventListener('input', updateStrength);
                updateStrength();
            }

            var forgotPasswordModalElement = document.getElementById('forgotPasswordModal');
            var forgotPasswordModal = null;

            if (forgotPasswordModalElement && forgotPasswordModalElement.parentNode !== document.body) {
                document.body.appendChild(forgotPasswordModalElement);
            }

            if (forgotPasswordModalElement && window.bootstrap && window.bootstrap.Modal) {
                forgotPasswordModal = window.bootstrap.Modal.getOrCreateInstance(forgotPasswordModalElement);
            }

            var forgotPasswordForm = document.getElementById('forgotPasswordForm');
            var forgotPasswordSubmit = document.getElementById('forgotPasswordSubmit');

            if (forgotPasswordForm) {
                forgotPasswordForm.addEventListener('submit', function (event) {
                    event.preventDefault();

                    if (forgotPasswordSubmit) {
                        forgotPasswordSubmit.disabled = true;
                        forgotPasswordSubmit.dataset.originalText = forgotPasswordSubmit.textContent;
                        forgotPasswordSubmit.textContent = 'Menghantar...';
                    }

                    var formData = new FormData(forgotPasswordForm);
                    var payload = new URLSearchParams();
                    formData.forEach(function (value, key) {
                        payload.append(key, value.toString());
                    });

                    fetch(forgotPasswordForm.action, {
                        method: 'POST',
                        credentials: 'same-origin',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8',
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        body: payload.toString()
                    }).then(function (response) {
                        return response.json().catch(function () {
                            return {};
                        }).then(function (data) {
                            return {
                                ok: response.ok,
                                status: response.status,
                                body: data
                            };
                        });
                    }).then(function (result) {
                        if (forgotPasswordSubmit) {
                            forgotPasswordSubmit.disabled = false;
                            forgotPasswordSubmit.textContent = forgotPasswordSubmit.dataset.originalText || 'Hantar';
                        }

                        var message = result.body && result.body.message ? result.body.message : 'Permintaan tamat tanpa mesej.';

                        if (result.ok) {
                            forgotPasswordForm.reset();
                            if (forgotPasswordModal) {
                                forgotPasswordModal.hide();
                            }
                            if (window.Swal) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Emel Dihantar',
                                    text: message
                                });
                            } else {
                                alert(message);
                            }
                        } else {
                            if (window.Swal) {
                                Swal.fire({
                                    icon: result.status === 422 ? 'warning' : 'error',
                                    title: 'Tidak Berjaya',
                                    text: message
                                });
                            } else {
                                alert(message);
                            }
                        }
                    }).catch(function () {
                        if (forgotPasswordSubmit) {
                            forgotPasswordSubmit.disabled = false;
                            forgotPasswordSubmit.textContent = forgotPasswordSubmit.dataset.originalText || 'Hantar';
                        }
                        if (window.Swal) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Tidak Berjaya',
                                text: 'Permintaan tidak dapat diproses sekarang. Sila cuba lagi.'
                            });
                        } else {
                            alert('Permintaan tidak dapat diproses sekarang. Sila cuba lagi.');
                        }
                    });
                });
            }

            var signupModalElement = document.getElementById('signupModal');
            var signupModal = null;
            if (signupModalElement && signupModalElement.parentNode !== document.body) {
                document.body.appendChild(signupModalElement);
            }
            if (signupModalElement && window.bootstrap && window.bootstrap.Modal) {
                signupModal = window.bootstrap.Modal.getOrCreateInstance(signupModalElement);
            }

            var signupTrigger = document.querySelector('[data-role="open-signup"]');
            if (signupTrigger && signupModal) {
                signupTrigger.addEventListener('click', function (event) {
                    event.preventDefault();
                    signupModal.show();
                });
            }

            var signupForm = document.getElementById('signupForm');
            var signupSubmit = document.getElementById('signupSubmit');
            var signupFeedback = signupForm ? signupForm.querySelector('[data-role="signup-feedback"]') : null;

            function setSignupFeedback(message, type) {
                if (!signupFeedback) {
                    return;
                }
                signupFeedback.classList.add('d-none');
                signupFeedback.classList.remove('alert-success', 'alert-danger', 'alert-warning');
                if (!message) {
                    signupFeedback.textContent = '';
                    return;
                }
                signupFeedback.textContent = message;
                signupFeedback.classList.add('alert', 'alert-' + (type || 'danger'));
                signupFeedback.classList.remove('d-none');
            }

            function toggleSignupLoading(isLoading) {
                if (!signupSubmit) {
                    return;
                }
                signupSubmit.disabled = isLoading;
                var spinner = signupSubmit.querySelector('.spinner-border');
                var text = signupSubmit.querySelector('.signup-submit-text');
                if (spinner) {
                    spinner.classList.toggle('d-none', !isLoading);
                }
                if (text) {
                    text.textContent = isLoading ? 'Menyimpan...' : 'Daftar';
                }
            }

            if (signupForm) {
                signupForm.addEventListener('submit', function (event) {
                    event.preventDefault();
                    if (signupSubmit && signupSubmit.disabled) {
                        return;
                    }
                    toggleSignupLoading(true);
                    setSignupFeedback('', '');

                    var recaptchaPromise = typeof window.executeSignupRecaptcha === 'function'
                        ? window.executeSignupRecaptcha(signupForm)
                        : Promise.resolve();

                    recaptchaPromise.catch(function () {
                        return Promise.resolve();
                    }).then(function () {
                        var formData = new FormData(signupForm);
                        return fetch(signupForm.action, {
                            method: 'POST',
                            credentials: 'same-origin',
                            body: formData,
                            headers: {
                                'X-Requested-With': 'XMLHttpRequest'
                            }
                        }).then(function (response) {
                            return response.json().catch(function () {
                                return {};
                            }).then(function (data) {
                                return {
                                    ok: response.ok,
                                    status: response.status,
                                    body: data
                                };
                            });
                        });
                    }).then(function (result) {
                        toggleSignupLoading(false);
                        var message = result && result.body && result.body.message
                            ? result.body.message
                            : 'Permintaan tidak dapat diproses.';

                        if (result && result.ok) {
                            signupForm.reset();
                            setSignupFeedback('', '');
                            if (signupModal) {
                                signupModal.hide();
                            }
                            if (window.Swal) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Pendaftaran Berjaya',
                                    text: message
                                });
                            } else {
                                alert(message);
                            }
                        } else {
                            if (signupFeedback) {
                                setSignupFeedback(message, result && result.status === 422 ? 'warning' : 'danger');
                            } else if (window.Swal) {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Tidak Berjaya',
                                    text: message
                                });
                            } else {
                                alert(message);
                            }
                        }
                    }).catch(function () {
                        toggleSignupLoading(false);
                        var fallbackMessage = 'Pendaftaran tidak dapat diproses sekarang. Sila cuba lagi.';
                        if (signupFeedback) {
                            setSignupFeedback(fallbackMessage, 'danger');
                        } else if (window.Swal) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Tidak Berjaya',
                                text: fallbackMessage
                            });
                        } else {
                            alert(fallbackMessage);
                        }
                    });
                });
            }
        });
    </script>
</body>

</html>
