<?php

declare(strict_types=1);

require_once __DIR__ . '/includes/helpers.php';
require_once __DIR__ . '/includes/auth.php';

pemohon_require_login();

$currentUser = pemohon_current_user();
if ($currentUser === null) {
    pemohon_redirect('/pemohon');
}

$db = pemohon_db();

$sql = <<<'SQL'
    SELECT
        a.id,
        a.title,
        a.body,
        a.published_from,
        a.published_until,
        a.created_at,
        COALESCE(a.published_from, a.created_at) AS sort_order
    FROM announcements a
    LEFT JOIN announcement_targets t ON t.announcement_id = a.id
    WHERE a.is_active = 1
      AND (
            a.audience IN ('all', 'applicant')
            OR (a.audience = 'custom' AND t.target_role = 'applicant')
          )
      AND (a.published_from IS NULL OR a.published_from <= NOW())
      AND (a.published_until IS NULL OR a.published_until >= NOW())
    GROUP BY a.id
    ORDER BY sort_order DESC
SQL;

$announcements = [];
$result = $db->query($sql);
if ($result instanceof mysqli_result) {
    while ($row = $result->fetch_assoc()) {
        $announcements[] = [
            'title' => (string) ($row['title'] ?? ''),
            'body' => (string) ($row['body'] ?? ''),
            'published_from' => $row['published_from'] ? date('d/m/Y H:i', strtotime((string) $row['published_from'])) : null,
            'published_until' => $row['published_until'] ? date('d/m/Y H:i', strtotime((string) $row['published_until'])) : null,
            'created_at' => $row['created_at'] ? date('d/m/Y H:i', strtotime((string) $row['created_at'])) : null,
        ];
    }
    $result->free();
}

$pageTitle = 'Notifikasi - eTauliah';
include __DIR__ . '/header.php';
include __DIR__ . '/sidebar.php';
?>
<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row page-titles">
            <div class="col-md-6 col-12 align-self-center">
                <h3 class="text-themecolor mb-0">Notifikasi</h3>
                <small class="text-muted">Pengumuman terkini berkaitan permohonan anda.</small>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <?php if (!$announcements): ?>
                    <div class="card">
                        <div class="card-body text-center text-muted">
                            <i class="mdi mdi-bell-off-outline display-5 d-block mb-2"></i>
                            Tiada notifikasi buat masa ini.
                        </div>
                    </div>
                <?php else: ?>
                    <?php foreach ($announcements as $announcement): ?>
                        <?php
                        $allowedTags = '<p><br><strong><em><u><b><i><ul><ol><li><a>';
                        $bodyHtml = isset($announcement['body']) ? strip_tags((string) $announcement['body'], $allowedTags) : '';
                        ?>
                        <div class="card mb-3">
                            <div class="card-body">
                                <h4 class="card-title mb-2">
                                    <i class="mdi mdi-bell text-info me-2"></i>
                                    <?php echo htmlspecialchars($announcement['title'], ENT_QUOTES, 'UTF-8'); ?>
                                </h4>
                                <div class="card-text mb-3">
                                    <?php echo $bodyHtml; ?>
                                </div>
                                <div class="d-flex flex-wrap text-muted small">
                                    <?php if (!empty($announcement['published_from'])): ?>
                                        <span class="me-3">
                                            <i class="mdi mdi-calendar-start"></i>
                                            Mula: <?php echo htmlspecialchars($announcement['published_from'], ENT_QUOTES, 'UTF-8'); ?>
                                        </span>
                                    <?php endif; ?>
                                    <?php if (!empty($announcement['published_until'])): ?>
                                        <span class="me-3">
                                            <i class="mdi mdi-calendar-end"></i>
                                            Tamat: <?php echo htmlspecialchars($announcement['published_until'], ENT_QUOTES, 'UTF-8'); ?>
                                        </span>
                                    <?php endif; ?>
                                    <?php if (!empty($announcement['created_at'])): ?>
                                        <span>
                                            <i class="mdi mdi-clock-outline"></i>
                                            Dikemaskini: <?php echo htmlspecialchars($announcement['created_at'], ENT_QUOTES, 'UTF-8'); ?>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php include __DIR__ . '/footer.php'; ?>
