<?php
//declare(strict_types=1);

require_once __DIR__ . '/includes/helpers.php';
require_once __DIR__ . '/includes/auth.php';

pemohon_require_login();

$currentUser = pemohon_current_user();
if ($currentUser === null) {
    pemohon_redirect('/pemohon');
}

$profile = pemohon_fetch_profile((int) $currentUser['id']);

$photoPath = $profile['photo_path'] ?? '';
$avatarUrl = pemohon_asset('assets/images/users/1.jpg');
if ($photoPath !== '') {
    $absolutePhoto = dirname(__DIR__) . '/' . ltrim($photoPath, '/');
    if (is_file($absolutePhoto)) {
        $avatarUrl = pemohon_asset(ltrim($photoPath, '/'));
    }
}

$pageTitle = 'Profil Pemohon - eTauliah';
$coverImage = pemohon_asset('assets/images/background/profile-bg.jpg');

$addressLines = array_filter([
    trim((string) ($profile['address_line1'] ?? '')),
    trim((string) ($profile['address_line2'] ?? '')),
    trim(trim((string) ($profile['postcode'] ?? '')) . ' ' . trim((string) ($profile['city'] ?? ''))),
    trim((string) ($profile['state'] ?? '')),
    trim((string) ($profile['country'] ?? '')),
]);
$addressText = $addressLines ? implode("\n", $addressLines) : '-';
$profilePhone = $profile['phone'] ?? $profile['user_phone'] ?? ($currentUser['phone'] ?? '-');

$flashMessage = $_SESSION['pemohon_message'] ?? '';
unset($_SESSION['pemohon_message']);

include __DIR__ . '/header.php';
include __DIR__ . '/sidebar.php';
?>
        <style>
            .profile-photo-trigger {
                position: relative;
                display: inline-block;
                cursor: pointer;
            }

            .profile-photo-trigger img {
                width: 180px;
                height: 180px;
                border-radius: 50%;
                object-fit: cover;
                transition: transform 0.2s ease;
            }

            .profile-photo-trigger:hover img,
            .profile-photo-trigger:focus img {
                transform: scale(1.02);
            }

            .profile-photo-trigger .profile-photo-overlay {
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                border-radius: 50%;
                display: flex;
                flex-direction: column;
                align-items: center;
                justify-content: center;
                background: rgba(0, 0, 0, 0.55);
                color: #fff;
                font-size: 0.875rem;
                text-align: center;
                opacity: 0;
                transition: opacity 0.2s ease;
            }

            .profile-photo-trigger:hover .profile-photo-overlay,
            .profile-photo-trigger:focus .profile-photo-overlay {
                opacity: 1;
            }

            .profile-photo-trigger .profile-photo-overlay .ti-camera {
                font-size: 1.5rem;
                margin-bottom: 0.25rem;
            }

            .profile-photo-preview {
                width: 180px;
                height: 180px;
                margin: 0 auto 0.75rem;
                border-radius: 50%;
                overflow: hidden;
                background: #f3f3f3;
                display: flex;
                align-items: center;
                justify-content: center;
                position: relative;
            }

            .profile-photo-preview img {
                width: 100%;
                height: 100%;
                object-fit: cover;
            }

            .profile-photo-preview .preview-placeholder {
                color: #999;
                font-size: 0.875rem;
            }

            .profile-photo-form .filepond--wrapper,
            .profile-photo-form .filepond--root {
                width: 100%;
                margin-bottom: 1rem;
            }

            .profile-photo-form .filepond--panel-root {
                border-radius: 16px;
                border: 2px dashed #e9ecef;
                background-color: #fafafa;
            }

            .profile-photo-form .filepond--drop-label {
                color: #6c757d;
                font-size: 0.95rem;
                font-weight: 500;
            }

            .profile-photo-form .filepond--item-panel {
                border-radius: 12px;
            }

            .profile-photo-form .filepond--credits {
                display: none !important;
            }
        </style>
        <div class="page-wrapper">
            <div class="container-fluid">
                <?php if ($flashMessage !== ''): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo htmlspecialchars($flashMessage, ENT_QUOTES, 'UTF-8'); ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Tutup"></button>
                    </div>
                <?php endif; ?>
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <!-- <img class="card-img-top" src="<?php echo htmlspecialchars($coverImage, ENT_QUOTES, 'UTF-8'); ?>" alt="Cover"> -->
                            <div class="card-body little-profile text-center">
                                <div class="pro-img profile-photo-trigger" role="button" tabindex="0" data-role="profile-photo-trigger">
                                    <img src="<?php echo htmlspecialchars($avatarUrl, ENT_QUOTES, 'UTF-8'); ?>" alt="user" id="profile-photo-display" data-role="pemohon-avatar">
                                    <span class="profile-photo-overlay">
                                        <i class="ti-camera"></i>
                                        <span class="text">Kemaskini Foto</span>
                                    </span>
                                </div>
                                <h3 class="m-b-0"><?php echo htmlspecialchars($currentUser['name'] ?? 'Pemohon', ENT_QUOTES, 'UTF-8'); ?></h3>
                                <p><?php echo htmlspecialchars($profile['occupation'] ?? 'Pemohon eTauliah', ENT_QUOTES, 'UTF-8'); ?></p>
                                <?php if (!empty($currentUser['email'])): ?>
                                    <a href="mailto:<?php echo htmlspecialchars($currentUser['email'], ENT_QUOTES, 'UTF-8'); ?>" class="m-t-10 waves-effect waves-dark btn btn-primary btn-md btn-rounded">
                                        <i class="far fa-envelope"></i> <?php echo htmlspecialchars($currentUser['email'], ENT_QUOTES, 'UTF-8'); ?>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-4 col-md-5">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex flex-wrap align-items-center justify-content-between mb-3">
                                    <h4 class="card-title mb-0">Maklumat Asas</h4>
                                    <button type="button" class="btn btn-sm btn-outline-primary" data-role="basic-info-edit">
                                        <i class="ti-pencil"></i> Kemaskini
                                    </button>
                                </div>
                                <small class="text-muted">No. Kad Pengenalan</small>
                                <h6><?php echo htmlspecialchars($profile['nric'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></h6>
                                <small class="text-muted">Tarikh Lahir</small>
                                <h6><?php echo htmlspecialchars($profile['date_of_birth'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></h6>
                                <small class="text-muted">Telefon</small>
                                <h6><?php echo htmlspecialchars($profilePhone, ENT_QUOTES, 'UTF-8'); ?></h6>
                                <small class="text-muted">Alamat</small>
                                <h6><?php echo nl2br(htmlspecialchars($addressText, ENT_QUOTES, 'UTF-8')); ?></h6>
                            </div>
                        </div>
                        <div class="card" id="applicant-education-card">
                            <div class="card-body">
                                <div class="d-flex flex-wrap align-items-center justify-content-between mb-3">
                                    <h4 class="card-title mb-0">Kelayakan Akademik</h4>
                                    <button type="button" class="btn btn-sm btn-outline-primary" data-role="education-manage">
                                        <i class="ti-pencil"></i> Kemaskini
                                    </button>
                                </div>
                                <p class="m-b-1 badge bg-success">Kelayakan Tertinggi</p>
                                <h6 data-role="education-highest-qualification">-</h6>
                                
                                
                                <h6 data-role="education-highest-institution">-</h6>
                                <small class="text-muted d-block mb-2" data-role="education-highest-years">-</small>
                                <hr>
                                <div class="mb-2">
                                    <div class="text-muted small mb-2">Senarai Institusi Pendidikan</div>
                                    <div class="text-center py-3 d-none" data-role="education-summary-loading">
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Memuatkan...</span>
                                        </div>
                                    </div>
                                    <div class="alert alert-info mb-0" data-role="education-summary-empty">Tiada rekod pendidikan tambahan buat masa ini.</div>
                                    <ul class="list-group list-group-flush d-none" data-role="education-summary-list"></ul>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-8 col-md-7">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title">Ringkasan Permohonan</h4>
                                <div class="table-responsive">
                                    <table class="table table-striped datatable">
                                        <thead>
                                            <tr>
                                                <th>No. Permohonan</th>
                                                <th>Jenis Permohonan</th>
                                                <th>Status</th>
                                                <th>Tarikh Kemaskini</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php echo render_applications((int) $currentUser['id']); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="card" id="applicant-documents-card">
                            <div class="card-body">
                                <div class="d-flex flex-wrap align-items-center justify-content-between">
                                    <h4 class="card-title mb-0">Senarai Dokumen</h4>
                                    <button type="button" class="btn btn-sm btn-primary" data-role="document-add">
                                        <i class="ti-plus"></i> Tambah Dokumen
                                    </button>
                                </div>
                                <p class="text-muted small mb-3 mt-2">Simpan dokumen berkaitan permohonan anda untuk rujukan pantas.</p>
                                <div class="alert d-none" role="alert" data-role="document-alert"></div>
                                <div class="text-center py-4 d-none" data-role="document-loading">
                                    <div class="spinner-border text-primary" role="status">
                                        <span class="visually-hidden">Memuatkan...</span>
                                    </div>
                                </div>
                                <div class="alert alert-info mb-0" data-role="document-empty">Tiada dokumen dimuat naik buat masa ini.</div>
                                <ul class="list-group list-group-flush d-none" data-role="document-list"></ul>
                            </div>
                        </div>
                        <div class="card" id="biography-card">
                            <div class="card-body">
                                <div class="d-flex flex-wrap align-items-center justify-content-between mb-3">
                                    <h4 class="card-title mb-0">Biografi</h4>
                                    <button type="button" class="btn btn-sm btn-outline-primary" data-role="biography-edit">
                                        <i class="ti-pencil"></i> Kemaskini
                                    </button>
                                </div>
                                <div data-role="biography-content">
                                    <?php
                                    $biographyText = trim((string) ($profile['biography'] ?? ''));
                                    if ($biographyText === '') {
                                        echo '<p class="text-muted mb-0">Tiada maklumat biografi disediakan.</p>';
                                    } else {
                                        echo '<p>' . nl2br(htmlspecialchars($biographyText, ENT_QUOTES, 'UTF-8')) . '</p>';
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<template id="document-upload-template">
    <form id="document-upload-form" autocomplete="off">
        <?php echo pemohon_csrf_field(); ?>
        <div class="mb-3">
            <label for="document-title-input" class="form-label">Tajuk Dokumen</label>
            <input type="text" class="form-control" id="document-title-input" name="title" maxlength="200" placeholder="Contoh: Salinan IC" required>
        </div>
        <div class="mb-3">
            <label for="document-description-input" class="form-label">Penerangan (pilihan)</label>
            <textarea class="form-control" id="document-description-input" name="description" rows="3" maxlength="1000" placeholder="Keterangan ringkas dokumen"></textarea>
        </div>
        <div class="mb-3">
            <label for="document-file-input" class="form-label">Fail Dokumen (PDF, maksimum 15MB)</label>
            <input type="file" class="filepond" id="document-file-input" name="document" accept="application/pdf" required>
        </div>
        <div class="alert alert-danger d-none" role="alert" data-role="document-upload-error"></div>
    </form>
</template>

<template id="biography-modal-template">
    <form id="biography-form" autocomplete="off">
        <?php echo pemohon_csrf_field(); ?>
        <div class="mb-3">
            <label for="biography-input" class="form-label">Biografi</label>
            <textarea class="form-control" id="biography-input" name="biography" rows="6" maxlength="2000" placeholder="Tulis tentang latar belakang dan pengalaman anda."><?php echo htmlspecialchars($profile['biography'] ?? '', ENT_QUOTES, 'UTF-8'); ?></textarea>
            <small class="text-muted">Maksimum 2000 aksara.</small>
        </div>
        <div class="alert d-none" role="alert" data-role="biography-feedback"></div>
    </form>
</template>

<template id="education-modal-template">
    <div class="education-modal-content">
        <div class="alert d-none" role="alert" data-role="education-modal-alert"></div>
        <div class="mb-3">
            <div class="text-center py-4 d-none" data-role="education-modal-loading">
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden">Memuatkan...</span>
                </div>
            </div>
            <div class="alert alert-info" data-role="education-modal-empty">Tiada rekod pendidikan direkodkan.</div>
            <ul class="list-group d-none" data-role="education-modal-list"></ul>
        </div>
        <hr>
        <form data-role="education-modal-form" autocomplete="off">
            <?php echo pemohon_csrf_field(); ?>
            <input type="hidden" name="_action" value="create" data-role="education-action">
            <input type="hidden" name="id" value="" data-role="education-id">
            <div class="row g-3">
                <div class="col-12">
                    <label for="education-institution-input" class="form-label">Nama Institusi</label>
                    <input type="text" class="form-control" id="education-institution-input" name="institution" maxlength="200" required>
                </div>
                <div class="col-12">
                    <label for="education-qualification-input" class="form-label">Kelayakan</label>
                    <input type="text" class="form-control" id="education-qualification-input" name="qualification" maxlength="150" required>
                </div>
                <div class="col-12">
                    <label for="education-field-input" class="form-label">Bidang (pilihan)</label>
                    <input type="text" class="form-control" id="education-field-input" name="field_of_study" maxlength="150">
                </div>
                <div class="col-sm-6">
                    <label for="education-start-year-input" class="form-label">Tahun Mula</label>
                    <input type="text" class="form-control" id="education-start-year-input" name="start_year" pattern="\d{4}" placeholder="Contoh: 2018">
                </div>
                <div class="col-sm-6">
                    <label for="education-end-year-input" class="form-label">Tahun Tamat</label>
                    <input type="text" class="form-control" id="education-end-year-input" name="end_year" pattern="\d{4}" placeholder="Contoh: 2022">
                </div>
                <div class="col-12">
                    <label for="education-description-input" class="form-label">Penerangan (pilihan)</label>
                    <textarea class="form-control" id="education-description-input" name="description" rows="3" maxlength="500" placeholder="Pencapaian atau nota tambahan"></textarea>
                </div>
                <div class="col-12">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="1" id="education-highest-input" name="is_highest">
                        <label class="form-check-label" for="education-highest-input">
                            Kelayakan Tertinggi
                        </label>
                    </div>
                </div>
            </div>
            <div class="alert alert-danger d-none mt-3" role="alert" data-role="education-modal-error"></div>
            <div class="d-flex justify-content-end mt-3">
                <button type="button" class="btn btn-light border me-2 d-none" data-role="education-cancel-edit">Batal</button>
                <button type="submit" class="btn btn-primary" data-role="education-submit">
                    <span class="submit-text">Tambah</span>
                    <span class="spinner-border spinner-border-sm align-middle d-none" role="status" aria-hidden="true"></span>
                </button>
            </div>
        </form>
    </div>
</template>

<div class="modal fade" id="profilePhotoModal" tabindex="-1" aria-labelledby="profilePhotoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="profilePhotoModalLabel">Kemaskini Foto Profil</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
            </div>
            <div class="modal-body">
                <form id="profile-photo-form" class="profile-photo-form" autocomplete="off">
                    <?php echo pemohon_csrf_field(); ?>
                    <div class="profile-photo-preview border mb-3">
                        <img src="<?php echo htmlspecialchars($avatarUrl, ENT_QUOTES, 'UTF-8'); ?>" alt="Pratonton foto" id="profile-photo-preview-image">
                    </div>
                    <p class="text-muted text-center small">
                        Muat naik foto dengan wajah anda yang jelas dan terang. Sistem akan mengesahkan kehadiran wajah sebelum memuat naik.
                    </p>
                    <label for="profile-photo-input" class="form-label mt-3">Pilih Foto (JPEG / PNG, maksimum 5MB)</label>
                    <input class="filepond" type="file" id="profile-photo-input" name="photo" accept="image/jpeg,image/png" required>
                    <div id="profile-photo-alert" class="alert d-none" role="alert"></div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light border" data-bs-dismiss="modal">Tutup</button>
                <button type="button" class="btn btn-primary" id="profile-photo-upload" disabled>
                    <span class="upload-text">Muat Naik</span>
                    <span class="upload-spinner spinner-border spinner-border-sm align-middle d-none" role="status" aria-hidden="true"></span>
                </button>
            </div>
        </div>
    </div>
</div>

<?php
$footerText = '&copy; ' . date('Y') . ' Jabatan Mufti Negeri Melaka - Portal Pemohon eTauliah';
include __DIR__ . '/footer.php';

function render_applications(int $userId): string
{
    $typeLabels = [
        'new' => 'Permohonan Baharu',
        'renewal' => 'Pembaharuan Tempoh',
        'upgrade' => 'Naik Taraf Kategori',
        'replacement' => 'Penggantian Hilang/Rosak',
    ];

    $tauliahLabels = [
        'agama' => 'Tauliah Agama',
        'alquran' => 'Tauliah Al-Quran',
        'both' => 'Tauliah Agama & Al-Quran',
    ];

    $statusLabels = [
        'draft' => 'Draf',
        'submitted' => 'Dihantar',
        'under_review' => 'Dalam Semakan',
        'interview' => 'Temuduga',
        'approved' => 'Diluluskan',
        'rejected' => 'Ditolak',
        'kiv' => 'KIV',
        'cancelled' => 'Dibatalkan',
        'expired' => 'Tamat Tempoh',
    ];

    $db = pemohon_db();
    $sql = 'SELECT application_number, application_type, tauliah_type, status, submitted_at, updated_at
            FROM applications a
            WHERE a.applicant_id = (SELECT id FROM applicants WHERE user_id = ? LIMIT 1)
            ORDER BY a.updated_at DESC
            LIMIT 10';

    $stmt = $db->prepare($sql);
    if (!$stmt) {
        throw new \RuntimeException('Failed to prepare statement: ' . $db->error);
    }

    $stmt->bind_param('i', $userId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        $stmt->close();
        return '<tr><td colspan="4" class="text-center">Tiada permohonan direkodkan.</td></tr>';
    }

    $rows = '';
    while ($row = $result->fetch_assoc()) {
        $applicationType = $row['application_type'] ?? '';
        $tauliahType = $row['tauliah_type'] ?? '';
        $status = $row['status'] ?? '';

        $typeText = $typeLabels[$applicationType] ?? ucfirst(str_replace('_', ' ', (string) $applicationType));
        $tauliahText = $tauliahLabels[$tauliahType] ?? ucfirst(str_replace('_', ' ', (string) $tauliahType));
        $statusText = $statusLabels[$status] ?? strtoupper((string) $status);

        $timestamp = $row['submitted_at'] ?? null;
        if (!$timestamp) {
            $timestamp = $row['updated_at'] ?? null;
        }

        $displayDate = '-';
        if ($timestamp) {
            $timeValue = strtotime((string) $timestamp);
            if ($timeValue !== false) {
                $displayDate = date('d/m/Y H:i', $timeValue);
            }
        }

        $rows .= '<tr>'
            . '<td>' . htmlspecialchars($row['application_number'] ?? '-', ENT_QUOTES, 'UTF-8') . '</td>'
            . '<td>'
                . htmlspecialchars($typeText, ENT_QUOTES, 'UTF-8')
                . '<br><small class="text-muted">' . htmlspecialchars($tauliahText, ENT_QUOTES, 'UTF-8') . '</small>'
            . '</td>'
            . '<td>' . htmlspecialchars($statusText, ENT_QUOTES, 'UTF-8') . '</td>'
            . '<td>' . htmlspecialchars($displayDate, ENT_QUOTES, 'UTF-8') . '</td>'
            . '</tr>';
    }

    $stmt->close();

    return $rows;
}
