<?php

if (!function_exists('pemohon_asset')) {
    require_once __DIR__ . '/includes/helpers.php';
}

$pemohonSidebarUser = $currentUser ?? ($_SESSION['pemohon_user'] ?? null);
$sidebarName = $pemohonSidebarUser['name'] ?? 'Pemohon';
$sidebarEmail = $pemohonSidebarUser['email'] ?? '';
$defaultSidebarAvatar = pemohon_asset('assets/images/users/1.jpg');
if (!isset($avatarUrl) || !is_string($avatarUrl) || $avatarUrl === '') {
    $sidebarAvatar = pemohon_resolve_avatar_url($pemohonSidebarUser, $defaultSidebarAvatar);
} else {
    $sidebarAvatar = $avatarUrl;
}
$currentSidebarPath = $_SERVER['SCRIPT_NAME'] ?? '';
?>
<aside class="left-sidebar">
    <div class="scroll-sidebar">
        <div class="user-profile">
            <div class="user-pro-body">
                <div><img src="<?php echo htmlspecialchars($sidebarAvatar, ENT_QUOTES, 'UTF-8'); ?>" alt="user" class="img-circle" data-role="pemohon-avatar"></div>
                <div class="dropdown">
                    <a href="javascript:void(0)" class="dropdown-toggle u-dropdown link hide-menu" data-bs-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
                        <?php echo htmlspecialchars($sidebarName, ENT_QUOTES, 'UTF-8'); ?> <span class="caret"></span>
                    </a>
                    <div class="dropdown-menu animated flipInY">
                        <a href="/pemohon/profile.php" class="dropdown-item"><i class="ti-user"></i> Profil Saya</a>
                        <a href="javascript:update_profile()" class="dropdown-item"><i class="ti-user"></i> Kemaskini Profil</a>
                        <?php if ($sidebarEmail !== ''): ?>
                            <span class="dropdown-item-text text-muted small"><?php echo htmlspecialchars($sidebarEmail, ENT_QUOTES, 'UTF-8'); ?></span>
                            <div class="dropdown-divider"></div>
                        <?php endif; ?>
                        <a href="/pemohon/logout.php" class="dropdown-item"><i class="fas fa-power-off"></i> Log Keluar</a>
                    </div>
                </div>
            </div>
        </div>
        <nav class="sidebar-nav">
            <ul id="sidebarnav">
                <li>
                    <a class="waves-effect waves-dark<?php echo $currentSidebarPath === '/pemohon/dashboard.php' ? ' active' : ''; ?>" href="/pemohon/dashboard.php" aria-expanded="false">
                        <i class="ti-dashboard"></i><span class="hide-menu">Dashboard</span>
                    </a>
                </li>
                <li>
                    <a class="waves-effect waves-dark<?php echo $currentSidebarPath === '/pemohon/profile.php' ? ' active' : ''; ?>" href="/pemohon/profile.php" aria-expanded="false">
                        <i class="ti-user"></i><span class="hide-menu">Profil Saya</span>
                    </a>
                </li>
                <li>
                    <a class="waves-effect waves-dark<?php echo $currentSidebarPath === '/pemohon/applications/index.php' ? ' active' : ''; ?>" href="/pemohon/applications/index.php" aria-expanded="false">
                        <i class="ti-layout"></i><span class="hide-menu">Permohonan Saya</span>
                    </a>
                </li>
                <li>
                    <a class="waves-effect waves-dark<?php echo $currentSidebarPath === '/pemohon/notifications.php' ? ' active' : ''; ?>" href="/pemohon/notifications.php" aria-expanded="false">
                        <i class="ti-bell"></i><span class="hide-menu">Notifikasi</span>
                    </a>
                </li>
            </ul>
        </nav>
    </div>
</aside>
