<?php
$session = session();
$flashSuccess = $success ?? $session->getFlash('success');
$flashError = $error ?? $session->getFlash('error');
$siteKey = $recaptchaSiteKey ?? config('app.recaptcha_site_key');
$recaptchaConfigured = $siteKey && $siteKey !== 'YOUR_RECAPTCHA_V3_SITE_KEY';
$context = $context ?? 'admin';
$heading = $heading ?? ($context === 'applicant' ? 'Portal Pemohon eTauliah' : 'Portal Pentadbir eTauliah');
$loginAction = $loginAction ?? route('/login');
$buttonLabel = $context === 'applicant' ? 'Log Masuk Pemohon' : 'Log Masuk Pentadbir';
?>
<div class="login-box card">
    <div class="card-body">
        <form class="form-horizontal form-material" id="loginform" action="<?php echo htmlspecialchars($loginAction, ENT_QUOTES, 'UTF-8'); ?>" method="POST">
            <a href="javascript:void(0)" class="text-center db"><img src="<?php echo htmlspecialchars(asset('assets/images/jabatan-mufti-negeri-melaka-logo-05x.png'), ENT_QUOTES, 'UTF-8'); ?>" alt="Home" style="max-width:120px" /><br/></a>
            <h3 class="box-title m-b-20 text-center"><?php echo htmlspecialchars($heading, ENT_QUOTES, 'UTF-8'); ?></h3>

            <?php echo csrf_field(); ?>

            <?php if (!$recaptchaConfigured): ?>
                <div class="alert alert-warning">
                    Google reCAPTCHA v3 belum dikonfigurasikan. Sila kemas kini nilai <code>recaptcha_site_key</code> di dalam <code>config/app.php</code>.
                </div>
            <?php endif; ?>

            <div class="form-group m-t-20">
                <div class="col-xs-12">
                    <input class="form-control" type="email" name="email" id="email" required placeholder="Alamat Emel" autocomplete="username">
                </div>
            </div>
            <div class="form-group">
                <div class="col-xs-12">
                    <div class="input-group">
                        <input class="form-control" type="password" name="password" id="password" required placeholder="Kata Laluan" autocomplete="current-password">
                        <button type="button" class="btn btn-outline-secondary" id="togglePassword" aria-label="Tunjuk kata laluan">
                            <i class="far fa-eye" aria-hidden="true"></i>
                            <span class="visually-hidden">Tunjuk kata laluan</span>
                        </button>
                    </div>
                    <small id="passwordStrength" class="form-text text-muted mt-2"></small>
                </div>
            </div>
            <input type="hidden" name="recaptcha_token" value="">
            <div class="form-group text-center m-t-20">
                <div class="col-xs-12">
                    <button class="btn btn-info btn-lg w-100 text-uppercase" type="submit"><?php echo htmlspecialchars($buttonLabel, ENT_QUOTES, 'UTF-8'); ?></button>
                </div>
            </div>
            <div class="form-group m-b-0">
                <div class="col-sm-12 text-center">
                    <p>Belum mempunyai akaun? <a href="javascript:void(0)" class="text-info m-l-5"><b>Daftar Sekarang</b></a></p>
                    <p><a href="#" class="text-info m-l-5" data-bs-toggle="modal" data-bs-target="#forgotPasswordModal"><b>Lupa Kata Laluan?</b></a></p>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="modal fade" id="forgotPasswordModal" tabindex="-1" aria-labelledby="forgotPasswordModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="forgotPasswordModalLabel">Tetapan Semula Kata Laluan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
            </div>
            <div class="modal-body">
                <p class="mb-3">Masukkan alamat emel berdaftar anda. Jika akaun ditemui, kami akan menghantar kata laluan sementara.</p>
                <form id="forgotPasswordForm" method="POST" action="<?php echo htmlspecialchars(route('/password/forgot'), ENT_QUOTES, 'UTF-8'); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label for="forgotEmail" class="form-label">Alamat Emel</label>
                        <input type="email" class="form-control" id="forgotEmail" name="email" required autocomplete="email">
                    </div>
                    <div class="d-flex justify-content-end">
                        <button type="button" class="btn btn-secondary me-2" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-primary" id="forgotPasswordSubmit">Hantar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
    window.loginFlash = {
        success: <?php echo json_encode($flashSuccess, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_AMP | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE); ?>,
        error: <?php echo json_encode($flashError, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_AMP | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE); ?>
    };
</script>
