<?php
$user = $user ?? ['name' => 'Pentadbir'];
?>
<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row page-titles">
            <div class="col-md-5 align-self-center">
                <h4 class="text-themecolor">Dashboard Pentadbir</h4>
            </div>
            <div class="col-md-7 align-self-center text-end">
                <div class="d-flex justify-content-end align-items-center">
                    <ol class="breadcrumb justify-content-end">
                        <li class="breadcrumb-item"><a href="<?php echo route('/dashboard'); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item active">Utama</li>
                    </ol>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-3 col-md-6">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Jumlah Permohonan</h5>
                        <h3 class="m-b-20"><?php echo number_format($stats['applications_total'] ?? 0); ?></h3>
                        <div class="progress">
                            <div class="progress-bar bg-info" role="progressbar" style="width: 72%" aria-valuenow="72" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Sedang Diproses</h5>
                        <h3 class="m-b-20 text-warning"><?php echo number_format($stats['applications_pending'] ?? 0); ?></h3>
                        <div class="progress">
                            <div class="progress-bar bg-warning" role="progressbar" style="width: 45%" aria-valuenow="45" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Diluluskan</h5>
                        <h3 class="m-b-20 text-success"><?php echo number_format($stats['applications_approved'] ?? 0); ?></h3>
                        <div class="progress">
                            <div class="progress-bar bg-success" role="progressbar" style="width: 88%" aria-valuenow="88" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Ditolak</h5>
                        <h3 class="m-b-20 text-danger"><?php echo number_format($stats['applications_rejected'] ?? 0); ?></h3>
                        <div class="progress">
                            <div class="progress-bar bg-danger" role="progressbar" style="width: 30%" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Trend Permohonan Tahunan</h4>
                        <div id="applications-trend"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Pengumuman</h4>
                        <ul class="list-unstyled">
                            <li class="m-b-15"><span class="badge bg-danger me-2">Baru</span> Kemas kini prosedur semakan permohonan Tauliah Agama.</li>
                            <li class="m-b-15"><span class="badge bg-info me-2">Makluman</span> Sistem akan menjalani penyelenggaraan pada 15 Feb 2025.</li>
                            <li><span class="badge bg-success me-2">Mesyuarat</span> JKPPAI dijadualkan pada 20 Feb 2025.</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Permohonan Terbaharu</h4>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>No. Permohonan</th>
                                        <th>Nama Pemohon</th>
                                        <th>Jenis</th>
                                        <th>Status</th>
                                        <th>Kemaskini</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>ETA-2025-0101</td>
                                        <td>Ali Ahmad</td>
                                        <td>Tauliah Agama</td>
                                        <td><span class="badge bg-info">Dalam Semakan</span></td>
                                        <td>10 Feb 2025</td>
                                    </tr>
                                    <tr>
                                        <td>ETA-2025-0102</td>
                                        <td>Siti Aminah</td>
                                        <td>Tauliah Al-Quran</td>
                                        <td><span class="badge bg-success">Diluluskan</span></td>
                                        <td>09 Feb 2025</td>
                                    </tr>
                                    <tr>
                                        <td>ETA-2025-0103</td>
                                        <td>Faridah Omar</td>
                                        <td>Tauliah Agama</td>
                                        <td><span class="badge bg-warning">Menunggu Pembayaran</span></td>
                                        <td>08 Feb 2025</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
