﻿<?php

if (!function_exists('pemohon_asset')) {
    require_once __DIR__ . '/includes/helpers.php';
}

$footerText = $footerText ?? '&copy; ' . date('Y') . ' Jabatan Mufti Negeri Melaka - Portal Pemohon eTauliah';
?>
        <footer class="footer">
            <?php echo $footerText; ?>
        </footer>
        <!-- ============================================================== -->
        <!-- Right sidebar -->
        <!-- ============================================================== -->
        <div class="right-sidebar">
            <div class="slimscrollright">
                <div class="rpanel-title">
                    Service Panel
                    <span><i class="ti-close right-side-toggle"></i></span>
                </div>
                <div class="r-panel-body">
                    <ul id="themecolors" class="m-t-20">
                        <li><b>With Light sidebar</b></li>
                        <li><a href="javascript:void(0)" data-skin="skin-default" class="default-theme">1</a></li>
                        <li><a href="javascript:void(0)" data-skin="skin-green" class="green-theme">2</a></li>
                        <li><a href="javascript:void(0)" data-skin="skin-red" class="red-theme">3</a></li>
                        <li><a href="javascript:void(0)" data-skin="skin-blue" class="blue-theme">4</a></li>
                        <li><a href="javascript:void(0)" data-skin="skin-purple" class="purple-theme">5</a></li>
                        <li><a href="javascript:void(0)" data-skin="skin-megna" class="megna-theme">6</a></li>
                        <li class="d-block m-t-30"><b>With Dark sidebar</b></li>
                        <li><a href="javascript:void(0)" data-skin="skin-default-dark" class="default-dark-theme">7</a></li>
                        <li><a href="javascript:void(0)" data-skin="skin-green-dark" class="green-dark-theme">8</a></li>
                        <li><a href="javascript:void(0)" data-skin="skin-red-dark" class="red-dark-theme working">9</a></li>
                        <li><a href="javascript:void(0)" data-skin="skin-blue-dark" class="blue-dark-theme">10</a></li>
                        <li><a href="javascript:void(0)" data-skin="skin-purple-dark" class="purple-dark-theme">11</a></li>
                        <li><a href="javascript:void(0)" data-skin="skin-megna-dark" class="megna-dark-theme">12</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <script src="<?php echo htmlspecialchars(pemohon_asset('assets/node_modules/jquery/dist/jquery.min.js'), ENT_QUOTES, 'UTF-8'); ?>"></script>
    <script src="<?php echo htmlspecialchars(pemohon_asset('assets/bootstrap-5.2.3/js/bootstrap.bundle.min.js'), ENT_QUOTES, 'UTF-8'); ?>"></script>
    <script src="<?php echo htmlspecialchars(pemohon_asset('assets/bsd5/js/bootstrap-dialog.min.js'), ENT_QUOTES, 'UTF-8'); ?>"></script>
    <script src="<?php echo htmlspecialchars(pemohon_asset('assets/node_modules/datatables.net/js/jquery.dataTables.min.js'), ENT_QUOTES, 'UTF-8'); ?>"></script>
    <script src="<?php echo htmlspecialchars(pemohon_asset('assets/node_modules/datatables.net-bs4/js/dataTables.bootstrap4.min.js'), ENT_QUOTES, 'UTF-8'); ?>"></script>
    <script src="<?php echo htmlspecialchars(pemohon_asset('dist/js/perfect-scrollbar.jquery.min.js'), ENT_QUOTES, 'UTF-8'); ?>"></script>
    <script src="<?php echo htmlspecialchars(pemohon_asset('dist/js/waves.js'), ENT_QUOTES, 'UTF-8'); ?>"></script>
    <script src="<?php echo htmlspecialchars(pemohon_asset('dist/js/sidebarmenu.js'), ENT_QUOTES, 'UTF-8'); ?>"></script>
    <script src="<?php echo htmlspecialchars(pemohon_asset('assets/node_modules/sticky-kit-master/dist/sticky-kit.min.js'), ENT_QUOTES, 'UTF-8'); ?>"></script>
    <script src="<?php echo htmlspecialchars(pemohon_asset('assets/node_modules/sparkline/jquery.sparkline.min.js'), ENT_QUOTES, 'UTF-8'); ?>"></script>
    <script src="https://unpkg.com/filepond@^4/dist/filepond.min.js"></script>
    <script src="https://unpkg.com/filepond-plugin-file-validate-type@^1/dist/filepond-plugin-file-validate-type.min.js"></script>
    <script src="https://unpkg.com/filepond-plugin-file-validate-size@^2/dist/filepond-plugin-file-validate-size.min.js"></script>
    <script src="https://unpkg.com/filepond-plugin-image-preview@^4/dist/filepond-plugin-image-preview.min.js"></script>
    <script src="https://unpkg.com/filepond-plugin-image-resize@^3/dist/filepond-plugin-image-resize.min.js"></script>
    <script src="https://unpkg.com/filepond-plugin-image-transform@^3/dist/filepond-plugin-image-transform.min.js"></script>
    <script src="<?php echo htmlspecialchars(pemohon_asset('dist/js/custom.min.js'), ENT_QUOTES, 'UTF-8'); ?>"></script>
    <script>
        (function () {
            if (typeof window.jQuery !== 'undefined') {
                jQuery(function ($) {
                    $('.preloader').fadeOut();
                });
            }
        }());
    </script>
    <script>
        (function () {
            const card = document.getElementById('applicant-education-card');
            if (!card) {
                return;
            }

            const summaryList = card.querySelector('[data-role="education-summary-list"]');
            const summaryEmpty = card.querySelector('[data-role="education-summary-empty"]');
            const summaryLoading = card.querySelector('[data-role="education-summary-loading"]');
            const highestQualificationEl = card.querySelector('[data-role="education-highest-qualification"]');
            const highestYearsEl = card.querySelector('[data-role="education-highest-years"]');
            const highestInstitutionEl = card.querySelector('[data-role="education-highest-institution"]');
            const manageButton = card.querySelector('[data-role="education-manage"]');
            const templateEl = document.getElementById('education-modal-template');

            if (!summaryList || !summaryEmpty || !summaryLoading || !manageButton || !templateEl) {
                return;
            }

            const state = {
                items: [],
                editingId: null,
                isSubmitting: false,
                isReordering: false,
            };

            function buildPemohonUrl(path) {
                const normalizedPath = (path || '').toString().replace(/^\/+/, '');
                const parts = window.location.pathname.split('/pemohon/');
                if (parts.length > 1) {
                    const prefix = parts[0];
                    const basePrefix = prefix ? prefix.replace(/\/?$/, '/') : '/';
                    return (basePrefix + 'pemohon/' + normalizedPath).replace(/\/{2,}/g, '/');
                }
                return '/pemohon/' + normalizedPath;
            }

            function toggleSummaryLoading(isLoading) {
                if (!summaryLoading) {
                    return;
                }
                summaryLoading.classList.toggle('d-none', !isLoading);
                if (isLoading) {
                    summaryList.classList.add('d-none');
                    summaryEmpty.classList.add('d-none');
                }
            }

            function formatYearRange(item) {
                const startYear = item && item.start_year ? Number(item.start_year) : null;
                const endYear = item && item.end_year ? Number(item.end_year) : null;
                if (!startYear && !endYear) {
                    return '';
                }
                if (startYear && endYear) {
                    return startYear + ' - ' + endYear;
                }
                if (startYear && !endYear) {
                    return startYear + ' - Kini';
                }
                if (!startYear && endYear) {
                    return 'Sehingga ' + endYear;
                }
                return '';
            }

            function getHighestEducation() {
                if (!Array.isArray(state.items) || state.items.length === 0) {
                    return null;
                }
                const flagged = state.items.find(function (item) {
                    return item && item.is_highest;
                });
                return flagged || state.items[0] || null;
            }

            function updateHighestLabels() {
                if (!highestQualificationEl && !highestInstitutionEl && !highestYearsEl) {
                    return;
                }
                const highest = getHighestEducation();
                if (highestQualificationEl) {
                    highestQualificationEl.textContent = highest && highest.qualification ? highest.qualification : '-';
                }
                if (highestYearsEl) {
                    const yearsText = highest ? formatYearRange(highest) : '';
                    highestYearsEl.textContent = yearsText || '-';
                }
                if (highestInstitutionEl) {
                    highestInstitutionEl.textContent = highest && highest.institution ? highest.institution : '-';
                }
            }

            function renderSummary() {
                summaryList.innerHTML = '';
                const highest = getHighestEducation();
                updateHighestLabels();

                const others = Array.isArray(state.items)
                    ? state.items.filter(function (item) {
                        if (!highest) {
                            return true;
                        }
                        return Number(item.id) !== Number(highest.id);
                    })
                    : [];

                if (others.length === 0) {
                    summaryList.classList.add('d-none');
                    summaryEmpty.classList.remove('d-none');
                    return;
                }

                summaryEmpty.classList.add('d-none');
                summaryList.classList.remove('d-none');

                others.forEach(function (item) {
                    const listItem = document.createElement('li');
                    listItem.className = 'list-group-item px-0';

                    const title = document.createElement('div');
                    title.className = 'fw-semibold';
                    title.textContent = item.institution || '-';
                    listItem.appendChild(title);

                    const metaParts = [];
                    if (item.qualification) {
                        metaParts.push(item.qualification);
                    }
                    if (item.field_of_study) {
                        metaParts.push(item.field_of_study);
                    }
                    const yearRange = formatYearRange(item);
                    if (yearRange) {
                        metaParts.push(yearRange);
                    }

                    if (metaParts.length) {
                        const meta = document.createElement('div');
                        meta.className = 'text-muted small';
                        meta.textContent = metaParts.join(' • ');
                        listItem.appendChild(meta);
                    }

                    summaryList.appendChild(listItem);
                });
            }

            function setEducationItems(items) {
                state.items = Array.isArray(items)
                    ? items.filter(Boolean).map(function (item) {
                        const clone = Object.assign({}, item);
                        clone.id = Number(clone.id);
                        clone.is_highest = Boolean(clone.is_highest);
                        clone.display_order = Number(clone.display_order || 0);
                        return clone;
                    })
                    : [];
                renderSummary();
            }

            function setModalAlert(elements, message, type) {
                const alertBox = elements.alertEl;
                if (!alertBox) {
                    return;
                }
                alertBox.classList.add('d-none');
                alertBox.classList.remove('alert-success', 'alert-danger', 'alert-warning', 'alert-info');
                if (!message) {
                    alertBox.textContent = '';
                    return;
                }
                alertBox.textContent = message;
                alertBox.classList.add('alert', 'alert-' + (type || 'info'));
                alertBox.classList.remove('d-none');
            }

            function renderModalItems(elements, items) {
                const listEl = elements.listEl;
                const emptyEl = elements.emptyEl;
                if (!listEl || !emptyEl) {
                    return;
                }

                listEl.innerHTML = '';
                if (!Array.isArray(items) || items.length === 0) {
                    listEl.classList.add('d-none');
                    emptyEl.classList.remove('d-none');
                    return;
                }

                emptyEl.classList.add('d-none');
                listEl.classList.remove('d-none');

                items.forEach(function (item) {
                    const listItem = document.createElement('li');
                    listItem.className = 'list-group-item';
                    listItem.dataset.educationId = String(item.id);
                    listItem.setAttribute('draggable', 'true');

                    const row = document.createElement('div');
                    row.className = 'd-flex flex-column flex-lg-row align-items-start gap-3';
                    listItem.appendChild(row);

                    const dragHandle = document.createElement('span');
                    dragHandle.className = 'text-muted drag-handle flex-shrink-0';
                    dragHandle.innerHTML = '<i class="ti-menu"></i>';
                    dragHandle.setAttribute('role', 'button');
                    dragHandle.tabIndex = 0;
                    row.appendChild(dragHandle);

                    const infoWrapper = document.createElement('div');
                    infoWrapper.className = 'me-lg-3 flex-grow-1';

                    const title = document.createElement('div');
                    title.className = 'fw-semibold d-flex align-items-center gap-2';
                    const titleText = document.createElement('span');
                    titleText.textContent = item.institution || '-';
                    title.appendChild(titleText);
                    if (item.is_highest) {
                        const badge = document.createElement('span');
                        badge.className = 'badge bg-success';
                        badge.textContent = 'Tertinggi';
                        title.appendChild(badge);
                    }
                    infoWrapper.appendChild(title);

                    const metaParts = [];
                    if (item.qualification) {
                        metaParts.push(item.qualification);
                    }
                    if (item.field_of_study) {
                        metaParts.push(item.field_of_study);
                    }
                    const range = formatYearRange(item);
                    if (range) {
                        metaParts.push(range);
                    }
                    if (metaParts.length) {
                        const meta = document.createElement('div');
                        meta.className = 'text-muted small';
                        meta.textContent = metaParts.join(' • ');
                        infoWrapper.appendChild(meta);
                    }

                    if (item.description) {
                        const description = document.createElement('div');
                        description.className = 'text-muted small';
                        description.textContent = item.description;
                        infoWrapper.appendChild(description);
                    }

                    row.appendChild(infoWrapper);

                    const actionWrapper = document.createElement('div');
                    actionWrapper.className = 'd-flex flex-column flex-sm-row gap-2 ms-lg-auto';

                    const editBtn = document.createElement('button');
                    editBtn.type = 'button';
                    editBtn.className = 'btn btn-sm btn-outline-primary';
                    editBtn.dataset.role = 'education-edit';
                    editBtn.dataset.educationId = String(item.id);
                    editBtn.innerHTML = '<i class="ti-pencil"></i> Kemaskini';
                    actionWrapper.appendChild(editBtn);

                    const deleteBtn = document.createElement('button');
                    deleteBtn.type = 'button';
                    deleteBtn.className = 'btn btn-sm btn-outline-danger';
                    deleteBtn.dataset.role = 'education-delete';
                    deleteBtn.dataset.educationId = String(item.id);
                    deleteBtn.innerHTML = '<i class="ti-trash"></i> Padam';
                    actionWrapper.appendChild(deleteBtn);

                    row.appendChild(actionWrapper);
                    listEl.appendChild(listItem);
                });

                if (typeof elements.setupDragHandlers === 'function') {
                    elements.setupDragHandlers();
                }
            }

            function loadEducations(options) {
                const opts = options || {};
                const showSummaryLoading = Boolean(opts.showSummaryLoading);
                const modalElements = opts.modalElements || null;

                if (showSummaryLoading) {
                    toggleSummaryLoading(true);
                }
                if (modalElements && modalElements.loadingEl) {
                    modalElements.loadingEl.classList.remove('d-none');
                    if (modalElements.emptyEl) {
                        modalElements.emptyEl.classList.add('d-none');
                    }
                    if (modalElements.listEl) {
                        modalElements.listEl.classList.add('d-none');
                    }
                }

                return fetch(buildPemohonUrl('educations.php'), {
                    method: 'GET',
                    credentials: 'same-origin',
                    headers: {
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    }
                }).then(function (response) {
                    if (!response.ok) {
                        throw new Error('Gagal memuatkan kelayakan akademik.');
                    }
                    return response.json();
                }).then(function (payload) {
                    const items = Array.isArray(payload.items) ? payload.items.filter(Boolean) : [];
                    setEducationItems(items);
                    if (modalElements) {
                        renderModalItems(modalElements, items);
                        setModalAlert(modalElements, '', '');
                    }
                    return items;
                }).catch(function (error) {
                    console.error('Gagal memuatkan kelayakan akademik:', error);
                    if (modalElements) {
                        setModalAlert(modalElements, 'Gagal memuatkan senarai kelayakan. Sila cuba lagi.', 'danger');
                        renderModalItems(modalElements, []);
                    }
                    return [];
                }).finally(function () {
                    if (showSummaryLoading) {
                        toggleSummaryLoading(false);
                    }
                    if (modalElements && modalElements.loadingEl) {
                        modalElements.loadingEl.classList.add('d-none');
                    }
                });
            }

            function enforceDialogHeight(dialogInstance) {
                if (!dialogInstance) {
                    return;
                }
                const modalDialog = dialogInstance.getModalDialog ? dialogInstance.getModalDialog() : null;
                const modalBody = dialogInstance.getModalBody ? dialogInstance.getModalBody() : null;
                if (modalDialog) {
                    if (typeof modalDialog.css === 'function') {
                        modalDialog.css('max-height', '80vh');
                    } else if (modalDialog[0]) {
                        modalDialog[0].style.maxHeight = '80vh';
                    }
                }
                if (modalBody) {
                    const styles = {
                        'max-height': 'calc(80vh - 130px)',
                        'overflow-y': 'auto'
                    };
                    if (typeof modalBody.css === 'function') {
                        modalBody.css(styles);
                    } else if (modalBody[0]) {
                        modalBody[0].style.maxHeight = styles['max-height'];
                        modalBody[0].style.overflowY = styles['overflow-y'];
                    }
                }
            }

            function getOrderFromList(listEl) {
                if (!listEl) {
                    return [];
                }
                return Array.prototype.slice.call(listEl.querySelectorAll('[data-education-id]'))
                    .map(function (element) {
                        return Number(element.getAttribute('data-education-id'));
                    })
                    .filter(function (id) {
                        return Number.isFinite(id) && id > 0;
                    });
            }

            function submitReorder(modalElements, orderIds) {
                if (!Array.isArray(orderIds) || orderIds.length === 0) {
                    return;
                }

                const currentOrder = state.items.map(function (item) {
                    return Number(item.id);
                });
                const changed = orderIds.length !== currentOrder.length || orderIds.some(function (id, index) {
                    return id !== currentOrder[index];
                });
                if (!changed) {
                    return;
                }

                if (!modalElements || !modalElements.tokenInput || !modalElements.tokenInput.value) {
                    setModalAlert(modalElements || {}, 'Token keselamatan tidak sah. Sila muat semula halaman.', 'danger');
                    return;
                }

                if (state.isReordering) {
                    return;
                }

                state.isReordering = true;
                const formData = new FormData();
                formData.append('_token', modalElements.tokenInput.value);
                formData.append('_action', 'reorder');
                formData.append('order', JSON.stringify(orderIds));

                fetch(buildPemohonUrl('educations.php'), {
                    method: 'POST',
                    body: formData,
                    credentials: 'same-origin',
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest'
                    }
                }).then(function (response) {
                    return response.json().then(function (payload) {
                        return {response: response, payload: payload};
                    }).catch(function () {
                        return {response: response, payload: {}};
                    });
                }).then(function (result) {
                    const response = result.response;
                    const payload = result.payload || {};
                    if (!response.ok) {
                        throw new Error(payload.message || 'Gagal mengemaskini susunan kelayakan.');
                    }
                    const items = Array.isArray(payload.items) ? payload.items.filter(Boolean) : [];
                    setEducationItems(items);
                    if (modalElements) {
                        renderModalItems(modalElements, items);
                        setModalAlert(modalElements, payload.message || 'Susunan kelayakan berjaya dikemaskini.', 'success');
                    }
                }).catch(function (error) {
                    console.error('Gagal mengemaskini susunan kelayakan:', error);
                    if (modalElements) {
                        setModalAlert(modalElements, error.message || 'Gagal mengemaskini susunan kelayakan.', 'danger');
                    }
                    loadEducations({ modalElements: modalElements });
                }).finally(function () {
                    state.isReordering = false;
                });
            }

            function setupDragHandlers(modalElements) {
                const listEl = modalElements.listEl;
                if (!listEl || listEl.dataset.dragEnabled === '1') {
                    return;
                }
                listEl.dataset.dragEnabled = '1';

                let draggingItem = null;

                function getDragAfterElement(container, y) {
                    const items = Array.prototype.slice.call(container.querySelectorAll('[data-education-id]:not(.dragging)'));
                    let closest = {offset: Number.NEGATIVE_INFINITY, element: null};

                    items.forEach(function (child) {
                        const box = child.getBoundingClientRect();
                        const offset = y - box.top - box.height / 2;
                        if (offset < 0 && offset > closest.offset) {
                            closest = {offset: offset, element: child};
                        }
                    });

                    return closest.element;
                }

                listEl.addEventListener('dragstart', function (event) {
                    const target = event.target instanceof Element ? event.target.closest('[data-education-id]') : null;
                    if (!target) {
                        return;
                    }
                    draggingItem = target;
                    target.classList.add('dragging');
                    if (event.dataTransfer) {
                        event.dataTransfer.effectAllowed = 'move';
                        event.dataTransfer.setData('text/plain', target.dataset.educationId || '');
                    }
                });

                listEl.addEventListener('dragover', function (event) {
                    if (!draggingItem) {
                        return;
                    }
                    event.preventDefault();
                    const afterElement = getDragAfterElement(listEl, event.clientY);
                    if (afterElement == null) {
                        listEl.appendChild(draggingItem);
                    } else {
                        listEl.insertBefore(draggingItem, afterElement);
                    }
                });

                listEl.addEventListener('dragend', function () {
                    if (draggingItem) {
                        draggingItem.classList.remove('dragging');
                    }
                    draggingItem = null;
                });

                listEl.addEventListener('drop', function (event) {
                    if (!draggingItem) {
                        return;
                    }
                    event.preventDefault();
                    draggingItem.classList.remove('dragging');
                    const order = getOrderFromList(listEl);
                    draggingItem = null;
                    submitReorder(modalElements, order);
                });
            }

            function openEducationModal() {
                if (typeof BootstrapDialog === 'undefined') {
                    alert('Modul dialog tidak tersedia.');
                    return;
                }

                const fragment = templateEl.content ? templateEl.content.cloneNode(true) : null;
                const wrapper = document.createElement('div');
                if (fragment) {
                    wrapper.appendChild(fragment);
                } else {
                    wrapper.innerHTML = templateEl.innerHTML;
                }

                const modalElements = {
                    root: wrapper,
                    alertEl: wrapper.querySelector('[data-role="education-modal-alert"]'),
                    loadingEl: wrapper.querySelector('[data-role="education-modal-loading"]'),
                    emptyEl: wrapper.querySelector('[data-role="education-modal-empty"]'),
                    listEl: wrapper.querySelector('[data-role="education-modal-list"]'),
                    formEl: wrapper.querySelector('[data-role="education-modal-form"]'),
                    errorEl: wrapper.querySelector('[data-role="education-modal-error"]'),
                    submitBtn: wrapper.querySelector('[data-role="education-submit"]'),
                    submitText: null,
                    submitSpinner: null,
                    tokenInput: wrapper.querySelector('form input[name="_token"]'),
                    actionInput: wrapper.querySelector('[data-role="education-action"]'),
                    idInput: wrapper.querySelector('[data-role="education-id"]'),
                    isHighestInput: wrapper.querySelector('#education-highest-input'),
                    cancelBtn: wrapper.querySelector('[data-role="education-cancel-edit"]'),
                    setupDragHandlers: function () {}
                };

                modalElements.submitText = modalElements.submitBtn ? modalElements.submitBtn.querySelector('.submit-text') : null;
                modalElements.submitSpinner = modalElements.submitBtn ? modalElements.submitBtn.querySelector('.spinner-border') : null;
                modalElements.setupDragHandlers = function () {
                    setupDragHandlers(modalElements);
                };

                function setFormLoading(isLoading) {
                    if (!modalElements.submitBtn) {
                        return;
                    }
                    modalElements.submitBtn.disabled = isLoading;
                    if (modalElements.submitSpinner) {
                        modalElements.submitSpinner.classList.toggle('d-none', !isLoading);
                    }
                    if (modalElements.submitText) {
                        modalElements.submitText.textContent = isLoading
                            ? 'Menyimpan...'
                            : (state.editingId ? 'Kemaskini' : 'Tambah');
                    }
                }

                function setFormError(message) {
                    const errorBox = modalElements.errorEl;
                    if (!errorBox) {
                        return;
                    }
                    errorBox.classList.add('d-none');
                    if (!message) {
                        errorBox.textContent = '';
                        return;
                    }
                    errorBox.textContent = message;
                    errorBox.classList.remove('d-none');
                }

                function resetForm() {
                    state.editingId = null;
                    if (modalElements.formEl) {
                        modalElements.formEl.reset();
                    }
                    if (modalElements.actionInput) {
                        modalElements.actionInput.value = 'create';
                    }
                    if (modalElements.idInput) {
                        modalElements.idInput.value = '';
                    }
                    if (modalElements.isHighestInput) {
                        modalElements.isHighestInput.checked = false;
                    }
                    if (modalElements.submitText) {
                        modalElements.submitText.textContent = 'Tambah';
                    }
                    if (modalElements.cancelBtn) {
                        modalElements.cancelBtn.classList.add('d-none');
                    }
                }

                function startEdit(item) {
                    state.editingId = Number(item.id);
                    if (modalElements.actionInput) {
                        modalElements.actionInput.value = 'update';
                    }
                    if (modalElements.idInput) {
                        modalElements.idInput.value = String(item.id);
                    }
                    if (modalElements.formEl) {
                        const setValue = function (selector, value) {
                            const field = modalElements.formEl.querySelector(selector);
                            if (field) {
                                field.value = value || '';
                            }
                        };
                        setValue('#education-institution-input', item.institution || '');
                        setValue('#education-qualification-input', item.qualification || '');
                        setValue('#education-field-input', item.field_of_study || '');
                        setValue('#education-start-year-input', item.start_year ? String(item.start_year) : '');
                        setValue('#education-end-year-input', item.end_year ? String(item.end_year) : '');
                        const descriptionInput = modalElements.formEl.querySelector('#education-description-input');
                        if (descriptionInput) {
                            descriptionInput.value = item.description || '';
                        }
                    }
                    if (modalElements.isHighestInput) {
                        modalElements.isHighestInput.checked = Boolean(item.is_highest);
                    }
                    if (modalElements.submitText) {
                        modalElements.submitText.textContent = 'Kemaskini';
                    }
                    if (modalElements.cancelBtn) {
                        modalElements.cancelBtn.classList.remove('d-none');
                    }
                    setModalAlert(modalElements, '', '');
                    setFormError('');
                    const focusTarget = modalElements.formEl ? modalElements.formEl.querySelector('#education-institution-input') : null;
                    if (focusTarget && typeof focusTarget.focus === 'function') {
                        focusTarget.focus({ preventScroll: true });
                    }
                }

                if (modalElements.cancelBtn) {
                    modalElements.cancelBtn.addEventListener('click', function (event) {
                        event.preventDefault();
                        resetForm();
                        setModalAlert(modalElements, '', '');
                    });
                }

                const dialog = new BootstrapDialog({
                    title: 'Kelayakan Akademik',
                    message: wrapper,
                    size: BootstrapDialog.SIZE_WIDE ? BootstrapDialog.SIZE_WIDE : (BootstrapDialog.SIZE_NORMAL || null),
                    autodestroy: true,
                    nl2br: false,
                    buttons: [
                        {
                            label: 'Tutup',
                            cssClass: 'btn btn-light',
                            action: function (dialogRef) {
                                dialogRef.close();
                            }
                        }
                    ],
                    onshown: function (dialogRef) {
                        enforceDialogHeight(dialogRef);
                        resetForm();
                        renderModalItems(modalElements, state.items);
                        modalElements.setupDragHandlers();
                        if (modalElements.formEl) {
                            const firstInput = modalElements.formEl.querySelector('input[name="institution"]');
                            if (firstInput && typeof firstInput.focus === 'function') {
                                firstInput.focus({ preventScroll: true });
                            }
                        }
                        loadEducations({ modalElements: modalElements });
                    }
                });

                dialog.realize();
                enforceDialogHeight(dialog);
                dialog.open();

                if (modalElements.formEl) {
                    modalElements.formEl.addEventListener('submit', function (event) {
                        event.preventDefault();
                        if (state.isSubmitting) {
                            return;
                        }
                        if (!modalElements.tokenInput || !modalElements.tokenInput.value) {
                            setFormError('Token keselamatan tidak sah. Sila muat semula halaman.');
                            return;
                        }

                        if (modalElements.actionInput) {
                            modalElements.actionInput.value = state.editingId ? 'update' : 'create';
                        }
                        if (!state.editingId && modalElements.idInput) {
                            modalElements.idInput.value = '';
                        }

                        const formData = new FormData(modalElements.formEl);
                        setFormError('');
                        setModalAlert(modalElements, '', '');
                        setFormLoading(true);
                        state.isSubmitting = true;

                        fetch(buildPemohonUrl('educations.php'), {
                            method: 'POST',
                            body: formData,
                            credentials: 'same-origin',
                            headers: {
                                'X-Requested-With': 'XMLHttpRequest'
                            }
                        }).then(function (response) {
                            return response.json().then(function (payload) {
                                return {response: response, payload: payload};
                            }).catch(function () {
                                return {response: response, payload: {}};
                            });
                        }).then(function (result) {
                            const response = result.response;
                            const payload = result.payload || {};
                            if (!response.ok) {
                                const messageParts = [];
                                if (payload.errors) {
                                    Object.keys(payload.errors).forEach(function (key) {
                                        const errorValue = payload.errors[key];
                                        if (Array.isArray(errorValue)) {
                                            messageParts.push(errorValue.join(' '));
                                        } else if (typeof errorValue === 'string') {
                                            messageParts.push(errorValue);
                                        }
                                    });
                                }
                                if (messageParts.length === 0 && payload.message) {
                                    messageParts.push(payload.message);
                                }
                                setFormError(messageParts.join(' ') || 'Maklumat yang diberikan tidak sah.');
                                return;
                            }

                            const wasEditing = Boolean(state.editingId);
                            resetForm();
                            setFormError('');
                            setModalAlert(modalElements, payload.message || (wasEditing ? 'Rekod kelayakan berjaya dikemaskini.' : 'Rekod kelayakan berjaya ditambah.'), 'success');
                            loadEducations({ modalElements: modalElements });
                        }).catch(function (error) {
                            console.error('Gagal menyimpan kelayakan:', error);
                            setFormError('Ralat tidak dijangka berlaku. Sila cuba lagi.');
                        }).finally(function () {
                            state.isSubmitting = false;
                            setFormLoading(false);
                        });
                    });
                }

                if (modalElements.listEl) {
                    modalElements.listEl.addEventListener('click', function (event) {
                        const targetElement = event.target instanceof Element ? event.target : null;
                        if (!targetElement) {
                            return;
                        }

                        const editTrigger = targetElement.closest('[data-role="education-edit"]');
                        if (editTrigger) {
                            const educationId = Number(editTrigger.getAttribute('data-education-id'));
                            if (!educationId || Number.isNaN(educationId)) {
                                return;
                            }
                            const item = state.items.find(function (entry) {
                                return Number(entry.id) === educationId;
                            });
                            if (item) {
                                startEdit(item);
                            }
                            return;
                        }

                        const deleteTrigger = targetElement.closest('[data-role="education-delete"]');
                        if (!deleteTrigger) {
                            return;
                        }
                        const educationId = Number(deleteTrigger.getAttribute('data-education-id'));
                        if (!educationId || Number.isNaN(educationId)) {
                            return;
                        }
                        if (!modalElements.tokenInput || !modalElements.tokenInput.value) {
                            setModalAlert(modalElements, 'Token keselamatan tidak sah. Sila muat semula halaman.', 'danger');
                            return;
                        }
                        if (!confirm('Padam rekod kelayakan ini?')) {
                            return;
                        }

                        const originalHtml = deleteTrigger.innerHTML;
                        deleteTrigger.disabled = true;
                        deleteTrigger.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>';

                        const formData = new FormData();
                        formData.append('_token', modalElements.tokenInput.value);
                        formData.append('_action', 'delete');
                        formData.append('id', String(educationId));

                        fetch(buildPemohonUrl('educations.php'), {
                            method: 'POST',
                            body: formData,
                            credentials: 'same-origin',
                            headers: {
                                'X-Requested-With': 'XMLHttpRequest'
                            }
                        }).then(function (response) {
                            return response.json().then(function (payload) {
                                return {response: response, payload: payload};
                            }).catch(function () {
                                return {response: response, payload: {}};
                            });
                        }).then(function (result) {
                            const response = result.response;
                            const payload = result.payload || {};
                            if (!response.ok) {
                                setModalAlert(modalElements, payload.message || 'Gagal memadam rekod kelayakan.', 'danger');
                                return;
                            }
                            if (state.editingId === educationId) {
                                resetForm();
                            }
                            setModalAlert(modalElements, payload.message || 'Rekod kelayakan berjaya dipadam.', 'success');
                            loadEducations({ modalElements: modalElements });
                        }).catch(function (error) {
                            console.error('Gagal memadam kelayakan:', error);
                            setModalAlert(modalElements, 'Ralat tidak dijangka berlaku. Sila cuba lagi.', 'danger');
                        }).finally(function () {
                            deleteTrigger.disabled = false;
                            deleteTrigger.innerHTML = originalHtml;
                        });
                    });
                }
            }

            manageButton.addEventListener('click', function (event) {
                event.preventDefault();
                openEducationModal();
            });

            loadEducations({ showSummaryLoading: true });
        }());
    </script>
    <script>
        (function () {
            const card = document.getElementById('applicant-documents-card');
            if (!card) {
                return;
            }

            const listEl = card.querySelector('[data-role="document-list"]');
            const emptyEl = card.querySelector('[data-role="document-empty"]');
            const loadingEl = card.querySelector('[data-role="document-loading"]');
            const alertEl = card.querySelector('[data-role="document-alert"]');
            const addButton = card.querySelector('[data-role="document-add"]');
            const templateEl = document.getElementById('document-upload-template');

            if (!listEl || !emptyEl || !loadingEl) {
                return;
            }

            const documentsMap = new Map();

            function buildPemohonUrl(path) {
                const normalizedPath = (path || '').toString().replace(/^\/+/, '');
                const parts = window.location.pathname.split('/pemohon/');
                if (parts.length > 1) {
                    const prefix = parts[0];
                    const basePrefix = prefix ? prefix.replace(/\/?$/, '/') : '/';
                    return (basePrefix + 'pemohon/' + normalizedPath).replace(/\/{2,}/g, '/');
                }
                return '/pemohon/' + normalizedPath;
            }

            function formatBytes(bytes) {
                if (!bytes || Number.isNaN(bytes)) {
                    return '0 B';
                }
                const units = ['B', 'KB', 'MB', 'GB'];
                let size = bytes;
                let unitIndex = 0;
                while (size >= 1024 && unitIndex < units.length - 1) {
                    size /= 1024;
                    unitIndex += 1;
                }
                const precision = unitIndex === 0 ? 0 : 1;
                return size.toFixed(precision) + ' ' + units[unitIndex];
            }

            function formatDateTime(value) {
                if (!value) {
                    return '';
                }
                const date = new Date(value);
                if (Number.isNaN(date.getTime())) {
                    return '';
                }
                try {
                    return new Intl.DateTimeFormat('ms-MY', {
                        day: '2-digit',
                        month: 'short',
                        year: 'numeric',
                        hour: '2-digit',
                        minute: '2-digit'
                    }).format(date);
                } catch (error) {
                    return date.toLocaleString();
                }
            }

            function showAlert(message, type) {
                if (!alertEl) {
                    return;
                }
                alertEl.classList.add('d-none');
                alertEl.classList.remove('alert-success', 'alert-danger', 'alert-warning', 'alert-info');
                if (!message) {
                    alertEl.textContent = '';
                    return;
                }
                alertEl.textContent = message;
                alertEl.classList.add('alert', 'alert-' + (type || 'info'));
                alertEl.classList.remove('d-none');
            }

            function setLoading(state) {
                if (state) {
                    loadingEl.classList.remove('d-none');
                    listEl.classList.add('d-none');
                    emptyEl.classList.add('d-none');
                    return;
                }
                loadingEl.classList.add('d-none');
            }

            function clearList() {
                documentsMap.clear();
                listEl.innerHTML = '';
                listEl.classList.add('d-none');
                emptyEl.classList.remove('d-none');
            }

            function renderDocuments(items) {
                documentsMap.clear();
                listEl.innerHTML = '';

                if (!Array.isArray(items) || items.length === 0) {
                    listEl.classList.add('d-none');
                    emptyEl.classList.remove('d-none');
                    return;
                }

                emptyEl.classList.add('d-none');
                listEl.classList.remove('d-none');

                items.forEach(function (item) {
                    if (!item || typeof item.id === 'undefined') {
                        return;
                    }
                    const docId = Number(item.id);
                    documentsMap.set(docId, item);

                    const listItem = document.createElement('li');
                    listItem.className = 'list-group-item list-group-item-action d-flex justify-content-between align-items-start';
                    listItem.setAttribute('role', 'button');
                    listItem.setAttribute('tabindex', '0');
                    listItem.dataset.documentId = String(docId);

                    const textWrapper = document.createElement('div');
                    textWrapper.className = 'me-3';

                    const titleEl = document.createElement('div');
                    titleEl.className = 'fw-semibold';
                    titleEl.textContent = item.title || 'Dokumen';
                    textWrapper.appendChild(titleEl);

                    const description = (item.description || '').toString().trim();
                    if (description !== '') {
                        const descriptionEl = document.createElement('div');
                        descriptionEl.className = 'text-muted small';
                        descriptionEl.textContent = description;
                        textWrapper.appendChild(descriptionEl);
                    }

                    const metaParts = [];
                    if (item.original_filename) {
                        metaParts.push(item.original_filename);
                    }
                    if (item.file_size) {
                        metaParts.push(formatBytes(Number(item.file_size)));
                    }
                    const timestamp = item.updated_at || item.created_at;
                    const formattedDate = formatDateTime(timestamp);
                    if (formattedDate) {
                        metaParts.push(formattedDate);
                    }

                    if (metaParts.length) {
                        const metaEl = document.createElement('div');
                        metaEl.className = 'text-muted small';
                        metaEl.textContent = metaParts.join(' • ');
                        textWrapper.appendChild(metaEl);
                    }

                    const actionBadge = document.createElement('span');
                    actionBadge.className = 'badge bg-primary rounded-pill align-self-center';
                    actionBadge.textContent = 'Buka';

                    listItem.appendChild(textWrapper);
                    listItem.appendChild(actionBadge);
                    listEl.appendChild(listItem);
                });
            }

            function enforceDialogHeight(dialogInstance) {
                if (!dialogInstance) {
                    return;
                }
                const modalDialog = dialogInstance.getModalDialog ? dialogInstance.getModalDialog() : null;
                const modalBody = dialogInstance.getModalBody ? dialogInstance.getModalBody() : null;

                if (modalDialog) {
                    if (typeof modalDialog.css === 'function') {
                        modalDialog.css('max-height', '80vh');
                    } else if (modalDialog[0]) {
                        modalDialog[0].style.maxHeight = '80vh';
                    }
                }

                if (modalBody) {
                    if (typeof modalBody.css === 'function') {
                        modalBody.css({
                            'max-height': 'calc(80vh - 130px)',
                            'overflow-y': 'auto'
                        });
                    } else if (modalBody[0]) {
                        modalBody[0].style.maxHeight = 'calc(80vh - 130px)';
                        modalBody[0].style.overflowY = 'auto';
                    }
                }
            }

            function openPreview(documentItem) {
                if (!documentItem) {
                    return;
                }

                const viewUrl = buildPemohonUrl(documentItem.view_url || '');
                if (!window.BootstrapDialog) {
                    window.open(viewUrl, '_blank', 'noopener');
                    return;
                }

                const wrapper = document.createElement('div');
                wrapper.className = 'ratio ratio-16x9';
                wrapper.style.minHeight = '400px';

                const frame = document.createElement('iframe');
                frame.src = viewUrl;
                frame.title = documentItem.title || 'Dokumen';
                frame.loading = 'lazy';
                frame.className = 'w-100 h-100 border-0';
                frame.setAttribute('referrerpolicy', 'no-referrer');

                wrapper.appendChild(frame);

                const dialog = new BootstrapDialog({
                    title: documentItem.title || 'Dokumen',
                    message: wrapper,
                    size: BootstrapDialog.SIZE_WIDE ? BootstrapDialog.SIZE_WIDE : (BootstrapDialog.SIZE_NORMAL || null),
                    autodestroy: true,
                    nl2br: false,
                    buttons: [
                        {
                            label: 'Tutup',
                            cssClass: 'btn btn-primary',
                            action: function (dialogRef) {
                                dialogRef.close();
                            }
                        }
                    ]
                });

                dialog.realize();
                enforceDialogHeight(dialog);
                dialog.open();
            }

            function openUploadDialog() {
                if (!templateEl || !(templateEl instanceof HTMLTemplateElement)) {
                    console.warn('Templat dialog dokumen tidak ditemui.');
                    return;
                }

                if (typeof BootstrapDialog === 'undefined') {
                    alert('Modul dialog tidak tersedia.');
                    return;
                }

                const content = templateEl.content ? templateEl.content.cloneNode(true) : null;
                const wrapper = document.createElement('div');
                if (content) {
                    wrapper.appendChild(content);
                }

                const formEl = wrapper.querySelector('form');
                const fileInput = wrapper.querySelector('input[type="file"]');
                const errorBox = wrapper.querySelector('[data-role="document-upload-error"]');
                const titleInput = wrapper.querySelector('input[name="title"]');

                if (!formEl || !fileInput) {
                    console.warn('Borang muat naik dokumen tidak lengkap.');
                    return;
                }

                let pondInstance = null;
                let submitting = false;

                const dialog = new BootstrapDialog({
                    title: 'Tambah Dokumen',
                    message: wrapper,
                    size: BootstrapDialog.SIZE_WIDE ? BootstrapDialog.SIZE_WIDE : (BootstrapDialog.SIZE_NORMAL || null),
                    autodestroy: true,
                    nl2br: false,
                    buttons: [
                        {
                            id: 'document-cancel',
                            label: 'Batal',
                            cssClass: 'btn btn-light',
                            action: function (dialogRef) {
                                dialogRef.close();
                            }
                        },
                        {
                            id: 'document-submit',
                            label: '<span class="submit-text">Muat Naik</span><span class="spinner-border spinner-border-sm ms-2 d-none" role="status" aria-hidden="true"></span>',
                            cssClass: 'btn btn-primary',
                            hotkey: 13,
                            action: function (dialogRef) {
                                submitDocument(dialogRef);
                            }
                        }
                    ],
                    onshown: function (dialogRef) {
                        enforceDialogHeight(dialogRef);
                        pondInstance = ensureFilePond();
                        if (titleInput) {
                            titleInput.focus({ preventScroll: true });
                        }
                    },
                    onhide: function () {
                        if (pondInstance && typeof pondInstance.destroy === 'function') {
                            pondInstance.destroy();
                        }
                        pondInstance = null;
                    }
                });

                dialog.realize();
                enforceDialogHeight(dialog);
                dialog.open();

                let submitBtn = dialog.getButton
                    ? dialog.getButton('document-submit')
                    : null;

                if (submitBtn && typeof submitBtn.length !== 'undefined' && submitBtn.length > 0 && submitBtn[0] instanceof HTMLElement) {
                    submitBtn = submitBtn[0];
                }

                const submitTextEl = submitBtn instanceof HTMLElement ? submitBtn.querySelector('.submit-text') : null;
                const submitSpinnerEl = submitBtn instanceof HTMLElement ? submitBtn.querySelector('.spinner-border') : null;

                function setSubmitLoading(state) {
                    if (!(submitBtn instanceof HTMLElement)) {
                        return;
                    }
                    submitBtn.disabled = state;
                    if (submitSpinnerEl) {
                        submitSpinnerEl.classList.toggle('d-none', !state);
                    }
                    if (submitTextEl) {
                        submitTextEl.textContent = state ? 'Memuat naik...' : 'Muat Naik';
                    }
                }

                function setError(message) {
                    if (errorBox) {
                        errorBox.classList.remove('alert', 'alert-danger');
                        errorBox.classList.add('d-none');
                        errorBox.textContent = '';
                        if (message) {
                            errorBox.textContent = message;
                            errorBox.classList.add('alert', 'alert-danger');
                            errorBox.classList.remove('d-none');
                        }
                    } else if (message) {
                        showAlert(message, 'danger');
                    }
                }

                function ensureFilePond() {
                    if (typeof FilePond === 'undefined') {
                        return null;
                    }
                    if (!window.__pemohonFilePondPluginsRegistered) {
                        const plugins = [];
                        if (typeof FilePondPluginFileValidateType !== 'undefined') {
                            plugins.push(FilePondPluginFileValidateType);
                        }
                        if (typeof FilePondPluginFileValidateSize !== 'undefined') {
                            plugins.push(FilePondPluginFileValidateSize);
                        }
                        if (plugins.length) {
                            FilePond.registerPlugin.apply(FilePond, plugins);
                        }
                        window.__pemohonFilePondPluginsRegistered = true;
                    }

                    const instance = FilePond.create(fileInput, {
                        allowMultiple: false,
                        allowRevert: false,
                        instantUpload: false,
                        credits: false,
                        acceptedFileTypes: ['application/pdf'],
                        labelFileTypeNotAllowed: 'Fail mesti dalam format PDF.',
                        fileValidateTypeLabelExpectedTypes: 'Fail mesti dalam format PDF.',
                        maxFileSize: '15MB',
                        fileValidateSizeLabelExceeded: 'Saiz fail melebihi 15MB.'
                    });

                    instance.on('addfile', function (error) {
                        if (error) {
                            setError(error.body || 'Fail tidak sah.');
                        } else {
                            setError('');
                        }
                    });

                    instance.on('removefile', function () {
                        setError('');
                    });

                    return instance;
                }

                async function submitDocument(dialogRef) {
                    if (submitting) {
                        return;
                    }

                    const tokenInput = formEl.querySelector('input[name="_token"]');
                    const descriptionInput = formEl.querySelector('textarea[name="description"]');

                    const titleValue = titleInput ? titleInput.value.trim() : '';
                    const descriptionValue = descriptionInput ? descriptionInput.value.trim() : '';

                    if (titleValue === '') {
                        setError('Sila masukkan tajuk dokumen.');
                        if (titleInput) {
                            titleInput.focus({ preventScroll: true });
                        }
                        return;
                    }

                    let fileObject = null;
                    if (pondInstance && typeof pondInstance.getFiles === 'function') {
                        const pondFiles = pondInstance.getFiles();
                        if (pondFiles && pondFiles[0] && pondFiles[0].file) {
                            fileObject = pondFiles[0].file;
                        }
                    }
                    if (!fileObject && fileInput && fileInput.files && fileInput.files[0]) {
                        fileObject = fileInput.files[0];
                    }

                    if (!fileObject) {
                        setError('Sila pilih fail PDF untuk dimuat naik.');
                        fileInput.focus();
                        return;
                    }

                    if (fileObject.type && fileObject.type.indexOf('pdf') === -1) {
                        setError('Fail mestilah dalam format PDF.');
                        fileInput.focus();
                        return;
                    }

                    if (fileObject.size > 15 * 1024 * 1024) {
                        setError('Saiz fail melebihi had maksimum 15MB.');
                        return;
                    }

                    const formData = new FormData();
                    if (tokenInput && tokenInput.value) {
                        formData.append('_token', tokenInput.value);
                    }
                    formData.append('title', titleValue);
                    if (descriptionValue !== '') {
                        formData.append('description', descriptionValue);
                    }
                    const uploadName = fileObject.name || 'dokumen.pdf';
                    formData.append('document', fileObject, uploadName);

                    setError('');
                    submitting = true;
                    setSubmitLoading(true);

                    try {
                        const response = await fetch(buildPemohonUrl('documents.php'), {
                            method: 'POST',
                            body: formData,
                            credentials: 'same-origin',
                            headers: {
                                'X-Requested-With': 'XMLHttpRequest'
                            }
                        });
                        const payload = await response.json().catch(function () {
                            return null;
                        });

                        if (!response.ok) {
                            const message = payload && payload.message ? payload.message : 'Gagal memuat naik dokumen.';
                            setError(message);
                            submitting = false;
                            setSubmitLoading(false);
                            return;
                        }

                        dialogRef.close();
                        showAlert('Dokumen berjaya dimuat naik.', 'success');
                        loadDocuments();
                    } catch (error) {
                        console.error('Ralat muat naik dokumen:', error);
                        setError('Ralat tidak dijangka semasa memuat naik. Sila cuba lagi.');
                    } finally {
                        submitting = false;
                        setSubmitLoading(false);
                    }
                }
            }

            async function loadDocuments() {
                setLoading(true);
                try {
                    const response = await fetch(buildPemohonUrl('documents.php'), {
                        method: 'GET',
                        credentials: 'same-origin',
                        headers: {
                            'Accept': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    });

                    if (!response.ok) {
                        throw new Error('Dokumen tidak berjaya dimuatkan.');
                    }

                    const payload = await response.json();
                    renderDocuments(payload && Array.isArray(payload.items) ? payload.items : []);
                } catch (error) {
                    console.error('Gagal memuatkan senarai dokumen:', error);
                    showAlert('Gagal memuatkan Senarai Dokumen. Sila cuba lagi.', 'danger');
                    clearList();
                } finally {
                    setLoading(false);
                }
            }

            if (addButton) {
                addButton.addEventListener('click', function (event) {
                    event.preventDefault();
                    openUploadDialog();
                });
            }

            listEl.addEventListener('click', function (event) {
                const target = event.target.closest('[data-document-id]');
                if (!target) {
                    return;
                }
                const docId = Number(target.getAttribute('data-document-id'));
                if (!docId) {
                    return;
                }
                const documentItem = documentsMap.get(docId);
                if (documentItem) {
                    openPreview(documentItem);
                }
            });

            listEl.addEventListener('keydown', function (event) {
                if (event.key !== 'Enter' && event.key !== ' ') {
                    return;
                }
                const target = event.target.closest('[data-document-id]');
                if (!target) {
                    return;
                }
                event.preventDefault();
                const docId = Number(target.getAttribute('data-document-id'));
                const documentItem = documentsMap.get(docId);
                if (documentItem) {
                    openPreview(documentItem);
                }
            });

            loadDocuments();
        }());
    </script>
    <script>
        (function () {
            const card = document.getElementById('biography-card');
            if (!card) {
                return;
            }

            const contentEl = card.querySelector('[data-role="biography-content"]');
            const editBtn = card.querySelector('[data-role="biography-edit"]');
            const templateEl = document.getElementById('biography-modal-template');

            if (!contentEl || !editBtn || !templateEl) {
                return;
            }

            function buildPemohonUrl(path) {
                const normalizedPath = (path || '').toString().replace(/^\/+/, '');
                const parts = window.location.pathname.split('/pemohon/');
                if (parts.length > 1) {
                    const prefix = parts[0];
                    const basePrefix = prefix ? prefix.replace(/\/?$/, '/') : '/';
                    return (basePrefix + 'pemohon/' + normalizedPath).replace(/\/{2,}/g, '/');
                }
                return '/pemohon/' + normalizedPath;
            }

            function escapeHtml(value) {
                const div = document.createElement('div');
                div.textContent = value;
                return div.innerHTML;
            }

            function renderBiography(text) {
                const trimmed = (text || '').trim();
                if (trimmed === '') {
                    contentEl.innerHTML = '<p class="text-muted mb-0">Tiada maklumat biografi disediakan.</p>';
                    return;
                }
                const safe = escapeHtml(trimmed).replace(/\r?\n/g, '<br>');
                contentEl.innerHTML = '<p>' + safe + '</p>';
            }

            function openBiographyModal() {
                if (typeof BootstrapDialog === 'undefined') {
                    alert('Modul dialog tidak tersedia.');
                    return;
                }

                const fragment = templateEl.content ? templateEl.content.cloneNode(true) : null;
                const wrapper = document.createElement('div');
                if (fragment) {
                    wrapper.appendChild(fragment);
                } else {
                    wrapper.innerHTML = templateEl.innerHTML;
                }

                const form = wrapper.querySelector('#biography-form');
                const textarea = wrapper.querySelector('#biography-input');
                const feedbackEl = wrapper.querySelector('[data-role="biography-feedback"]');

                let saveButtonDom = null;
                let saveSpinnerEl = null;
                let saveTextEl = null;
                let isSaving = false;

                function setFeedback(message, type) {
                    if (!feedbackEl) {
                        return;
                    }
                    feedbackEl.classList.add('d-none');
                    feedbackEl.classList.remove('alert-success', 'alert-danger', 'alert-info');
                    if (!message) {
                        feedbackEl.textContent = '';
                        return;
                    }
                    feedbackEl.textContent = message;
                    feedbackEl.classList.add('alert', 'alert-' + (type || 'info'));
                    feedbackEl.classList.remove('d-none');
                }

                function setSaving(state) {
                    if (!saveButtonDom) {
                        return;
                    }
                    saveButtonDom.disabled = state;
                    if (saveSpinnerEl) {
                        saveSpinnerEl.classList.toggle('d-none', !state);
                    }
                    if (saveTextEl) {
                        saveTextEl.textContent = state ? 'Menyimpan...' : 'Simpan';
                    }
                }

                function loadBiography() {
                    setFeedback('Sedang memuatkan biografi...', 'info');
                    fetch(buildPemohonUrl('biography.php'), {
                        method: 'GET',
                        credentials: 'same-origin',
                        headers: {
                            'Accept': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    }).then(function (response) {
                        if (!response.ok) {
                            throw new Error('Gagal memuatkan biografi.');
                        }
                        return response.json();
                    }).then(function (data) {
                        if (textarea) {
                            textarea.value = data && typeof data.biography === 'string' ? data.biography : '';
                        }
                        setFeedback('', '');
                    }).catch(function (error) {
                        console.error('Gagal memuatkan biografi:', error);
                        setFeedback('Gagal memuatkan biografi. Sila cuba lagi.', 'danger');
                    });
                }

                function submitBiography(dialogRef) {
                    if (!form || !textarea) {
                        return;
                    }
                    if (isSaving) {
                        return;
                    }

                    const tokenInput = form.querySelector('input[name="_token"]');
                    if (!tokenInput || !tokenInput.value) {
                        setFeedback('Token keselamatan tidak sah. Sila muat semula halaman.', 'danger');
                        return;
                    }

                    const formData = new FormData(form);
                    formData.set('biography', textarea.value.trim());

                    isSaving = true;
                    setSaving(true);
                    setFeedback('', '');

                    fetch(buildPemohonUrl('biography.php'), {
                        method: 'POST',
                        body: formData,
                        credentials: 'same-origin',
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    }).then(function (response) {
                        return response.json().then(function (payload) {
                            return {response: response, payload: payload};
                        }).catch(function () {
                            return {response: response, payload: {}};
                        });
                    }).then(function (result) {
                        const response = result.response;
                        const payload = result.payload || {};
                        if (!response.ok) {
                            const message = payload.message || 'Gagal menyimpan biografi.';
                            setFeedback(message, 'danger');
                            return;
                        }

                        renderBiography(payload.biography || '');
                        setFeedback(payload.message || 'Biografi berjaya dikemaskini.', 'success');
                        setTimeout(function () {
                            dialogRef.close();
                        }, 600);
                    }).catch(function (error) {
                        console.error('Gagal menyimpan biografi:', error);
                        setFeedback('Ralat tidak dijangka berlaku. Sila cuba lagi.', 'danger');
                    }).finally(function () {
                        isSaving = false;
                        setSaving(false);
                    });
                }

                const dialog = new BootstrapDialog({
                    title: 'Kemaskini Biografi',
                    message: wrapper,
                    size: BootstrapDialog.SIZE_WIDE ? BootstrapDialog.SIZE_WIDE : (BootstrapDialog.SIZE_NORMAL || null),
                    autodestroy: true,
                    nl2br: false,
                    buttons: [
                        {
                            label: 'Tutup',
                            cssClass: 'btn btn-light',
                            action: function (dialogRef) {
                                dialogRef.close();
                            }
                        },
                        {
                            id: 'biography-save-button',
                            label: '<span class="save-text">Simpan</span><span class="spinner-border spinner-border-sm ms-2 d-none" role="status" aria-hidden="true"></span>',
                            cssClass: 'btn btn-primary',
                            hotkey: 13,
                            action: function (dialogRef) {
                                submitBiography(dialogRef);
                            }
                        }
                    ],
                    onshown: function () {
                        loadBiography();
                        const firstInput = textarea;
                        if (firstInput && typeof firstInput.focus === 'function') {
                            firstInput.focus({preventScroll: true});
                        }
                    }
                });

                dialog.realize();

                const saveBtn = dialog.getButton('biography-save-button');
                if (saveBtn) {
                    if (saveBtn.length && saveBtn[0]) {
                        saveButtonDom = saveBtn[0];
                    } else if (saveBtn instanceof HTMLElement) {
                        saveButtonDom = saveBtn;
                    }
                }
                saveTextEl = saveButtonDom ? saveButtonDom.querySelector('.save-text') : null;
                saveSpinnerEl = saveButtonDom ? saveButtonDom.querySelector('.spinner-border') : null;

                dialog.open();
            }

            editBtn.addEventListener('click', function (event) {
                event.preventDefault();
                openBiographyModal();
            });
        }());
    </script>
    <script>
        (function () {
            const modalId = 'updateProfileModal';
            let modalInstance = null;
            const SKIN_COOKIE_NAME = 'skin_pemohon';
            const SKIN_COOKIE_PATH = '/pemohon';

            function setCookie(name, value, days, path) {
                let expires = '';
                if (typeof days === 'number') {
                    const date = new Date();
                    date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
                    expires = '; expires=' + date.toUTCString();
                }
                const cookiePath = '; path=' + (path || '/');
                document.cookie = name + '=' + encodeURIComponent(value || '') + expires + cookiePath;
            }

            function getCookie(name) {
                const nameEQ = name + '=';
                const parts = document.cookie ? document.cookie.split(';') : [];
                for (let i = 0; i < parts.length; i += 1) {
                    let part = parts[i];
                    while (part.charAt(0) === ' ') {
                        part = part.substring(1);
                    }
                    if (part.indexOf(nameEQ) === 0) {
                        return decodeURIComponent(part.substring(nameEQ.length));
                    }
                }
                return null;
            }

            function pemohonStoreSkin(value) {
                if (value) {
                    setCookie(SKIN_COOKIE_NAME, value, 365, SKIN_COOKIE_PATH);
                } else {
                    setCookie(SKIN_COOKIE_NAME, '', -1, SKIN_COOKIE_PATH);
                }
                try {
                    if (value) {
                        localStorage.setItem('skin_pemohon', value);
                    } else {
                        localStorage.removeItem('skin_pemohon');
                    }
                } catch (error) {
                    // ignore storage issues
                }
            }

            const SKIN_CLASSES = [
                'skin-default',
                'skin-green',
                'skin-red',
                'skin-blue',
                'skin-purple',
                'skin-megna',
                'skin-default-dark',
                'skin-green-dark',
                'skin-red-dark',
                'skin-blue-dark',
                'skin-purple-dark',
                'skin-megna-dark'
            ];

            function parseColor(value) {
                if (!value) {
                    return null;
                }
                if (value.startsWith('#')) {
                    const hex = value.replace('#', '');
                    if (hex.length === 3) {
                        return [
                            parseInt(hex[0] + hex[0], 16),
                            parseInt(hex[1] + hex[1], 16),
                            parseInt(hex[2] + hex[2], 16),
                        ];
                    }
                    if (hex.length === 6) {
                        return [
                            parseInt(hex.substring(0, 2), 16),
                            parseInt(hex.substring(2, 4), 16),
                            parseInt(hex.substring(4, 6), 16),
                        ];
                    }
                }
                const match = value.match(/rgba?\((\d+),\s*(\d+),\s*(\d+)/i);
                if (match) {
                    return [
                        parseInt(match[1], 10),
                        parseInt(match[2], 10),
                        parseInt(match[3], 10),
                    ];
                }
                return null;
            }

            function isTransparent(value) {
                return !value || value === 'transparent' || value === 'rgba(0, 0, 0, 0)';
            }

            function computeThemeColors() {
                const nav = document.querySelector('.topbar .navbar') || document.querySelector('.topbar');
                let background = '#ed4040';
                let textColor = '#ffffff';

                if (nav) {
                    const styles = window.getComputedStyle(nav);
                    const navBg = styles.backgroundColor;
                    if (!isTransparent(navBg)) {
                        background = navBg;
                    }
                    const navColor = styles.color;
                    if (navColor && navColor !== '') {
                        textColor = navColor;
                    }
                }

                const rgb = parseColor(background);
                if (rgb) {
                    const brightness = (0.299 * rgb[0]) + (0.587 * rgb[1]) + (0.114 * rgb[2]);
                    textColor = brightness > 160 ? '#212529' : '#ffffff';
                }

                return { background, textColor };
            }

            function updateModalHeaderTheme(modalEl) {
                if (!modalEl) {
                    return;
                }
                const header = modalEl.querySelector('.modal-header');
                if (!header) {
                    return;
                }
                const { background, textColor } = computeThemeColors();
                header.style.backgroundColor = background;
                header.style.color = textColor;
                const title = header.querySelector('.modal-title');
                if (title) {
                    title.style.color = textColor;
                }
                header.querySelectorAll('.btn-close').forEach(function (button) {
                    if (!button) {
                        return;
                    }
                    const rgb = parseColor(background);
                    if (rgb) {
                        const brightness = (0.299 * rgb[0]) + (0.587 * rgb[1]) + (0.114 * rgb[2]);
                        if (brightness > 160) {
                            button.classList.remove('btn-close-white');
                            button.style.filter = '';
                        } else {
                            button.classList.add('btn-close-white');
                        }
                    } else {
                        button.classList.add('btn-close-white');
                    }
                });
            }

            function updateAllVisibleModalHeaders() {
                document.querySelectorAll('.modal.show').forEach(function (modal) {
                    updateModalHeaderTheme(modal);
                });
            }

            function applySkinClass(skin) {
                if (!skin || SKIN_CLASSES.indexOf(skin) === -1) {
                    return;
                }
                const body = document.body;
                if (!body) {
                    return;
                }
                SKIN_CLASSES.forEach(function (cls) {
                    body.classList.remove(cls);
                });
                body.classList.add(skin);
                pemohonStoreSkin(skin);
            }

            function syncSkinFromStorage() {
                const storedCookie = getCookie(SKIN_COOKIE_NAME);
                if (storedCookie) {
                    applySkinClass(storedCookie);
                    return;
                }
                try {
                    const stored = localStorage.getItem('skin_pemohon');
                    if (stored) {
                        applySkinClass(stored);
                    }
                } catch (error) {
                    // ignore storage access issues
                }
            }

            function buildLoadingMarkup() {
                const colors = computeThemeColors();
                return '<div class="d-flex justify-content-center align-items-center" style="min-height:200px;">'
                    + '<div class="spinner-border" role="status" style="color:' + colors.background + ';">'
                    + '<span class="visually-hidden">Memuatkan...</span>'
                    + '</div>'
                    + '</div>';
            }

            syncSkinFromStorage();
            updateAllVisibleModalHeaders();

            document.addEventListener('click', function (event) {
                const trigger = event.target.closest('[data-skin]');
                if (!trigger) {
                    return;
                }
                const skin = trigger.getAttribute('data-skin');
                if (skin) {
                    applySkinClass(skin);
                    updateAllVisibleModalHeaders();
                }
                setTimeout(function () {
                    syncSkinFromStorage();
                    updateAllVisibleModalHeaders();
                }, 0);
            }, true);

            window.addEventListener('storage', function (event) {
                if (event.key === 'skin_pemohon') {
                    syncSkinFromStorage();
                    updateAllVisibleModalHeaders();
                }
            });

            document.addEventListener('show.bs.modal', function (event) {
                updateModalHeaderTheme(event.target);
            });

            document.addEventListener('shown.bs.modal', function (event) {
                updateModalHeaderTheme(event.target);
            });

            function ensureModalElement() {
                let modalEl = document.getElementById(modalId);
                if (modalEl) {
                    updateModalHeaderTheme(modalEl);
                    return modalEl;
                }

                modalEl = document.createElement('div');
                modalEl.className = 'modal fade';
                modalEl.id = modalId;
                modalEl.tabIndex = -1;
                modalEl.setAttribute('aria-labelledby', 'updateProfileModalLabel');
                modalEl.setAttribute('aria-hidden', 'true');
                modalEl.innerHTML = [
                    '<div class="modal-dialog modal-lg modal-dialog-scrollable" style="max-height:80vh;">',
                    '  <div class="modal-content" style="max-height:80vh; display:flex; flex-direction:column;">',
                    '    <div class="modal-header">',
                    '      <h5 class="modal-title" id="updateProfileModalLabel">Kemaskini Profil</h5>',
                    '      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>',
                    '    </div>',
                    '    <div class="modal-body flex-grow-1 overflow-auto"></div>',
                    '    <div class="modal-footer d-flex justify-content-end gap-2">',
                    '      <button type="button" class="btn btn-light border" data-bs-dismiss="modal">Tutup</button>',
                    '    </div>',
                    '  </div>',
                    '</div>',
                ].join('');

                updateModalHeaderTheme(modalEl);
                modalEl.addEventListener('hidden.bs.modal', function () {
                    const body = modalEl.querySelector('.modal-body');
                    if (body) {
                        body.innerHTML = '';
                    }
                    const footer = modalEl.querySelector('.modal-footer');
                    if (footer) {
                        footer.innerHTML = '<button type="button" class="btn btn-light border" data-bs-dismiss="modal">Tutup</button>';
                    }
                    if (modalEl.dataset.reloadOnClose === '1') {
                        delete modalEl.dataset.reloadOnClose;
                        window.location.reload();
                    }
                });

                modalEl.addEventListener('submit', function (event) {
                    if (event.target && event.target.id === 'updateProfileForm') {
                        event.preventDefault();
                        submitProfileForm(event.target);
                    }
                });

                document.body.appendChild(modalEl);
                updateModalHeaderTheme(modalEl);
                return modalEl;
            }

            function setModalSections(bodyHtml, footerHtml) {
                const modalEl = ensureModalElement();
                const body = modalEl.querySelector('.modal-body');
                const footer = modalEl.querySelector('.modal-footer');

                if (body) {
                    body.innerHTML = bodyHtml || '';
                }

                if (footer && typeof footerHtml !== 'undefined') {
                    footer.innerHTML = footerHtml;
                }

                updateModalHeaderTheme(modalEl);
            }

            function applyModalContent(html) {
                const modalEl = ensureModalElement();
                const body = modalEl.querySelector('.modal-body');
                const footer = modalEl.querySelector('.modal-footer');

                if (!body || !footer) {
                    return;
                }

                const container = document.createElement('div');
                container.innerHTML = html || '';

                const footerContent = container.querySelector('[data-modal-footer]');
                if (footerContent) {
                    const fragment = document.createDocumentFragment();
                    Array.from(footerContent.childNodes).forEach(function (node) {
                        fragment.appendChild(node);
                    });
                    footer.innerHTML = '';
                    footer.appendChild(fragment);
                    footerContent.remove();
                } else {
                    footer.innerHTML = '<button type="button" class="btn btn-light border" data-bs-dismiss="modal">Tutup</button>';
                }

                const form = container.querySelector('form');
                body.innerHTML = '';
                if (form) {
                    body.appendChild(form);
                } else {
                    Array.from(container.childNodes).forEach(function (node) {
                        body.appendChild(node);
                    });
                }

                updateModalHeaderTheme(modalEl);
            }

            function toggleSubmitButton(disabled) {
                const modalEl = ensureModalElement();
                const button = modalEl.querySelector('[data-role="save-profile"]');
                if (button) {
                    button.disabled = disabled;
                }
            }

            function loadFormIntoModal() {
                setModalSections(
                    buildLoadingMarkup(),
                    '<button type="button" class="btn btn-light border" data-bs-dismiss="modal">Tutup</button>'
                );

                fetch('/pemohon/update-profile.php?modal=1', {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                    },
                    credentials: 'same-origin',
                })
                    .then(function (response) {
                        if (!response.ok) {
                            throw new Error('Gagal memuatkan borang.');
                        }
                        return response.text();
                    })
                    .then(function (html) {
                        applyModalContent(html);
                    })
                    .catch(function () {
                        setModalSections(
                            '<div class="alert alert-danger mb-0">Tidak dapat memuatkan borang kemaskini profil. Sila cuba lagi.</div>',
                            '<button type="button" class="btn btn-light border" data-bs-dismiss="modal">Tutup</button>'
                        );
                    });
            }

            function submitProfileForm(form) {
                const formData = new FormData(form);
                toggleSubmitButton(true);

                fetch('/pemohon/update-profile.php', {
                    method: 'POST',
                    body: formData,
                    credentials: 'same-origin',
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                    },
                })
                    .then(async function (response) {
                        const payload = await response.json().catch(function () {
                            return null;
                        });

                        if (!payload) {
                            throw new Error('Ralat tidak dijangka.');
                        }

                        if (!response.ok) {
                            if (payload.html) {
                                applyModalContent(payload.html);
                                return;
                            }
                            throw new Error(payload.message || 'Ralat tidak dijangka.');
                        }

                        setModalSections(
                            '<div class="alert alert-success mb-0">' + (payload.message || 'Profil berjaya dikemaskini.') + '</div>',
                            '<button type="button" class="btn btn-danger" data-bs-dismiss="modal">Tutup</button>'
                        );

                        const modalEl = ensureModalElement();
                        modalEl.dataset.reloadOnClose = '1';

                        setTimeout(function () {
                            if (modalInstance) {
                                modalInstance.hide();
                            }
                        }, 800);
                    })
                    .catch(function (error) {
                        setModalSections(
                            '<div class="alert alert-danger mb-0">' + (error.message || 'Ralat tidak dijangka berlaku.') + '</div>',
                            '<button type="button" class="btn btn-light border" data-bs-dismiss="modal">Tutup</button>'
                        );
                    })
                    .finally(function () {
                        toggleSubmitButton(false);
                    });
            }

            window.update_profile = function () {
                if (typeof bootstrap === 'undefined' || typeof bootstrap.Modal === 'undefined') {
                    alert('Komponen modal Bootstrap tidak tersedia.');
                    return;
                }

                const modalEl = ensureModalElement();
                modalInstance = new bootstrap.Modal(modalEl, {
                    backdrop: 'static',
                    keyboard: true,
                });
                loadFormIntoModal();
                modalInstance.show();
            };
        }());
    </script>
    <script>
        (function () {
            const basicInfoBtn = document.querySelector('[data-role="basic-info-edit"]');
            if (!basicInfoBtn) {
                return;
            }

            basicInfoBtn.addEventListener('click', function (event) {
                event.preventDefault();
                if (typeof window.update_profile === 'function') {
                    window.update_profile();
                } else {
                    console.warn('Fungsi kemaskini profil tidak tersedia.');
                }
            });
        }());
    </script>
    <script>
        (function () {
            const trigger = document.querySelector('[data-role="profile-photo-trigger"]');
            const modalEl = document.getElementById('profilePhotoModal');
            const form = document.getElementById('profile-photo-form');
            const fileInput = document.getElementById('profile-photo-input');
            const previewImg = document.getElementById('profile-photo-preview-image');
            const alertBox = document.getElementById('profile-photo-alert');
            const uploadBtn = document.getElementById('profile-photo-upload');

            if (!trigger || !modalEl || !form || !fileInput || !previewImg || !uploadBtn) {
                return;
            }

            if (typeof bootstrap === 'undefined' || typeof bootstrap.Modal === 'undefined') {
                console.warn('Bootstrap modal tidak tersedia. Muat naik foto tidak diaktifkan.');
                return;
            }

            const uploadText = uploadBtn.querySelector('.upload-text');
            const uploadSpinner = uploadBtn.querySelector('.upload-spinner');
            let defaultPreviewSrc = previewImg.getAttribute('src');
            const avatarNodes = document.querySelectorAll('[data-role="pemohon-avatar"]');
            const modalInstance = new bootstrap.Modal(modalEl, {backdrop: 'static', keyboard: true});
            const faceApiWeightsBaseUrl = <?php echo json_encode(pemohon_asset('assets/face-api')); ?>;
            const MAX_UPLOAD_DIMENSION = 640;
            const OUTPUT_QUALITY = 0.9;
            let pond = null;
            let currentFileId = null;
            let processedPreviewUrl = null;
            let filePondRegistered = Boolean(window.__pemohonFilePondPluginsRegistered || false);

            let selectedFile = null;
            let faceModelsPromise = null;
            let faceApiScriptPromise = null;

            function setAlert(message, type) {
                alertBox.classList.add('d-none');
                alertBox.classList.remove('alert-success', 'alert-danger', 'alert-warning', 'alert-info');
                if (!message) {
                    alertBox.textContent = '';
                    return;
                }
                alertBox.textContent = message;
                alertBox.classList.add('alert', 'alert-' + type);
                alertBox.classList.remove('d-none');
            }

            function toggleUploadLoading(isLoading) {
                uploadBtn.disabled = isLoading || !selectedFile;
                if (isLoading) {
                    uploadSpinner.classList.remove('d-none');
                    uploadText.textContent = 'Sedang Muat Naik...';
                } else {
                    uploadSpinner.classList.add('d-none');
                    uploadText.textContent = 'Muat Naik';
                }
            }

            function formatBytes(bytes) {
                if (!bytes || Number.isNaN(bytes)) {
                    return '0 B';
                }
                const units = ['B', 'KB', 'MB', 'GB'];
                let size = bytes;
                let unitIndex = 0;
                while (size >= 1024 && unitIndex < units.length - 1) {
                    size /= 1024;
                    unitIndex += 1;
                }
                return size.toFixed(unitIndex === 0 ? 0 : 1) + ' ' + units[unitIndex];
            }

            function revokeObjectUrl(urlRef) {
                if (urlRef) {
                    URL.revokeObjectURL(urlRef);
                }
            }

            function normalizeFileName(originalName) {
                if (!originalName || typeof originalName !== 'string') {
                    return 'profile-photo';
                }
                const base = originalName.replace(/\.[^.]+$/, '');
                const safe = base.replace(/[^a-zA-Z0-9_-]/g, '_').slice(0, 40);
                return safe || 'profile-photo';
            }

            function buildPemohonUrl(path) {
                const normalizedPath = (path || '').toString().replace(/^\/+/, '');
                const parts = window.location.pathname.split('/pemohon/');
                if (parts.length > 1) {
                    const prefix = parts[0];
                    const basePrefix = prefix ? prefix.replace(/\/?$/, '/') : '/';
                    return (basePrefix + 'pemohon/' + normalizedPath).replace(/\/{2,}/g, '/');
                }
                return '/pemohon/' + normalizedPath;
            }

            function loadImage(url) {
                return new Promise(function (resolve, reject) {
                    const image = new Image();
                    image.onload = function () {
                        resolve(image);
                    };
                    image.onerror = function () {
                        reject(new Error('Tidak dapat memuatkan imej.'));
                    };
                    image.src = url;
                });
            }

            async function createOptimizedFileFromImage(image, originalName) {
                const naturalWidth = image.naturalWidth || image.width;
                const naturalHeight = image.naturalHeight || image.height;
                if (!naturalWidth || !naturalHeight) {
                    throw new Error('Dimensi foto tidak sah.');
                }

                const scale = Math.min(1, MAX_UPLOAD_DIMENSION / Math.max(naturalWidth, naturalHeight));
                const targetWidth = Math.max(1, Math.round(naturalWidth * scale));
                const targetHeight = Math.max(1, Math.round(naturalHeight * scale));

                const canvas = document.createElement('canvas');
                canvas.width = targetWidth;
                canvas.height = targetHeight;
                const context = canvas.getContext('2d');
                if (!context) {
                    throw new Error('Pelayar tidak menyokong pemprosesan imej.');
                }

                context.drawImage(image, 0, 0, targetWidth, targetHeight);

                const blob = await new Promise(function (resolve, reject) {
                    canvas.toBlob(function (result) {
                        if (!result) {
                            reject(new Error('Gagal memproses foto.'));
                            return;
                        }
                        resolve(result);
                    }, 'image/jpeg', OUTPUT_QUALITY);
                });

                const fileName = normalizeFileName(originalName) + '.jpg';
                return new File([blob], fileName, {type: 'image/jpeg'});
            }

            function resetModalState() {
                selectedFile = null;
                revokeObjectUrl(processedPreviewUrl);
                processedPreviewUrl = null;
                if (pond) {
                    pond.removeFiles();
                }
                form.reset();
                previewImg.src = defaultPreviewSrc;
                setAlert('', '');
                toggleUploadLoading(false);
            }

            function focusTrigger() {
                trigger.focus({preventScroll: true});
            }

            function ensureFaceApiScript() {
                if (typeof faceapi !== 'undefined') {
                    return Promise.resolve(true);
                }
                if (!faceApiScriptPromise) {
                    faceApiScriptPromise = new Promise(function (resolve, reject) {
                        const script = document.createElement('script');
                        script.src = 'https://cdn.jsdelivr.net/npm/face-api.js@0.22.2/dist/face-api.min.js';
                        script.async = true;
                        script.onload = function () {
                            resolve(typeof faceapi !== 'undefined');
                        };
                        script.onerror = function (error) {
                            console.warn('Gagal memuatkan face-api.js', error);
                            reject(error);
                        };
                        document.head.appendChild(script);
                    }).catch(function () {
                        return false;
                    });
                }
                return faceApiScriptPromise;
            }

            async function ensureFaceModels() {
                const scriptLoaded = await ensureFaceApiScript();
                if (!scriptLoaded || typeof faceapi === 'undefined') {
                    return false;
                }
                if (!faceModelsPromise) {
                    const modelUrl = faceApiWeightsBaseUrl;
                    faceModelsPromise = Promise.all([
                        faceapi.nets.tinyFaceDetector.loadFromUri(modelUrl)
                    ]).then(function () {
                        return true;
                    }).catch(function (error) {
                        console.warn('Gagal memuatkan model pengesanan wajah:', error);
                        return false;
                    });
                }
                return faceModelsPromise;
            }

            function showModal() {
                initFilePond();
                resetModalState();
                modalInstance.show();
            }

            trigger.addEventListener('click', showModal);
            trigger.addEventListener('keydown', function (event) {
                if (event.key === 'Enter' || event.key === ' ') {
                    event.preventDefault();
                    showModal();
                }
            });

            modalEl.addEventListener('hidden.bs.modal', function () {
                resetModalState();
                focusTrigger();
            });

            initFilePond();

            function handleFileAdded(error, file) {
                if (error) {
                    console.error('FilePond addfile error:', error);
                    setAlert('Tidak dapat memuatkan foto. Sila cuba lagi.', 'danger');
                    selectedFile = null;
                    uploadBtn.disabled = true;
                    toggleUploadLoading(false);
                    return;
                }

                if (!file) {
                    return;
                }

                currentFileId = file.id;
                selectedFile = null;
                uploadBtn.disabled = true;
                toggleUploadLoading(true);
                setAlert('Memproses dan mengesahkan foto...', 'info');

                const sourceFile = file.file;
                if (!(sourceFile instanceof Blob)) {
                    console.error('Sumber foto tidak sah.');
                    setAlert('Fail foto tidak sah. Sila cuba lagi.', 'danger');
                    toggleUploadLoading(false);
                    return;
                }

                let sourceUrl = null;

                (async function processFile() {
                    try {
                        sourceUrl = URL.createObjectURL(sourceFile);
                        const detectionImage = await loadImage(sourceUrl);
                        const modelsAvailable = await ensureFaceModels();
                        let detectionPassed = true;

                        if (modelsAvailable) {
                            try {
                                const detection = await faceapi.detectSingleFace(
                                    detectionImage,
                                    new faceapi.TinyFaceDetectorOptions({inputSize: 224, scoreThreshold: 0.5})
                                );

                                if (!detection) {
                                    detectionPassed = false;
                                    setAlert('Tiada wajah dikesan pada foto ini. Sila pilih foto lain.', 'warning');
                                    uploadBtn.disabled = true;
                                    revokeObjectUrl(processedPreviewUrl);
                                    processedPreviewUrl = null;
                                    previewImg.src = defaultPreviewSrc;
                                } else {
                                    setAlert('Wajah dikesan. Anda boleh meneruskan muat naik.', 'success');
                                }
                            } catch (detectError) {
                                console.warn('Ralat pengesanan wajah:', detectError);
                                setAlert('Tidak dapat mengesahkan wajah. Foto akan disahkan di pelayan.', 'warning');
                            }
                        } else {
                            setAlert('Foto akan disahkan di pelayan.', 'warning');
                        }

                        if (!detectionPassed || currentFileId !== file.id) {
                            selectedFile = null;
                            return;
                        }

                        const optimizedFile = await createOptimizedFileFromImage(detectionImage, file.filename);
                        const optimizedUrl = URL.createObjectURL(optimizedFile);

                        revokeObjectUrl(processedPreviewUrl);
                        processedPreviewUrl = optimizedUrl;
                        previewImg.src = optimizedUrl;

                        selectedFile = optimizedFile;
                        uploadBtn.disabled = false;
                    } catch (processingError) {
                        if (currentFileId !== file.id) {
                            return;
                        }
                        console.warn('Ralat memproses foto:', processingError);
                        setAlert('Tidak dapat memproses foto. Sila cuba lagi.', 'danger');
                        selectedFile = null;
                        uploadBtn.disabled = true;
                        revokeObjectUrl(processedPreviewUrl);
                        processedPreviewUrl = null;
                        previewImg.src = defaultPreviewSrc;
                    } finally {
                        if (sourceUrl) {
                            URL.revokeObjectURL(sourceUrl);
                        }
                        if (currentFileId === file.id) {
                            toggleUploadLoading(false);
                        }
                    }
                }());
            }

            function handleFileRemoved() {
                currentFileId = null;
                selectedFile = null;
                revokeObjectUrl(processedPreviewUrl);
                processedPreviewUrl = null;
                previewImg.src = defaultPreviewSrc;
                uploadBtn.disabled = true;
                setAlert('', '');
                toggleUploadLoading(false);
            }

            function initFilePond() {
                if (typeof FilePond === 'undefined') {
                    console.warn('FilePond tidak tersedia.');
                    return null;
                }

                if (!filePondRegistered) {
                    const plugins = [];
                    if (typeof FilePondPluginFileValidateType !== 'undefined') {
                        plugins.push(FilePondPluginFileValidateType);
                    }
                    if (typeof FilePondPluginFileValidateSize !== 'undefined') {
                        plugins.push(FilePondPluginFileValidateSize);
                    }
                    if (typeof FilePondPluginImagePreview !== 'undefined') {
                        plugins.push(FilePondPluginImagePreview);
                    }
                    if (typeof FilePondPluginImageResize !== 'undefined') {
                        plugins.push(FilePondPluginImageResize);
                    }
                    if (typeof FilePondPluginImageTransform !== 'undefined') {
                        plugins.push(FilePondPluginImageTransform);
                    }

                    if (plugins.length) {
                        FilePond.registerPlugin.apply(FilePond, plugins);
                    }
                    filePondRegistered = true;
                    window.__pemohonFilePondPluginsRegistered = true;
                }

                if (pond) {
                    return pond;
                }

                pond = FilePond.create(fileInput, {
                    allowMultiple: false,
                    instantUpload: false,
                    credits: false,
                    stylePanelLayout: 'compact',
                    imagePreviewHeight: 200,
                    acceptedFileTypes: ['image/jpeg', 'image/png'],
                    maxFileSize: '5MB',
                    imageResizeTargetWidth: MAX_UPLOAD_DIMENSION,
                    imageResizeMode: 'contain',
                    imageResizeUpscale: false,
                    imageTransformOutputMimeType: 'image/jpeg',
                    imageTransformOutputMimeTypeFallback: 'image/jpeg',
                    imageTransformOutputQuality: OUTPUT_QUALITY,
                    imageTransformOutputQualityMode: 'always',
                });

                pond.on('addfile', handleFileAdded);
                pond.on('removefile', handleFileRemoved);

                return pond;
            }

            uploadBtn.addEventListener('click', async function () {
                if (!selectedFile) {
                    return;
                }

                toggleUploadLoading(true);
                setAlert('', '');

                const formData = new FormData();
                const tokenInput = form.querySelector('input[name="_token"]');
                if (tokenInput) {
                    formData.append('_token', tokenInput.value);
                }
                formData.append('photo', selectedFile);

                try {
                    const response = await fetch(buildPemohonUrl('upload-profile-photo.php'), {
                        method: 'POST',
                        body: formData,
                        credentials: 'same-origin',
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    });

                    const payload = await response.json();
                    if (!response.ok) {
                        const message = payload && payload.message ? payload.message : 'Gagal memuat naik foto.';
                        setAlert(message, 'danger');
                        toggleUploadLoading(false);
                        return;
                    }

                    const newUrl = payload.photoUrl;
                    const storedSize = payload && payload.storedBytes ? payload.storedBytes : 0;
                    const messageParts = ['Foto berjaya dikemaskini!'];
                    if (storedSize > 0) {
                        messageParts.push('Saiz disimpan: ' + formatBytes(storedSize));
                    }
                    setAlert(messageParts.join(' '), 'success');
                    selectedFile = null;
                    uploadBtn.disabled = true;
                    revokeObjectUrl(processedPreviewUrl);
                    processedPreviewUrl = null;
                    if (pond) {
                        pond.removeFiles();
                    }
                    defaultPreviewSrc = newUrl;
                    previewImg.src = newUrl;

                    avatarNodes.forEach(function (node) {
                        if (node instanceof HTMLImageElement) {
                            node.src = newUrl;
                        }
                    });

                    setTimeout(function () {
                        modalInstance.hide();
                    }, 800);
                } catch (error) {
                    console.error('Upload gagal:', error);
                    setAlert('Ralat tidak dijangka semasa memuat naik foto. Sila cuba lagi.', 'danger');
                    toggleUploadLoading(false);
                } finally {
                    toggleUploadLoading(false);
                }
            });
        }());
    </script>
    <?php
    if (!empty($pageInlineScripts ?? '')) {
        echo $pageInlineScripts;
    }
    ?>
    <script>
        $(document).ready(function() {
            $('.datatable').DataTable();
        });
    </script>
</body>

</html>









