<?php

declare(strict_types=1);

if (!function_exists('pemohon_asset')) {
    require_once __DIR__ . '/includes/helpers.php';
}

pemohon_start_session();

$pageTitle = $pageTitle ?? 'Portal Pemohon eTauliah';
$currentUser = $currentUser ?? ($_SESSION['pemohon_user'] ?? null);
$currentUserName = $currentUser['name'] ?? 'Pemohon';
$currentUserEmail = $currentUser['email'] ?? '';
$defaultAvatar = pemohon_asset('assets/images/users/1.jpg');

if (!isset($avatarUrl) || !is_string($avatarUrl) || $avatarUrl === '') {
    $avatarUrl = pemohon_resolve_avatar_url($currentUser, $defaultAvatar);
}

$topAvatarUrl = $avatarUrl ?: $defaultAvatar;
$brandLogo = pemohon_asset('assets/images/jabatan-mufti-negeri-melaka-logo-05x.png');
$favicon = pemohon_asset('assets/images/favicon.png');
$styleSheet = pemohon_asset('dist/css/style.min.css');

?>
<!DOCTYPE html>
<html lang="ms">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="Portal Pemohon eTauliah Melaka">
    <meta name="author" content="Jabatan Mufti Negeri Melaka">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo htmlspecialchars($favicon, ENT_QUOTES, 'UTF-8'); ?>">
    <title><?php echo htmlspecialchars($pageTitle, ENT_QUOTES, 'UTF-8'); ?></title>
    <link href="<?php echo htmlspecialchars($styleSheet, ENT_QUOTES, 'UTF-8'); ?>" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="<?php echo htmlspecialchars(pemohon_asset('assets/node_modules/datatables.net-bs4/css/dataTables.bootstrap4.min.css'), ENT_QUOTES, 'UTF-8'); ?>">
    <link rel="stylesheet" href="<?php echo htmlspecialchars(pemohon_asset('assets/bsd5/css/bootstrap-dialog.min.css'), ENT_QUOTES, 'UTF-8'); ?>">
    <link rel="stylesheet" href="https://unpkg.com/filepond@^4/dist/filepond.min.css">
    <link rel="stylesheet" href="https://unpkg.com/filepond-plugin-image-preview@^4/dist/filepond-plugin-image-preview.min.css">
    <style>
        img[data-role="pemohon-avatar"] {
            object-fit: cover;
        }
        .topbar img[data-role="pemohon-avatar"] {
            width: 40px;
            height: 40px;
        }
        .left-sidebar img[data-role="pemohon-avatar"] {
            width: 60px;
            height: 60px;
        }
    </style>
</head>

<body class="skin-red-dark fixed-layout">
    <div class="preloader">
        <div class="loader">
            <div class="loader__figure"></div>
            <p class="loader__label">Portal Pemohon eTauliah</p>
        </div>
    </div>

    <div id="main-wrapper">
        <header class="topbar">
            <nav class="navbar top-navbar navbar-expand-md navbar-dark">
                <div class="navbar-header">
                    <a class="navbar-brand" href="/pemohon/dashboard.php">
                        <b>
                            <img src="<?php echo htmlspecialchars($brandLogo, ENT_QUOTES, 'UTF-8'); ?>" alt="eTauliah" class="dark-logo" style="max-height: 50px;">
                        </b>
                    </a>
                </div>
                <div class="navbar-collapse">
                    <ul class="navbar-nav me-auto">
                        <li class="nav-item">
                            <a class="nav-link nav-toggler d-block d-md-none waves-effect waves-dark" href="javascript:void(0)">
                                <i class="ti-menu"></i>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link sidebartoggler d-none d-lg-block d-md-block waves-effect waves-dark" href="javascript:void(0)">
                                <i class="icon-menu"></i>
                            </a>
                        </li>
                        <li class="nav-item d-none d-md-block">
                            <form class="app-search">
                                <input type="text" class="form-control" placeholder="Cari & Enter">
                            </form>
                        </li>
                    </ul>
                    <ul class="navbar-nav ms-auto align-items-center">
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle waves-effect waves-dark" href="#" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <img src="<?php echo htmlspecialchars($topAvatarUrl, ENT_QUOTES, 'UTF-8'); ?>" alt="user" class="img-circle" width="40" data-role="pemohon-avatar">
                                <span class="ms-2 text-white"><?php echo htmlspecialchars($currentUserName, ENT_QUOTES, 'UTF-8'); ?></span>
                            </a>
                            <div class="dropdown-menu dropdown-menu-end">
                                <?php if ($currentUserEmail !== ''): ?>
                                    <div class="dropdown-item text-muted small"><?php echo htmlspecialchars($currentUserEmail, ENT_QUOTES, 'UTF-8'); ?></div>
                                    <div class="dropdown-divider"></div>
                                <?php endif; ?>
                                <a class="dropdown-item" href="/pemohon/profile.php">
                                    <i class="ti-user me-2"></i> Profil Saya
                                </a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="/pemohon/logout.php">
                                    <i class="fas fa-power-off me-2"></i> Log Keluar
                                </a>
                            </div>
                        </li>
                        <li class="nav-item right-side-toggle">
                            <a class="nav-link waves-effect waves-light" href="javascript:void(0)">
                                <i class="ti-settings"></i>
                            </a>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>
