<?php

declare(strict_types=1);

require_once __DIR__ . '/helpers.php';

function pemohon_db(): \mysqli
{
    static $connection;
    if ($connection instanceof \mysqli) {
        return $connection;
    }

    $config = pemohon_config('database');

    $connection = mysqli_init();
    $connection->options(MYSQLI_OPT_INT_AND_FLOAT_NATIVE, 1);

    if (!$connection->real_connect(
        $config['host'] ?? '127.0.0.1',
        $config['username'] ?? 'root',
        $config['password'] ?? '',
        $config['database'] ?? '',
        (int) ($config['port'] ?? 3306)
    )) {
        throw new \RuntimeException('Failed to connect to database: ' . $connection->connect_error);
    }

    $connection->set_charset($config['charset'] ?? 'utf8mb4');

    return $connection;
}
