<?php

declare(strict_types=1);

namespace App\Controllers;

use App\Core\Controller;
use App\Core\Request;
use App\Core\Response;
use App\Core\Session;

class DashboardController extends Controller
{
    public function __construct(Request $request, Response $response, Session $session)
    {
        parent::__construct($request, $response, $session);
    }

    public function index(): void
    {
        $user = $this->session->get('user');
        $stats = [
            'applications_total' => 1280,
            'applications_pending' => 125,
            'applications_approved' => 1024,
            'applications_rejected' => 131,
        ];

        $this->view('dashboard.admin', [
            'title' => 'Dashboard Pentadbir',
            'user' => $user,
            'stats' => $stats,
            'pageScripts' => $this->adminScripts(),
        ]);
    }

    public function applicant(): void
    {
        $user = $this->session->get('user');
        $applications = [
            ['number' => 'ETA-2025-0001', 'type' => 'Tauliah Agama', 'status' => 'Diluluskan', 'updated_at' => '2025-01-12'],
            ['number' => 'ETA-2025-0034', 'type' => 'Tauliah Al-Quran', 'status' => 'Dalam Proses', 'updated_at' => '2025-02-02'],
        ];

        $this->view('dashboard.applicant', [
            'title' => 'Dashboard Pemohon',
            'user' => $user,
            'applications' => $applications,
        ]);
    }

    private function adminScripts(): string
    {
        return <<<'SCRIPT'
<script>
    document.addEventListener('DOMContentLoaded', function () {
        if (!window.ApexCharts) {
            return;
        }

        var options = {
            chart: {
                type: 'line',
                height: 240,
                toolbar: { show: false }
            },
            series: [{
                name: 'Permohonan',
                data: [35, 52, 41, 60, 75, 90, 110, 95, 88, 120, 132, 140]
            }],
            xaxis: {
                categories: ['Jan', 'Feb', 'Mac', 'Apr', 'Mei', 'Jun', 'Jul', 'Ogos', 'Sep', 'Okt', 'Nov', 'Dis']
            },
            stroke: { curve: 'smooth' },
            colors: ['#fb9678']
        };

        var chartEl = document.querySelector('#applications-trend');
        if (chartEl) {
            var chart = new ApexCharts(chartEl, options);
            chart.render();
        }
    });
</script>
SCRIPT;
    }
}
