<?php

declare(strict_types=1);

namespace App\Support;

use App\Core\Database;

class UserRepository
{
    public function findByEmail(string $email): ?array
    {
        $sql = 'SELECT u.id, u.uuid, u.name, u.email, u.password, u.status,
                       u.email_verified_at, r.name AS role
                FROM users u
                LEFT JOIN role_user ru ON ru.user_id = u.id AND ru.is_primary = 1
                LEFT JOIN roles r ON r.id = ru.role_id
                WHERE u.email = ? LIMIT 1';

        $result = Database::query($sql, 's', [$email]);
        $row = $result->fetch_assoc();
        $result->free();

        return $row ?: null;
    }

    public function create(array $data): int
    {
        $sql = 'INSERT INTO users (uuid, name, email, password, status, email_verified_at)
                VALUES (?, ?, ?, ?, ?, ?)';

        $verified = $data['email_verified_at'] ?? null;
        Database::query($sql, 'ssssss', [
            $data['uuid'],
            $data['name'],
            $data['email'],
            $data['password'],
            $data['status'] ?? 'pending',
            $verified,
        ]);

        $mysqli = Database::connection();
        return (int) $mysqli->insert_id;
    }

    public function assignRole(int $userId, int $roleId, bool $primary = false): void
    {
        $sql = 'INSERT INTO role_user (user_id, role_id, is_primary) VALUES (?, ?, ?)';
        Database::query($sql, 'iii', [$userId, $roleId, $primary ? 1 : 0]);
    }

    public function ensureRole(string $name, string $displayName = null, bool $system = false): int
    {
        $sql = 'SELECT id FROM roles WHERE name = ? LIMIT 1';
        $result = Database::query($sql, 's', [$name]);
        if ($row = $result->fetch_assoc()) {
            $result->free();
            return (int) $row['id'];
        }
        $result->free();

        $insert = 'INSERT INTO roles (name, display_name, is_system) VALUES (?, ?, ?)';
        Database::query($insert, 'ssi', [$name, $displayName, $system ? 1 : 0]);
        return (int) Database::connection()->insert_id;
    }
}
