<?php

declare(strict_types=1);

use App\Core\Database;
use App\Support\UserRepository;

require __DIR__ . '/../app/bootstrap.php';

$users = new UserRepository();
database_seed_users($users);

function database_seed_users(UserRepository $users): void
{
    $adminRoleId = $users->ensureRole('admin', 'Pentadbir', true);
    $applicantRoleId = $users->ensureRole('applicant', 'Pemohon', false);

    seedUser($users, [
        'uuid' => '00000000-0000-0000-0000-000000000001',
        'name' => 'Pentadbir Sistem',
        'email' => 'admin@etauliah.melaka',
        'password' => password_hash('Admin#2025!', PASSWORD_BCRYPT),
        'status' => 'active',
        'email_verified_at' => date('Y-m-d H:i:s'),
    ], $adminRoleId, true);

    seedUser($users, [
        'uuid' => '00000000-0000-0000-0000-000000000002',
        'name' => 'Pemohon Contoh',
        'email' => 'pemohon@etauliah.melaka',
        'password' => password_hash('Pemohon#2025!', PASSWORD_BCRYPT),
        'status' => 'active',
        'email_verified_at' => date('Y-m-d H:i:s'),
    ], $applicantRoleId, true);
}

function seedUser(UserRepository $users, array $data, int $roleId, bool $primary): void
{
    $existing = $users->findByEmail($data['email']);
    if ($existing) {
        return;
    }

    $userId = $users->create($data);
    $users->assignRole($userId, $roleId, $primary);
}
