<?php
/** @var array<int, array<string, mixed>> $announcements */
/** @var array<string, string> $rolesMap */

$announcements = $announcements ?? [];
$rolesMap = $rolesMap ?? [];
$announcementsJson = json_encode($announcements, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
$rolesJson = json_encode($rolesMap, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
?>
<style>
.notification-dialog .modal-content {
    max-height: 80vh;
    display: flex;
    flex-direction: column;
}
.notification-dialog .modal-body {
    flex: 1 1 auto;
    overflow-y: auto;
}
</style>
<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row page-titles">
            <div class="col-md-6 col-12 align-self-center">
                <h3 class="text-themecolor mb-0">Pengurusan Notifikasi</h3>
                <small class="text-muted">Tambah, kemaskini dan padam pengumuman untuk kumpulan pengguna.</small>
            </div>
            <div class="col-md-6 col-12 align-self-center text-end">
                <button type="button" class="btn btn-info text-white" data-action="open-create" onclick="notifikasi_baharu()">
                    <i class="mdi mdi-bell-plus"></i> Notifikasi Baharu
                </button>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Senarai Pengumuman</h4>
                        <div class="table-responsive">
                            <table id="notifications-table" class="table table-striped table-bordered datatable">
                                <thead>
                                <tr>
                                    <th>Tajuk</th>
                                    <th>Sasaran</th>
                                    <th>Status</th>
                                    <th>Tarikh Siar</th>
                                    <th>Kemaskini</th>
                                    <th>Tindakan</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if (!$announcements): ?>
                                    <tr>
                                        <td colspan="6" class="text-center text-muted py-4">Tiada notifikasi direkodkan.</td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($announcements as $announcement): ?>
                                        <?php
                                        $bodyText = trim(preg_replace('/\\s+/', ' ', strip_tags((string) ($announcement['body'] ?? ''))));
                                        if (function_exists('mb_substr')) {
                                            $snippet = mb_substr($bodyText, 0, 200);
                                        } else {
                                            $snippet = substr($bodyText, 0, 200);
                                        }
                                        $textLength = function_exists('mb_strlen') ? mb_strlen($bodyText) : strlen($bodyText);
                                        if ($textLength > 200) {
                                            $snippet = rtrim($snippet) . '...';
                                        }
                                        $announcementJson = htmlspecialchars(json_encode($announcement, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES), ENT_QUOTES, 'UTF-8');
                                        ?>
                                        <tr
                                            data-announcement-id="<?php echo (int) ($announcement['id'] ?? 0); ?>"
                                            data-announcement-json="<?php echo $announcementJson; ?>"
                                        >
                                            <td>
                                                <strong><?php echo htmlspecialchars($announcement['title'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></strong>
                                                <?php if ($snippet !== ''): ?>
                                                    <div class="text-muted small mt-1"><?php echo htmlspecialchars($snippet, ENT_QUOTES, 'UTF-8'); ?></div>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo htmlspecialchars($announcement['audience_label'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                                            <td>
                                                <?php if ((int) ($announcement['is_active'] ?? 0) === 1): ?>
                                                    <span class="badge bg-success">Aktif</span>
                                                <?php else: ?>
                                                    <span class="badge bg-secondary text-dark">Tidak Aktif</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if (!empty($announcement['published_from_display'])):
                                                    ?><span class="d-block">Mula: <?php echo htmlspecialchars($announcement['published_from_display'], ENT_QUOTES, 'UTF-8'); ?></span>
                                                <?php endif; ?>
                                                <?php if (!empty($announcement['published_until_display'])):
                                                    ?><span class="d-block">Tamat: <?php echo htmlspecialchars($announcement['published_until_display'], ENT_QUOTES, 'UTF-8'); ?></span>
                                                <?php endif; ?>
                                                <?php if (empty($announcement['published_from_display']) && empty($announcement['published_until_display'])): ?>
                                                    <span class="text-muted">Tiada jadual</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo htmlspecialchars($announcement['created_at_display'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                                            <td>
                                                <button type="button" class="btn btn-sm btn-primary mb-1" data-action="edit-announcement">
                                                    <i class="mdi mdi-pencil"></i> Kemaskini
                                                </button>
                                                <button type="button" class="btn btn-sm btn-danger ms-2" data-action="delete-announcement">
                                                    <i class="mdi mdi-delete"></i> Padam
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<template id="notification-modal-template">
    <form id="notification-form" class="notification-form">
        <div id="notification-feedback" class="alert d-none" role="alert"></div>
        <input type="hidden" name="id" id="notification-id" value="">
        <div class="mb-3">
            <label for="notification-title" class="form-label">Tajuk</label>
            <input type="text" class="form-control" id="notification-title" name="title" required maxlength="150">
        </div>
        <div class="mb-3">
            <label for="notification-body" class="form-label">Kandungan</label>
            <textarea class="form-control" id="notification-body" name="body" rows="5" required></textarea>
            <small class="form-text text-muted">Gunakan teks ringkas dan jelas. HTML asas tidak disokong.</small>
        </div>
        <div class="mb-3">
            <label class="form-label d-block">Kumpulan Sasaran</label>
            <div class="form-check form-check-inline">
                <input class="form-check-input" type="radio" name="audience_mode" id="audience-all" value="all" checked>
                <label class="form-check-label" for="audience-all">Semua Pengguna</label>
            </div>
            <div class="form-check form-check-inline">
                <input class="form-check-input" type="radio" name="audience_mode" id="audience-applicant" value="applicant">
                <label class="form-check-label" for="audience-applicant">Pemohon Sahaja</label>
            </div>
            <div class="form-check form-check-inline">
                <input class="form-check-input" type="radio" name="audience_mode" id="audience-admin" value="admin">
                <label class="form-check-label" for="audience-admin">Semua Admin</label>
            </div>
            <div class="form-check form-check-inline">
                <input class="form-check-input" type="radio" name="audience_mode" id="audience-panel" value="panel">
                <label class="form-check-label" for="audience-panel">Panel</label>
            </div>
            <div class="form-check form-check-inline">
                <input class="form-check-input" type="radio" name="audience_mode" id="audience-custom" value="custom">
                <label class="form-check-label" for="audience-custom">Tersuai</label>
            </div>
            <div class="mt-2">
                <select class="form-select" id="notification-target-roles" name="target_roles[]" multiple size="5" disabled>
                    <?php foreach ($rolesMap as $role => $label): ?>
                        <option value="<?php echo htmlspecialchars($role, ENT_QUOTES, 'UTF-8'); ?>">
                            <?php echo htmlspecialchars($label, ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <small class="form-text text-muted">Pilih satu atau lebih kumpulan sasaran apabila mod tersuai dipilih.</small>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="notification-start" class="form-label">Tarikh Mula (Opsyen)</label>
                <input type="datetime-local" class="form-control" id="notification-start" name="published_from">
            </div>
            <div class="col-md-6 mb-3">
                <label for="notification-end" class="form-label">Tarikh Tamat (Opsyen)</label>
                <input type="datetime-local" class="form-control" id="notification-end" name="published_until">
            </div>
        </div>
        <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" role="switch" id="notification-active" name="is_active" value="1" checked>
            <label class="form-check-label" for="notification-active">Aktifkan notifikasi ini</label>
        </div>
    </form>
</template>
<script src="https://cdn.tiny.cloud/1/4o7gfqr6oc9g9wnszb2hteq78grsjqb54gfqmzz8gaon4zep/tinymce/8/tinymce.min.js" referrerpolicy="origin" crossorigin="anonymous"></script>
<script>
(function () {
    var openCreateModal = null;

    function init() {
        console.log('init() called');
    var announcements = <?php echo $announcementsJson ?: '[]'; ?>;
    var rolesMap = <?php echo $rolesJson ?: '{}'; ?>;
    var announcementMap = {};

    var parseDateValue = function (value) {
        if (!value) {
            return 0;
        }
        if (value instanceof Date) {
            return value.getTime();
        }
        if (typeof value === 'number') {
            return value;
        }
        if (typeof value !== 'string') {
            return 0;
        }
        var trimmed = value.trim();
        if (trimmed === '') {
            return 0;
        }
        var parsed = Date.parse(trimmed);
        if (!isNaN(parsed)) {
            return parsed;
        }
        var isoMatch = trimmed.match(/^(\d{4})-(\d{2})-(\d{2})(?:[ T](\d{2}):(\d{2})(?::(\d{2}))?)?/);
        if (isoMatch) {
            var year = parseInt(isoMatch[1], 10);
            var month = parseInt(isoMatch[2], 10) - 1;
            var day = parseInt(isoMatch[3], 10);
            var hour = parseInt(isoMatch[4] || '0', 10);
            var minute = parseInt(isoMatch[5] || '0', 10);
            var second = parseInt(isoMatch[6] || '0', 10);
            return Date.UTC(year, month, day, hour, minute, second);
        }
        var euroMatch = trimmed.match(/^(\d{2})\/(\d{2})\/(\d{4})(?:\s+(\d{2}):(\d{2})(?::(\d{2}))?)?/);
        if (euroMatch) {
            var day = parseInt(euroMatch[1], 10);
            var month = parseInt(euroMatch[2], 10) - 1;
            var year = parseInt(euroMatch[3], 10);
            var hour = parseInt(euroMatch[4] || '0', 10);
            var minute = parseInt(euroMatch[5] || '0', 10);
            var second = parseInt(euroMatch[6] || '0', 10);
            return Date.UTC(year, month, day, hour, minute, second);
        }
        return 0;
    };

    var getSortedAnnouncements = function () {
        return Object.values(announcementMap).sort(function (a, b) {
            var candidatesA = [
                a && a.created_at,
                a && a.updated_at,
                a && a.created_at_display,
                a && a.updated_at_display,
                a && a.published_from,
                a && a.published_from_display
            ];
            var candidatesB = [
                b && b.created_at,
                b && b.updated_at,
                b && b.created_at_display,
                b && b.updated_at_display,
                b && b.published_from,
                b && b.published_from_display
            ];
            var aTime = 0;
            for (var i = 0; i < candidatesA.length; i++) {
                aTime = parseDateValue(candidatesA[i]);
                if (aTime) {
                    break;
                }
            }
            var bTime = 0;
            for (var j = 0; j < candidatesB.length; j++) {
                bTime = parseDateValue(candidatesB[j]);
                if (bTime) {
                    break;
                }
            }
            if (bTime !== aTime) {
                return bTime - aTime;
            }
            var aId = Number(a && a.id) || 0;
            var bId = Number(b && b.id) || 0;
            return bId - aId;
        });
    };

    announcements.forEach(function (announcement) {
        if (announcement && typeof announcement.id !== 'undefined') {
            announcementMap[announcement.id] = announcement;
        }
    });
    announcements = getSortedAnnouncements();

    var table = document.getElementById('notifications-table');
    var dialogTemplate = document.getElementById('notification-modal-template');
    var form = null;
    var feedback = null;
    var idInput = null;
    var titleInput = null;
    var bodyInput = null;
    var audienceRadios = [];
    var targetSelect = null;
    var activeSwitch = null;
    var startInput = null;
    var endInput = null;
    var createButton = document.querySelector('[data-action="open-create"]');

    var $ = window.jQuery || null;
    var dataTableInstance = null;
    var dialogInstance = null;
    var editorInitializing = false;
    var pendingEditorContent = null;
    var dataTableInitAttempts = 0;
    var maxDataTableAttempts = 25;

    var skinColors = {
        'skin-default': '#4F5467',
        'skin-green': '#00c292',
        'skin-red': '#ed4040',
        'skin-blue': '#5475ed',
        'skin-purple': '#6f42c1',
        'skin-megna': '#01c0c8',
        'skin-default-dark': '#fb9678',
        'skin-green-dark': '#00c292',
        'skin-red-dark': '#ed4040',
        'skin-blue-dark': '#5475ed',
        'skin-purple-dark': '#6f42c1',
        'skin-megna-dark': '#01c0c8'
    };

    var getStoredSkinClass = function () {
        var key = 'skin_urus';
        var stored = null;
        try {
            if (typeof window.localStorage !== 'undefined') {
                stored = window.localStorage.getItem(key);
            }
        } catch (error) {
            console.warn('Tidak dapat mengakses localStorage untuk tema:', error);
        }
        if (!stored && document.body) {
            stored = Object.keys(skinColors).find(function (name) {
                return document.body.classList.contains(name);
            }) || null;
        }
        return stored;
    };

    var getSkinThemeColor = function () {
        var skin = getStoredSkinClass();
        if (skin && skinColors[skin]) {
            return skinColors[skin];
        }
        return skinColors['skin-default'];
    };

    var applyDialogTheme = function () {
        if (!dialogInstance) {
            return;
        }
        var color = getSkinThemeColor();
        var modal = dialogInstance.getModal ? dialogInstance.getModal() : null;
        if (modal && modal.length) {
            modal.addClass('notification-dialog');
        }
        var header = dialogInstance.getModalHeader ? dialogInstance.getModalHeader() : null;
        if (!header || !header.length) {
            return;
        }
        header.css({
            'background-color': color,
            'color': '#ffffff'
        });
        header.find('.modal-title').css('color', '#ffffff');
        header.find('.btn-close, .close')
            .addClass('btn-close-white')
            .css({
                'opacity': '0.85'
            });
    };

    var escapeHtml = function (value) {
        if (value === null || value === undefined) {
            return '';
        }
        return String(value).replace(/[&<>"']/g, function (char) {
            switch (char) {
                case '&': return '&amp;';
                case '<': return '&lt;';
                case '>': return '&gt;';
                case '"': return '&quot;';
                case "'": return '&#039;';
                default: return char;
            }
        });
    };

    var htmlToText = function (html) {
        if (typeof html !== 'string' || html.trim() === '') {
            return '';
        }
        var text = html.replace(/<[^>]+>/g, ' ');
        return text.replace(/\s+/g, ' ').trim();
    };

    var titleCellHtml = function (announcement) {
        var safe = announcement || {};
        var title = escapeHtml(safe.title || '');
        var snippetSource = htmlToText(safe.body || '');
        var snippet = snippetSource.length > 200 ? snippetSource.slice(0, 200).trim() + '...' : snippetSource;
        var snippetHtml = snippet ? '<div class="text-muted small mt-1">' + escapeHtml(snippet) + '</div>' : '';
        return '<div><strong>' + title + '</strong>' + snippetHtml + '</div>';
    };

    var statusBadgeHtml = function (announcement) {
        return announcement.is_active === 1
            ? '<span class="badge bg-success">Aktif</span>'
            : '<span class="badge bg-secondary text-dark">Tidak Aktif</span>';
    };

    var scheduleHtml = function (announcement) {
        var parts = [];
        if (announcement.published_from_display) {
            parts.push('<span class="d-block">Mula: ' + escapeHtml(announcement.published_from_display) + '</span>');
        }
        if (announcement.published_until_display) {
            parts.push('<span class="d-block">Tamat: ' + escapeHtml(announcement.published_until_display) + '</span>');
        }
        if (!parts.length) {
            return '<span class="text-muted">Tiada jadual</span>';
        }
        return parts.join('');
    };

    var actionsHtml = function () {
        return '' +
            '<button type="button" class="btn btn-sm btn-outline-primary" data-action="edit-announcement">' +
                '<i class="mdi mdi-pencil"></i> Kemaskini' +
            '</button>' +
            '<button type="button" class="btn btn-sm btn-outline-danger ms-2" data-action="delete-announcement">' +
                '<i class="mdi mdi-delete"></i> Padam' +
            '</button>';
    };

    var escapeAttribute = function (value) {
        if (value === null || value === undefined) {
            return '';
        }
        return escapeHtml(String(value)).replace(/\n/g, '&#10;').replace(/\r/g, '&#13;');
    };

    var setRowAttributes = function (row, announcement) {
        if (!row || !announcement) {
            return;
        }
        var id = announcement.id || '';
        var jsonString = '{}';
        try {
            jsonString = JSON.stringify(announcement);
        } catch (error) {
            console.error('Tidak dapat menukar notifikasi kepada JSON:', error);
        }
        row.setAttribute('data-announcement-id', String(id));
        row.setAttribute('data-announcement-json', jsonString);
    };

    var buildRowHtml = function (announcement) {
        if (!announcement) {
            announcement = {};
        }
        var id = typeof announcement.id !== 'undefined' ? announcement.id : '';
        var jsonString = '{}';
        try {
            jsonString = JSON.stringify(announcement);
        } catch (error) {
            console.error('Tidak dapat menukar notifikasi kepada JSON:', error);
        }
        return '' +
            '<tr data-announcement-id="' + escapeAttribute(String(id)) + '" data-announcement-json="' + escapeAttribute(jsonString) + '">' +
                '<td>' + titleCellHtml(announcement) + '</td>' +
                '<td>' + escapeHtml(announcement.audience_label || '-') + '</td>' +
                '<td>' + statusBadgeHtml(announcement) + '</td>' +
                '<td>' + scheduleHtml(announcement) + '</td>' +
                '<td>' + escapeHtml(announcement.created_at_display || '-') + '</td>' +
                '<td>' + actionsHtml() + '</td>' +
            '</tr>';
    };

    var buildRowElement = function (announcement) {
        var tempContainer = document.createElement('tbody');
        tempContainer.innerHTML = buildRowHtml(announcement);
        return tempContainer.firstElementChild;
    };

    var createDialogContent = function () {
        if (!dialogTemplate) {
            return null;
        }
        var contentFragment;
        if ('content' in dialogTemplate) {
            contentFragment = dialogTemplate.content.cloneNode(true);
        } else {
            var tempWrapper = document.createElement('div');
            tempWrapper.innerHTML = dialogTemplate.innerHTML;
            contentFragment = document.createDocumentFragment();
            while (tempWrapper.firstChild) {
                contentFragment.appendChild(tempWrapper.firstChild);
            }
        }
        var container = document.createElement('div');
        container.appendChild(contentFragment);
        var formElement = container.querySelector('#notification-form');
        if (!formElement) {
            return null;
        }
        container.removeChild(formElement);
        return formElement;
    };

    var assignDialogElements = function (root) {
        if (!root) {
            return;
        }
        form = root;
        feedback = root.querySelector('#notification-feedback');
        idInput = root.querySelector('#notification-id');
        titleInput = root.querySelector('#notification-title');
        bodyInput = root.querySelector('#notification-body');
        audienceRadios = Array.prototype.slice.call(root.querySelectorAll('input[name="audience_mode"]'));
        targetSelect = root.querySelector('#notification-target-roles');
        activeSwitch = root.querySelector('#notification-active');
        startInput = root.querySelector('#notification-start');
        endInput = root.querySelector('#notification-end');
    };

    var triggerFormSubmit = function () {
        if (!form) {
            return;
        }
        if (typeof form.requestSubmit === 'function') {
            form.requestSubmit();
            return;
        }
        try {
            var submitEvent = new Event('submit', { bubbles: true, cancelable: true });
            if (form.dispatchEvent(submitEvent)) {
                form.submit();
            }
        } catch (error) {
            form.submit();
        }
    };

    var ensureDialog = function () {
        if (dialogInstance) {
            return dialogInstance;
        }
        if (!window.BootstrapDialog) {
            console.error('BootstrapDialog tidak tersedia pada halaman ini.');
            return null;
        }
        var content = createDialogContent();
        if (!content) {
            console.error('Tidak dapat menjana kandungan dialog notifikasi.');
            return null;
        }
        assignDialogElements(content);
        var dialogSize = (window.BootstrapDialog && BootstrapDialog.SIZE_WIDE) ? BootstrapDialog.SIZE_WIDE : (BootstrapDialog.SIZE_NORMAL || null);
        dialogInstance = new BootstrapDialog({
            title: 'Notifikasi Baharu',
            size: dialogSize,
            autodestroy: false,
            closable: true,
            closeByBackdrop: false,
            buttons: [
                {
                    label: 'Tutup',
                    cssClass: 'btn btn-light border',
                    action: function () {
                        hideModal();
                        return false;
                    }
                },
                {
                    label: 'Simpan',
                    cssClass: 'btn btn-primary',
                    icon: 'mdi mdi-content-save',
                    action: function () {
                        triggerFormSubmit();
                        return false;
                    }
                }
            ],
            message: $(content),
            onshown: function () {
                applyDialogTheme();
                initTinyMCE();
            },
            onhide: function () {
                resetForm();
            }
        });
        dialogInstance.realize();
        applyDialogTheme();
        return dialogInstance;
    };

    var setDialogTitle = function (title) {
        var dialog = ensureDialog();
        if (dialog && typeof dialog.setTitle === 'function') {
            dialog.setTitle(title || '');
            applyDialogTheme();
        }
    };

    var showModal = function () {
        var dialog = ensureDialog();
        if (dialog && typeof dialog.open === 'function') {
            dialog.open();
        }
    };

    var hideModal = function () {
        if (dialogInstance && typeof dialogInstance.close === 'function') {
            dialogInstance.close();
        }
    };

    var initTinyMCE = function () {
        if (!window.tinymce) {
            return;
        }
        if (tinymce.get('notification-body') || editorInitializing) {
            return;
        }
        if (!bodyInput || !bodyInput.isConnected) {
            setTimeout(initTinyMCE, 120);
            return;
        }
        editorInitializing = true;
        var initResult = tinymce.init({
            target: bodyInput,
            menubar: false,
            height: 280,
            branding: false,
            plugins: 'link lists',
            toolbar: 'undo redo | bold italic underline | bullist numlist | link removeformat | link',
            init_instance_callback: function (editor) {
                editorInitializing = false;
                if (pendingEditorContent !== null) {
                    editor.setContent(pendingEditorContent || '');
                    editor.save();
                    pendingEditorContent = null;
                }
            },
            setup: function (editor) {
                editor.on('change keyup', function () {
                    editor.save();
                });
            }
        });
        if (initResult && typeof initResult.catch === 'function') {
            initResult.catch(function (error) {
                editorInitializing = false;
                console.error('Inisialisasi TinyMCE gagal:', error);
            });
        }
    };

    var setEditorContent = function (value) {
        if (window.tinymce) {
            var editor = tinymce.get('notification-body');
            if (editor) {
                editor.setContent(value || '');
                editor.save();
            } else {
                pendingEditorContent = value || '';
                initTinyMCE();
            }
        } else if (bodyInput) {
            bodyInput.value = value || '';
        }
    };

    var getEditorContent = function () {
        if (window.tinymce) {
            var editor = tinymce.get('notification-body');
            if (editor) {
                editor.save();
                return editor.getContent();
            }
        }
        return bodyInput ? bodyInput.value : '';
    };

    var toggleTargets = function () {
        if (!form) {
            return;
        }
        var mode = form.querySelector('input[name="audience_mode"]:checked');
        var enabled = mode && mode.value === 'custom';
        if (targetSelect) {
            targetSelect.disabled = !enabled;
        }
    };

    var clearFeedback = function () {
        if (!feedback) {
            return;
        }
        feedback.classList.add('d-none');
        feedback.classList.remove('alert-success', 'alert-danger');
        feedback.textContent = '';
    };

    var showFeedback = function (message, type) {
        if (!feedback) {
            return;
        }
        feedback.classList.remove('d-none', 'alert-success', 'alert-danger');
        feedback.classList.add(type === 'success' ? 'alert-success' : 'alert-danger');
        feedback.textContent = message;
    };

    var resetForm = function () {
        if (!form) {
            return;
        }
        form.reset();
        idInput.value = '';
        startInput.value = '';
        endInput.value = '';
        activeSwitch.checked = true;
        audienceRadios.forEach(function (radio, index) {
            radio.checked = index === 0;
        });
        if (targetSelect) {
            Array.prototype.slice.call(targetSelect.options).forEach(function (option) {
                option.selected = false;
            });
            targetSelect.disabled = true;
        }
        setEditorContent('');
        clearFeedback();
        toggleTargets();
    };

    var fillForm = function (announcement) {
        resetForm();
        if (!announcement) {
            return;
        }
        idInput.value = announcement.id || '';
        titleInput.value = announcement.title || '';
        setEditorContent(announcement.body || '');
        activeSwitch.checked = announcement.is_active === 1;
        if (announcement.published_from) {
            startInput.value = announcement.published_from.replace(' ', 'T');
        }
        if (announcement.published_until) {
            endInput.value = announcement.published_until.replace(' ', 'T');
        }
        var mode = announcement.audience || 'all';
        if (['all', 'applicant', 'admin', 'panel'].indexOf(mode) === -1) {
            mode = 'custom';
        }
        audienceRadios.forEach(function (radio) {
            radio.checked = radio.value === mode;
        });
        toggleTargets();
        if (mode === 'custom' && targetSelect && Array.isArray(announcement.targets)) {
            var targets = announcement.targets.map(String);
            Array.prototype.slice.call(targetSelect.options).forEach(function (option) {
                option.selected = targets.indexOf(option.value) !== -1;
            });
        }
    };

    var renderFallbackTable = function () {
        if (!table || dataTableInstance) {
            return;
        }
        var tbody = table.tBodies[0] || table.appendChild(document.createElement('tbody'));
        var values = getSortedAnnouncements();
        if (!values.length) {
            tbody.innerHTML = '<tr><td colspan="6" class="text-center text-muted">Tiada notifikasi direkodkan.</td></tr>';
            return;
        }
        var rowsHtml = values.map(function (announcement) {
            return buildRowHtml(announcement);
        }).join('');
        tbody.innerHTML = rowsHtml;
    };

    var initDataTable = function () {
        console.log('initDataTable() called');
        if (!$ || !$.fn || !table) {
            console.log('jQuery or table not found');
            renderFallbackTable();
            return;
        }
        if (typeof $.fn.DataTable !== 'function') {
            console.log('DataTable function not found, retrying...');
            dataTableInitAttempts += 1;
            if (dataTableInitAttempts <= maxDataTableAttempts) {
                setTimeout(initDataTable, 150);
                return;
            }
            console.log('DataTable function not found after multiple attempts.');
            renderFallbackTable();
            return;
        }
        console.log('Initializing DataTable...');
        var $table = $(table);
        dataTableInstance = $table.DataTable({
            order: [[4, 'desc']],
            responsive: true,
            columnDefs: [
                { targets: [5], orderable: false, searchable: false }
            ],
            language: {
                emptyTable: 'Tiada notifikasi direkodkan.'
            }
        });
        console.log('DataTable initialized.');
    };

    var refreshDataTable = function () {
        if (!dataTableInstance || !$ || !$.fn || typeof $.fn.DataTable !== 'function') {
            return;
        }
        var dataset = getSortedAnnouncements();
        announcements = dataset.slice();
        dataTableInstance.clear();
        dataset.forEach(function (announcement) {
            var rowElement = buildRowElement(announcement);
            if (rowElement) {
                dataTableInstance.row.add(rowElement);
            }
        });
        dataTableInstance.draw(false);
    };

    var upsertAnnouncement = function (announcement) {
        if (!announcement || typeof announcement.id === 'undefined') {
            return;
        }
        announcementMap[announcement.id] = announcement;
        announcements = getSortedAnnouncements();
        if (dataTableInstance && $) {
            refreshDataTable();
        } else {
            renderFallbackTable();
        }
    };

    var removeAnnouncement = function (id) {
        if (!id) {
            return;
        }
        delete announcementMap[id];
        announcements = getSortedAnnouncements();
        if (dataTableInstance && $) {
            refreshDataTable();
        } else {
            renderFallbackTable();
        }
    };

    var getRowInfoFromEvent = function (target) {
        var rowElement = null;
        var data = null;

        if (dataTableInstance && $) {
            var $row = $(target).closest('tr');
            if ($row.hasClass('child') && $row.prev().length) {
                $row = $row.prev();
            }
            if ($row.length) {
                var dtRow = dataTableInstance.row($row);
                if (dtRow) {
                    if (typeof dtRow.node === 'function') {
                        rowElement = dtRow.node();
                    } else if (dtRow.node) {
                        rowElement = dtRow.node;
                    }
                    if (typeof dtRow.data === 'function') {
                        var dtRowData = dtRow.data();
                        if (dtRowData && typeof dtRowData === 'object' && !Array.isArray(dtRowData) && typeof dtRowData.id !== 'undefined') {
                            data = dtRowData;
                        }
                    }
                }
            }
        }

        if (!rowElement && target.closest) {
            rowElement = target.closest('tr');
        }

        if (!data && rowElement) {
            var json = rowElement.getAttribute('data-announcement-json');
            if (!json && $) {
                json = $(rowElement).attr('data-announcement-json') || null;
            }
            if (json) {
                try {
                    data = JSON.parse(json);
                } catch (error) {
                    console.error('Gagal menganalisis data notifikasi:', error);
                }
            }
            if (!data) {
                var fallbackId = parseInt(rowElement.getAttribute('data-announcement-id') || '0', 10);
                if (announcementMap[fallbackId]) {
                    data = announcementMap[fallbackId];
                }
            }
        }

        return { data: data || null, row: rowElement };
    };

    var handleEdit = function (announcement) {
        if (!announcement) {
            return;
        }
        setDialogTitle('Kemaskini Notifikasi');
        fillForm(announcement);
        showModal();
    };

    var handleDelete = function (announcement) {
        if (!announcement) {
            return;
        }
        if (!confirm('Padam notifikasi ini? Tindakan tidak boleh dibatalkan.')) {
            return;
        }
        var formData = new FormData();
        formData.append('id', announcement.id);
        fetch('/modules/admin/notifications/delete', {
            method: 'POST',
            body: formData,
            credentials: 'same-origin',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        }).then(function (response) {
            return response.json().catch(function () { return {}; }).then(function (data) {
                return { ok: response.ok, data: data };
            });
        }).then(function (payload) {
            if (!payload.ok || payload.data.success === false) {
                alert(payload.data.message || 'Tidak dapat memadam notifikasi.');
                return;
            }
            removeAnnouncement(announcement.id);
        }).catch(function (error) {
            console.error('Padam notifikasi gagal:', error);
            alert('Tidak dapat memadam notifikasi sekarang.');
        });
    };

    ensureDialog();
    initTinyMCE();
    initDataTable();
    toggleTargets();

    audienceRadios.forEach(function (radio) {
        radio.addEventListener('change', toggleTargets);
    });

    openCreateModal = function () {
        setDialogTitle('Notifikasi Baharu');
        resetForm();
        setEditorContent('');
        showModal();
    };

    if (createButton) {
        createButton.addEventListener('click', openCreateModal);
    }

    if (typeof window !== 'undefined') {
        window.notifikasi_baharu = openCreateModal;
    }

    if (dataTableInstance && $) {
        $(table).on('click', '[data-action="edit-announcement"]', function (event) {
            var info = getRowInfoFromEvent(event.target);
            handleEdit(info.data);
        });
        $(table).on('click', '[data-action="delete-announcement"]', function (event) {
            var info = getRowInfoFromEvent(event.target);
            handleDelete(info.data);
        });
    } else if (table) {
        table.addEventListener('click', function (event) {
            var trigger = event.target.closest('[data-action="edit-announcement"], [data-action="delete-announcement"]');
            if (!trigger) {
                return;
            }
            var info = getRowInfoFromEvent(trigger);
            if (!info.data) {
                return;
            }
            if (trigger.matches('[data-action="edit-announcement"]')) {
                handleEdit(info.data);
            } else if (trigger.matches('[data-action="delete-announcement"]')) {
                handleDelete(info.data);
            }
        });
    }

    if (form) {
        form.addEventListener('submit', function (event) {
            event.preventDefault();
            clearFeedback();
            var formData = new FormData(form);
            formData.set('is_active', activeSwitch.checked ? '1' : '0');
            formData.set('body', getEditorContent());
            fetch('/modules/admin/notifications/save', {
                method: 'POST',
                body: formData,
                credentials: 'same-origin',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                }
            }).then(function (response) {
                return response.json().catch(function () { return {}; }).then(function (data) {
                    return { ok: response.ok, data: data };
                });
            }).then(function (payload) {
                if (!payload.ok || payload.data.success === false) {
                    showFeedback(payload.data.message || 'Tidak dapat menyimpan notifikasi.', 'danger');
                    return;
                }
                var announcement = payload.data.announcement || null;
                if (announcement) {
                    upsertAnnouncement(announcement);
                }
                showFeedback(payload.data.message || 'Notifikasi berjaya disimpan.', 'success');
                setTimeout(function () {
                    hideModal();
                }, 600);
            }).catch(function (error) {
                console.error('Simpan notifikasi gagal:', error);
                showFeedback('Tidak dapat menyimpan notifikasi sekarang.', 'danger');
            });
        });
    }
    }

    

    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }
})();

</script>
<script>
        $(document).ready(function() {
            $('.datatable').DataTable();
        });
    </script>