<?php
$session = session();
$flashSuccess = $success ?? $session->getFlash('success');
$flashError = $error ?? $session->getFlash('error');
$title = $title ?? 'Tetapan Semula Kata Laluan';
$action = route('/reset_password.php');
?>
<div class="login-box card">
    <div class="card-body">
        <h3 class="box-title m-b-20 text-center"><?php echo htmlspecialchars($title, ENT_QUOTES, 'UTF-8'); ?></h3>
        <p class="text-muted text-center">Sila masukkan maklumat berikut untuk menetapkan kata laluan baharu.</p>
        <form id="passwordResetForm" class="form-horizontal form-material" action="<?php echo htmlspecialchars($action, ENT_QUOTES, 'UTF-8'); ?>" method="POST" novalidate>
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <label for="resetEmail" class="form-label">Alamat Emel</label>
                <input type="email" class="form-control" id="resetEmail" name="email" required autocomplete="email" placeholder="Alamat Emel Berdaftar">
            </div>
            <div class="form-group">
                <label for="temporaryPassword" class="form-label">Kata Laluan Sementara</label>
                <input type="text" class="form-control" id="temporaryPassword" name="temporary_password" required autocomplete="one-time-code" placeholder="Masukkan kata laluan sementara">
                <small class="form-text text-muted">Rujuk emel yang dihantar untuk kata laluan sementara.</small>
            </div>
            <div class="form-group">
                <label for="newPassword" class="form-label">Kata Laluan Baharu</label>
                <input type="password" class="form-control" id="newPassword" name="password" required autocomplete="new-password" minlength="8" placeholder="Sekurang-kurangnya 8 aksara">
            </div>
            <div class="form-group">
                <label for="confirmPassword" class="form-label">Sahkan Kata Laluan Baharu</label>
                <input type="password" class="form-control" id="confirmPassword" name="password_confirmation" required autocomplete="new-password" minlength="8" placeholder="Ulang kata laluan baharu">
            </div>
            <div class="form-group text-center m-t-20">
                <div class="col-xs-12">
                    <button class="btn btn-info btn-lg w-100 text-uppercase" type="submit">Tetapkan Kata Laluan</button>
                </div>
            </div>
        </form>
        <div class="text-center mt-3">
            <a href="<?php echo htmlspecialchars(route('/'), ENT_QUOTES, 'UTF-8'); ?>" class="text-info">Kembali ke halaman log masuk</a>
        </div>
    </div>
</div>
<script>
    window.resetFlash = {
        success: <?php echo json_encode($flashSuccess, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_AMP | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE); ?>,
        error: <?php echo json_encode($flashError, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_AMP | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE); ?>
    };
</script>
