<?php
$user = $user ?? ['name' => 'Pemohon'];
?>
<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row page-titles">
            <div class="col-md-5 align-self-center">
                <h4 class="text-themecolor">Dashboard Pemohon</h4>
            </div>
            <div class="col-md-7 align-self-center text-end">
                <div class="d-flex justify-content-end align-items-center">
                    <ol class="breadcrumb justify-content-end">
                        <li class="breadcrumb-item"><a href="<?php echo route('/dashboard/applicant'); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item active">Utama</li>
                    </ol>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-4 col-md-6">
                <div class="card">
                    <div class="card-body text-center">
                        <img src="<?php echo htmlspecialchars(asset('assets/images/users/1.jpg'), ENT_QUOTES, 'UTF-8'); ?>" alt="" class="img-circle" width="90">
                        <h4 class="card-title m-t-10"><?php echo htmlspecialchars($user['name'] ?? 'Pemohon', ENT_QUOTES, 'UTF-8'); ?></h4>
                        <h6 class="card-subtitle">No. KP: 800101-04-5678</h6>
                        <a href="javascript:void(0)" class="btn btn-info btn-sm m-t-10">Kemaskini Profil</a>
                    </div>
                </div>
            </div>
            <div class="col-lg-8 col-md-6">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Status Permohonan</h4>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>No. Permohonan</th>
                                        <th>Jenis</th>
                                        <th>Status</th>
                                        <th>Kemaskini</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($applications ?? [] as $application): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($application['number'], ENT_QUOTES, 'UTF-8'); ?></td>
                                            <td><?php echo htmlspecialchars($application['type'], ENT_QUOTES, 'UTF-8'); ?></td>
                                            <td><span class="badge bg-info"><?php echo htmlspecialchars($application['status'], ENT_QUOTES, 'UTF-8'); ?></span></td>
                                            <td><?php echo htmlspecialchars($application['updated_at'], ENT_QUOTES, 'UTF-8'); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        <a href="javascript:void(0)" class="btn btn-success btn-sm mt-3">Buat Permohonan Baharu</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Pengumuman & Notis</h4>
                        <div class="list-group">
                            <a href="javascript:void(0)" class="list-group-item">
                                <span class="badge bg-success float-end">Baru</span>
                                Pengambilan permohonan Tauliah Agama dibuka sehingga 28 Feb 2025.
                            </a>
                            <a href="javascript:void(0)" class="list-group-item">
                                Sesi taklimat pemohon baharu pada 15 Feb 2025 (9.00 pagi) di Kompleks Islam Melaka.
                            </a>
                            <a href="javascript:void(0)" class="list-group-item">
                                Ingatkan untuk memperbaharui tauliah 3 bulan sebelum tarikh luput.
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
