<?php
$module = $module ?? [];
$parent = $parentModule ?? [];
$capabilities = $module['capabilities'] ?? [];
$description = $module['description'] ?? '';
$status = $module['status'] ?? 'Dalam Pembangunan';
$icon = $module['icon'] ?? 'fas fa-circle';
$parentIcon = $parent['icon'] ?? 'fas fa-layer-group';
$parentLabel = $parent['label'] ?? '';
$additionalNotes = $module['notes'] ?? null;
?>
<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row page-titles">
            <div class="col-md-5 align-self-center">
                <h4 class="text-themecolor mb-0">
                    <i class="<?php echo htmlspecialchars($parentIcon, ENT_QUOTES, 'UTF-8'); ?> me-2 text-info"></i>
                    <?php echo htmlspecialchars($parentLabel ?: 'Modul Sistem', ENT_QUOTES, 'UTF-8'); ?>
                    <small class="text-muted d-block mt-1">
                        <?php echo htmlspecialchars($module['label'] ?? '', ENT_QUOTES, 'UTF-8'); ?>
                    </small>
                </h4>
            </div>
            <div class="col-md-7 align-self-center text-end">
                <div class="d-flex justify-content-end align-items-center">
                    <ol class="breadcrumb justify-content-end">
                        <li class="breadcrumb-item"><a href="<?php echo route('/dashboard'); ?>">Dashboard</a></li>
                        <?php if ($parentLabel !== ''): ?>
                            <li class="breadcrumb-item"><?php echo htmlspecialchars($parentLabel, ENT_QUOTES, 'UTF-8'); ?></li>
                        <?php endif; ?>
                        <li class="breadcrumb-item active"><?php echo htmlspecialchars($module['label'] ?? '', ENT_QUOTES, 'UTF-8'); ?></li>
                    </ol>
                    <span class="badge bg-secondary ms-3">
                        <?php echo htmlspecialchars($status, ENT_QUOTES, 'UTF-8'); ?>
                    </span>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8 col-md-7">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-4">
                            <div class="rounded-circle bg-info bg-opacity-25 text-info p-3 me-3">
                                <i class="<?php echo htmlspecialchars($icon, ENT_QUOTES, 'UTF-8'); ?> fa-2x"></i>
                            </div>
                            <div>
                                <h3 class="mb-0"><?php echo htmlspecialchars($module['label'] ?? '', ENT_QUOTES, 'UTF-8'); ?></h3>
                                <?php if ($description !== ''): ?>
                                    <p class="mb-0 text-muted"><?php echo htmlspecialchars($description, ENT_QUOTES, 'UTF-8'); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>

                        <?php if ($capabilities !== []): ?>
                            <h5 class="fw-semibold">Keupayaan Utama</h5>
                            <ul class="list-unstyled ps-3">
                                <?php foreach ($capabilities as $capability): ?>
                                    <li class="mb-2">
                                        <i class="fas fa-check text-success me-2"></i>
                                        <?php echo htmlspecialchars($capability, ENT_QUOTES, 'UTF-8'); ?>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        <?php endif; ?>

                        <div class="alert alert-info mt-4 d-flex align-items-center" role="alert">
                            <i class="fas fa-tools me-2"></i>
                            <span>Fungsi terperinci sedang dalam pembangunan selaras dengan spesifikasi keperluan pengguna e-Tauliah.</span>
                        </div>

                        <?php if ($additionalNotes): ?>
                            <div class="alert alert-warning mt-3">
                                <?php echo htmlspecialchars($additionalNotes, ENT_QUOTES, 'UTF-8'); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-5">
                <div class="card">
                    <div class="card-body">
                        <h5 class="fw-semibold mb-3">Garis Masa Pembangunan</h5>
                        <p class="text-muted mb-2">Modul ini disusun berdasarkan keutamaan projek dan akan dikemas kini secara berkala.</p>
                        <ul class="timeline">
                            <li>
                                <div class="timeline-badge bg-info"><i class="fas fa-lightbulb text-white"></i></div>
                                <div class="timeline-panel">
                                    <div class="timeline-heading">
                                        <h6 class="timeline-title">Fasa Reka Bentuk</h6>
                                        <p><small class="text-muted"><i class="fas fa-clock"></i> Sedang berjalan</small></p>
                                    </div>
                                    <div class="timeline-body">
                                        <p>Penentuan aliran kerja terperinci, model data dan pengalaman pengguna.</p>
                                    </div>
                                </div>
                            </li>
                            <li class="timeline-inverted">
                                <div class="timeline-badge bg-success"><i class="fas fa-code text-white"></i></div>
                                <div class="timeline-panel">
                                    <div class="timeline-heading">
                                        <h6 class="timeline-title">Fasa Pembangunan</h6>
                                        <p><small class="text-muted"><i class="fas fa-clock"></i> Dijadualkan</small></p>
                                    </div>
                                    <div class="timeline-body">
                                        <p>Pelaksanaan modul termasuk keselamatan, automasi dan integrasi luaran.</p>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="timeline-badge bg-warning"><i class="fas fa-vial text-white"></i></div>
                                <div class="timeline-panel">
                                    <div class="timeline-heading">
                                        <h6 class="timeline-title">Fasa Ujian & Latihan</h6>
                                        <p><small class="text-muted"><i class="fas fa-clock"></i> Akan datang</small></p>
                                    </div>
                                    <div class="timeline-body">
                                        <p>Ujian penerimaan pengguna (UAT), dokumentasi dan sesi latihan fungsi.</p>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="card">
                    <div class="card-body">
                        <h5 class="fw-semibold mb-3">Tindakan Seterusnya</h5>
                        <ul class="list-unstyled">
                            <li class="mb-3">
                                <i class="fas fa-clipboard-check text-primary me-2"></i>
                                Sahkan keperluan tambahan bersama urusetia projek.
                            </li>
                            <li class="mb-3">
                                <i class="fas fa-diagram-project text-primary me-2"></i>
                                Padankan modul dengan sumber pembangunan dan garis masa.
                            </li>
                            <li class="mb-0">
                                <i class="fas fa-headset text-primary me-2"></i>
                                Laporkan kemajuan dalam mesyuarat pengurusan projek e-Tauliah.
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
