<?php
$session = session();
$user = $session->get('user') ?? [];
$role = $user['role'] ?? null;
$userName = $user['name'] ?? 'Pengguna Sistem';
$userEmail = $user['email'] ?? '';
$modules = config('modules', []);

$currentUri = $_SERVER['REQUEST_URI'] ?? '/';
$currentPath = parse_url($currentUri, PHP_URL_PATH) ?: '/';

$hasAccess = static function (array $roles, ?string $currentRole): bool {
    if ($roles === []) {
        return true;
    }

    if ($currentRole === null) {
        return false;
    }

    return in_array($currentRole, $roles, true);
};

$isItemActive = static function (array $item, string $path): bool {
    return isset($item['path']) && $item['path'] === $path;
};
?>
<aside class="left-sidebar">
    <div class="scroll-sidebar">
        <div class="user-profile">
            <div class="user-pro-body d-flex align-items-center">
                <div class="me-3">
                    <div class="rounded-circle bg-info text-white d-flex align-items-center justify-content-center" style="width:48px;height:48px;">
                        <i class="fas fa-user"></i>
                    </div>
                </div>
                <div>
                    <h5 class="mb-1 text-white"><?php echo htmlspecialchars($userName, ENT_QUOTES, 'UTF-8'); ?></h5>
                    <?php if ($userEmail !== ''): ?>
                        <small class="text-muted d-block"><?php echo htmlspecialchars($userEmail, ENT_QUOTES, 'UTF-8'); ?></small>
                    <?php endif; ?>
                    <?php if ($role): ?>
                        <span class="badge bg-light text-dark mt-2 text-uppercase"><?php echo htmlspecialchars((string) $role, ENT_QUOTES, 'UTF-8'); ?></span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <nav class="sidebar-nav">
            <ul id="sidebarnav">
                
                <li class="<?php echo $currentPath === '/dashboard' ? 'active' : ''; ?>">
                    <a class="waves-effect waves-dark <?php echo $currentPath === '/dashboard' ? 'active' : ''; ?>" href="<?php echo htmlspecialchars(route('/dashboard'), ENT_QUOTES, 'UTF-8'); ?>">
                        <i class="icon-speedometer"></i>
                        <span class="hide-menu">Dashboard</span>
                    </a>
                </li>
                <?php foreach ($modules as $module): ?>
                    <?php
                    $moduleRoles = $module['roles'] ?? [];
                    if (!$hasAccess($moduleRoles, $role)) {
                        continue;
                    }

                    $items = $module['items'] ?? [];
                    $visibleItems = [];
                    foreach ($items as $item) {
                        $itemRoles = $item['roles'] ?? $moduleRoles;
                        if ($hasAccess($itemRoles, $role)) {
                            $visibleItems[] = $item;
                        }
                    }

                    if ($visibleItems === []) {
                        continue;
                    }

                    $moduleActive = false;
                    foreach ($visibleItems as $item) {
                        if ($isItemActive($item, $currentPath)) {
                            $moduleActive = true;
                            break;
                        }
                    }

                    $moduleIcon = $module['icon'] ?? 'fas fa-layer-group';
                    ?>
                    <li class="<?php echo $moduleActive ? 'active' : ''; ?>">
                        <a class="has-arrow waves-effect waves-dark <?php echo $moduleActive ? 'active' : ''; ?>" href="javascript:void(0)" aria-expanded="<?php echo $moduleActive ? 'true' : 'false'; ?>">
                            <i class="<?php echo htmlspecialchars($moduleIcon, ENT_QUOTES, 'UTF-8'); ?>"></i>
                            <span class="hide-menu">
                                <?php echo htmlspecialchars($module['label'] ?? 'Modul', ENT_QUOTES, 'UTF-8'); ?>
                            </span>
                        </a>
                        <ul aria-expanded="<?php echo $moduleActive ? 'true' : 'false'; ?>" class="collapse <?php echo $moduleActive ? 'show' : ''; ?>">
                            <?php foreach ($visibleItems as $item): ?>
                                <?php
                                $itemActive = $isItemActive($item, $currentPath);
                                $itemIcon = $item['icon'] ?? 'far fa-circle';
                                $itemPath = route((string) ($item['path'] ?? '#'));
                                ?>
                                <li class="<?php echo $itemActive ? 'active' : ''; ?>">
                                    <a href="<?php echo htmlspecialchars($itemPath, ENT_QUOTES, 'UTF-8'); ?>" class="<?php echo $itemActive ? 'active' : ''; ?>">
                                        <i class="<?php echo htmlspecialchars($itemIcon, ENT_QUOTES, 'UTF-8'); ?> me-2 text-muted"></i>
                                        <?php echo htmlspecialchars($item['label'] ?? 'Modul', ENT_QUOTES, 'UTF-8'); ?>
                                    </a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </li>
                <?php endforeach; ?>
                <li class="nav-devider"></li>
                <li>
                    <a class="waves-effect waves-dark" href="<?php echo htmlspecialchars(route('/logout'), ENT_QUOTES, 'UTF-8'); ?>">
                        <i class="fas fa-sign-out-alt text-danger"></i>
                        <span class="hide-menu">Log Keluar</span>
                    </a>
                </li>
            </ul>
        </nav>
    </div>
</aside>
