<?php
$pageScripts = <<<'SCRIPT'
<script>
    document.addEventListener('DOMContentLoaded', function () {
        if (!window.jQuery) {
            return;
        }

        const $table = $('#template-table');

        if (!$table.length || $.fn.DataTable.isDataTable($table)) {
            return;
        }

        $table.DataTable({
            ajax: {
                url: 'data/template-data.json',
                dataSrc: 'data'
            },
            columns: [
                { data: 'name', title: 'Nama' },
                { data: 'role', title: 'Peranan' },
                { data: 'department', title: 'Jabatan' },
                { data: 'status', title: 'Status' },
                { data: 'updated_at', title: 'Kemaskini Terakhir' }
            ],
            responsive: true,
            processing: true,
            dom: 'Bfrtip',
            buttons: ['copy', 'csv', 'excel', 'pdf', 'print'],
            language: {
                emptyTable: 'Tiada rekod buat masa ini',
                processing: 'Sedang memproses...'
            }
        });
    });
</script>
SCRIPT;

require_once __DIR__ . '/header.php';
?>
<!-- ============================================================== -->
        <!-- End Topbar header -->
        <!-- ============================================================== -->
        <?php include("sidebar.php");?>
        <!-- ============================================================== -->
        <!-- Page wrapper  -->
        <!-- ============================================================== -->
<!-- ============================================================== -->
        <!-- Page wrapper  -->
        <!-- ============================================================== -->
        <div class="page-wrapper">
            <!-- ============================================================== -->
            <!-- Container fluid  -->
            <!-- ============================================================== -->
            <div class="container-fluid">
                
                <!-- ============================================================== -->
                <!-- Start Page Content -->
                <!-- ============================================================== -->
                <div class="row page-titles">
                    <div class="col-md-5 align-self-center">
                        <h4 class="text-themecolor">Contoh Jadual</h4>
                    </div>
                    <div class="col-md-7 align-self-center text-end">
                        <div class="d-flex justify-content-end align-items-center">
                            <ol class="breadcrumb justify-content-end">
                                <li class="breadcrumb-item"><a href="dashboard.php">Laman Utama</a></li>
                                <li class="breadcrumb-item active">Contoh Jadual</li>
                            </ol>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title mb-0">Data Template</h4>
                                <p class="card-subtitle">Jadual ini memuatkan data contoh daripada fail JSON luaran.</p>
                                <div class="table-responsive m-t-20">
                                    <table id="template-table" class="table table-striped table-bordered display nowrap" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th>Nama</th>
                                                <th>Peranan</th>
                                                <th>Jabatan</th>
                                                <th>Status</th>
                                                <th>Kemaskini Terakhir</th>
                                            </tr>
                                        </thead>
                                        <tfoot>
                                            <tr>
                                                <th>Nama</th>
                                                <th>Peranan</th>
                                                <th>Jabatan</th>
                                                <th>Status</th>
                                                <th>Kemaskini Terakhir</th>
                                            </tr>
                                        </tfoot>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

<?php require_once __DIR__ . '/footer.php'; ?>
